	pro	uleis_sit_smoosh_custom_rev1
;	
;	routine to make uleis_sit_smoosh plots 
;
;		Modification history:
;			17-Feb-2012	adapted from uleis_sit_smoosh_status /gm
;			24-Apr-2013	introduce variable output plot formats for different spacecraft configurations /gm
;			14-Apr-2015	order plots according to prompt, label locations, add Richardson event times /gm
;

;
;		timeCDS: timeCDS, $	; Time structure for some function calls: MJD, millisec_of_day
		timeCDS = { MJD: 0L , TIME: 0L }
	sc_names = ['ACE','STEREO-A','STEREO-B']
	stereo_names = ['a','b']

	status_flag = 0
;
	read, year_last, doy_last, plot_length, prompt='Enter year, doy of start of plot, plot length (days): '
	plot_order = fltarr(3)
	longitude = fltarr(3)
	for i = 0, 2 do begin
		if( i eq 0 ) then read, plot, long,  prompt='Enter spacecraft #, and flare longitude for plots order top plot: (0 = stereo-b;  1 = ACE; 2 = stereo-a): '
		if( i eq 1 ) then read, plot, long,  prompt='Enter spacecraft #, and flare longitude for plots order middle plot: (0 = stereo-b;  1 = ACE; 2 = stereo-a): '
		if( i eq 2 ) then read, plot, long,  prompt='Enter spacecraft #, and flare longitude for plots order bottom plot: (0 = stereo-b;  1 = ACE; 2 = stereo-a): '
		plot_order(i) = plot
		longitude(i) = long
	endfor
	spacecraft_name = ['STEREO-B SIT', 'ACE / ULEIS', 'STEREO-A SIT']
	
;	******************** section to make data files and plots
	pha_file = strarr(3)   ; pha file name to be passed to main_romsave
	sav_file = strarr(3)   ; sav file name to be used for plots

;	calculate the start and stop days of the new plot
	mjd_start = date2mjd(year_last, doy_last)
	mjd2date, mjd_start, year_start, month_start, day_start
	doy_start = mjd_start - date2mjd(year_start,1,1) + 1.

	mjd_stop = mjd_start + plot_length
	mjd2date, mjd_stop, year_stop, month_stop, day_stop
	doy_stop = mjd_stop - date2mjd(year_stop,1,1) + 1. 

;	********************** update the udf_lister.cfg file and then run udf_lister ********************
	input_line = strarr(100)
	input_string = ''
	openr, lun_input, '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/udf_lister_control/udf_lister.cfg', /get_lun	
	line_count = 1
	while( ~eof(lun_input) ) do begin
		readf, lun_input, input_string
		input_line(line_count) = input_string
		line_count ++
	endwhile
	line_count --
	free_lun, lun_input
                        
	openw, lun_output, '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/udf_lister_control/udf_lister.cfg', /get_lun	
	for i = 1, 6 do printf, lun_output, input_line(i), format="(a)"
;	save the output file name for later use by main_romsave	
	pha_file(0) = string(year_start, doy_start, year_stop, doy_stop, format = "('_',i4,'_',i3.3,'_',i4,'_',i3.3,'.pha')" ) ; _2012_011_2012_021.pha
	printf, lun_output, pha_file(0)
;	now add the extension that will be put on the output file name by udf_lister:
	pha_file(0) += ';1'
;	now add the lead portion from the script_mass file
	pha_file(0) = 'wphasmoo' + pha_file(0)
	for i = 8, 35 do printf, lun_output, input_line(i), format="(a)"
	printf, lun_output, year_start, doy_start,0,0, format="(4(i5,','))"
	for i = 37, 37 do printf, lun_output, input_line(i), format="(a)"
	printf, lun_output, year_stop, doy_stop,0,0, format="(4(i5,','))"
	for i = 39, line_count do printf, lun_output, input_line(i), format="(a)"
	free_lun, lun_output
	
	spawn, '/data/joey/masongm1/Programs/fortran_vax/udf_lister/udf_lister'	
;	stop	

;	******************** now update the STEREO times files and then run sdf_lister ***************
	for i = 0, 1 do begin
		times_file = '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/sit_' + stereo_names(i) + '_lister_control/sit_lister_times.dat'
		openr, lun_input, times_file, /get_lun
		readf, lun_input, input_string
		free_lun, lun_input
		openw, lun_output, times_file, /get_lun
		printf, lun_output, input_string
;*		printf, lun_output, year_start, month_start, day_start, 0, 0, year_start, month_start, day_start+1, 0, 0, 3, format = "(11i6)"
		printf, lun_output, year_start, month_start, day_start, 0, 0, year_stop, month_stop, day_stop, 0, 0, 3, format = "(11i6)"
		free_lun, lun_output	
		
		spawn,  'idl -quiet /data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/sit_' + stereo_names(i) + '_lister_control/sit_update_' + stereo_names(i) + '.batch'		
		pha_file(i+1) = string(stereo_names(i),year_start, doy_start, format="( 'SIT_', a, '_', i4, '_', i3.3, '_multi_panel_smoosh.txt')"  )  ; SIT_A_2009_309_multi_panel_smoosh.txt

;		remove the 2 unused data files produced by the sit_lister run
		spawn, 'rm ' + '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/output_data_files/' + replace_text(pha_file(i+1),'smoosh','pha')
		spawn, 'rm ' + '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/output_data_files/' + replace_text(pha_file(i+1),'smoosh','rates')

	endfor



;	********************* now make the sav files using the readdata_struct subroutine ************************

	nmax_row = 1.e6
	for i = 0, 2 do begin
		folder =  '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/output_data_files/'
		sav_file(i)  = strmid( pha_file(i), 0, strpos( pha_file(i), '.pha')) + '.sav'		
		if( i eq 0 ) then begin 
			readdata_struct_xdf, folder + pha_file(i), nmax_row, xdf 
			sav_file(i)  = strmid( pha_file(i), 0, strpos( pha_file(i), '.pha')) + '.sav'	
		endif else begin
			sitdata_struct_xdf, folder + pha_file(i),xdf
			sav_file(i)  = strmid( pha_file(i), 0, strpos( pha_file(i), '.txt')) + '.sav'	
		endelse
		folder = '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/pha_save_files/'
		save, xdf, filename= folder + sav_file(i)
	endfor
;	now rearrange the sav file names to the order:  -b, ace, -a
	sav_file = [sav_file(2),sav_file(0),sav_file(1)]


;	*********************** now make the plot ********************************

;	this is just a slightly modified version of uleis_sit_smoosh.pro, pasted here so variables can be passed easily

;	pro uleis_sit_smoosh, temp0, temp1, temp4, temp5


; routine to plot ULEIS and SIT combined smoosh
; 
;	Original version:  23-June-2010   /gm
;		adapted from uleis_rate_spectrogram.pro
;		based on programs by Mihir Desai:  romrates_rec.pro & uleis_webplots_smoosh.pro
;		17-Feb-2012	modify to be called from within uleis_sit_smoosh_update.pro /gm
;
;	Parameters passed to program
;			temp0 = start YYYY
;			temp1 = start DOY
;			temp4 = stop YYYY
;			temp5 = stop DOY
;

;
;		timeCDS: timeCDS, $	; Time structure for some function calls: MJD, millisec_of_day
		timeCDS = { MJD: 0L , TIME: 0L }

	temp0 = year_start
	temp1 = doy_start
	temp4 = year_stop
	temp5 = doy_stop


forward_function showmatrix

constant_vel  = (1.6022e-19*1e6*2)/1.6726e-27
constant_dist =  1.49597870691e11
constant_time  = 3600



	mjd_start = date2mjd(temp0,temp1)
	mjd_stop = date2mjd(temp4,temp5)
	

;	********** set up time_array which is basic array for IDL routines **********

	time_array=[temp0, temp1, 0, 0, temp4, temp5, 0, 0]

	year_string = string(temp0,format="(i4)")

n_days = mjd_stop - mjd_start

stime = time_array(2)			; ref times for timebox call
etime = n_days*24. + time_array(2)
tst = time_array(0:1)   ; < start time of time box call 


; ************************* read in data and set up variables to plot ****************************

;*	nextplot:
;	calculate mid date of plot: 
	mid_mjd = (mjd_start + mjd_stop)/2.
	
	

;	*************************************************************************************************
	for plot_number = 0,2 do begin   ; note:  sav_files are: 0 = ace; 1 = -a; 2 = -b
;			plot order: plot_number = 0, top
;						plot_number = 1, middle
;						plot_number = 2, bottom

		folder = '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/pha_save_files/'

		plot_labels = [spacecraft_name(plot_order(0)), spacecraft_name(plot_order(1)), spacecraft_name(plot_order(2)) ]
		restore, folder + sav_file( plot_order( plot_number) ) 
		print, 'restoring: ', sav_file( plot_order( plot_number) )

;		put into 1-d arrays taking account xdf.data struture in ACE is different from SIT (!)
		if( plot_order( plot_number) eq 1 ) then begin
			year = xdf.data(*,0)
			day = xdf.data(*,1)
			tof2_mass = xdf.data(*,3)
			tof_einc = xdf.data(*,4)
		endif else begin
			year = xdf.data(0,*)
			day = xdf.data(1,*)
			tof2_mass = xdf.data(3,*)
			tof_einc = xdf.data(4,*)
		endelse
	




		locs = where(  (date2mjd(year,floor(day)) ge mjd_start) and $	        
			      (date2mjd(year,floor(day)) lt mjd_stop) )
;		these arrays contain just the data for the dates requested
		year = year(locs)
		day = day(locs)
		tof2_mass = tof2_mass(locs)
		tof_einc = tof_einc(locs)
	
; 		Convert Energy/nuc. into 1./velocity (hour/AU)
; 		given energy of particle in MeV/nucleon
; 		velocity  = 1./((sqrt(constant_vel*energy_nuc)*constant_time)/constant_dist)
		inv_velocity = 1./((sqrt(constant_vel*tof_einc)*constant_time)/constant_dist) 
;		make array of hours since plot start time
		hours = ( date2mjdfract( year, day) - mjd_start ) * 24.0
;	********** the plotted variables are hours (x-axis) vs hours/au (y-axis)
			      
			      



;	************************* set up the image array *************************
		data_size = size(hours)
		number_data_points = data_size(1)   ; number of points in the plot

;		set up the image
		bin1 = (mjd_stop - mjd_start)*24.0/600.     ; 600 points on x-axis
		bin2 = (20.0 - 0.0)/150                               ; 150 points on y-axis
		max1 = (mjd_stop - mjd_start)*24.0
		max2 = 20.
		min1 = 0.
		min2 = 0.

		if( plot_number eq 0 ) then xy_image_0 = hist_2d(hours,inv_velocity,bin1=bin1,bin2=bin2,max1=max1,max2=max2,min1=min1,min2=min2)
		if( plot_number eq 1 ) then xy_image_1 = hist_2d(hours,inv_velocity,bin1=bin1,bin2=bin2,max1=max1,max2=max2,min1=min1,min2=min2)
		if( plot_number eq 2 ) then xy_image_2 = hist_2d(hours,inv_velocity,bin1=bin1,bin2=bin2,max1=max1,max2=max2,min1=min1,min2=min2)

;		end of data input loop
	endfor    ;  variable is:  plot_number

;	find the maximum and minimum (but not zero) values
	n_max_0 = max(xy_image_0)
	n_max_1 = max(xy_image_1)
	n_max_2 = max(xy_image_2)
	n_max = max([n_max_0,n_max_1,n_max_2])
	
	locs = where( xy_image_0 gt 0 )   ; just look at one of the arrays for minimum value, since almost always = 1
	temp = xy_image_0(locs)
	n_min = min(temp)
		
;	set up the color scaling -- array xy_image contains the spectrogram information	
;	all three spectrograms are scaled the same way so they can be compared
	
	xy_image_0 = (7+218*(xy_image_0-n_min)/(n_max-n_min))*(xy_image_0 ge n_min)
  	xy_image_0 = xy_image_0*(xy_image_0 le 218)+218*(xy_image_0 gt 218)
	xy_image_1 = (7+218*(xy_image_1-n_min)/(n_max-n_min))*(xy_image_1 ge n_min)
  	xy_image_1 = xy_image_1*(xy_image_1 le 218)+218*(xy_image_1 gt 218)
	xy_image_2 = (7+218*(xy_image_2-n_min)/(n_max-n_min))*(xy_image_2 ge n_min)
  	xy_image_2 = xy_image_2*(xy_image_2 le 218)+218*(xy_image_2 gt 218)


	
;	*************************************************************************	


;	*************************** plotting section ****************************
; set the plotting device

dme = 1

 plots_across = 1 ; # of plots across the page
 plots_down = 3; # of plots down the page 
   
!p.multi=[0,plots_across,plots_down,0,0]    

location = fltarr(plots_down,4)

location(0,*) = [0.09,0.6,0.8,0.85]
location(1,*) = [0.09,0.34,0.8,0.59]
location(2,*) = [0.09,0.08,0.8,0.33]


;	make string for output ps file name
        sh_tim = string(time_array(0),time_array(1),time_array(4),time_array(5), format="(i4,'_',i3.3,'_',i4,'_',i3.3)")
	output_directory= '/data/joey/masongm1/Programs/idl_SIT/uleis_sit_smoosh_custom/uleis_sit_smoosh_custom_ps_files/'
 	psfilename = output_directory + "uleis_sit_smoosh_"+sh_tim+".ps"     ;***
    dev = 'ps'
    set_plot,dev
    
     device,/color,/landscape,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
     device,xsize=26,ysize=20
     device,xoff=1.25,yoff=28.0
    !p.color=1  
    !p.font=0

; 	set plot characteristics
	!p.thick    = 2
	!p.charsize=1.1
   	!x.ticklen  = 0.04
   	!y.ticklen  = 0.02   
   	!x.thick=2
   	!y.thick=2
   	ssize = 0.9
   	lthick = 1.2
   	csize=2.5   ; was 1.5

   ; 	set up a simple color table
   loadct,27
   common colors, r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
   r_curr(1) = 0
   g_curr(1) = 0
   b_curr(1) = 0
   r_curr(2) = 255b
   g_curr(2) = 0
   b_curr(2) = 0
   r_curr(3) = 0
   g_curr(3) = 255b
   b_curr(3) = 0
   r_curr(4) = 0
   g_curr(4) = 0
   b_curr(4) = 255b
   r_curr(219) = 0
   g_curr(219) = 0
   b_curr(219) = 0
   tvlct,r_curr,g_curr,b_curr     
   
; *********** constants for the log energy axis on right side of panels
major_velocity_values = fltarr(4)
major_energy_values = [0.022533666,0.1,1.0,10.0]
major_velocity_values = 1./((sqrt(constant_vel*major_energy_values)*constant_time)/constant_dist) 

minor_velocity_values = fltarr(22)
minor_energy_values = [0.03,0.04,0.05,0.06,0.08,0.09,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,2,3,4,5,6,7,8,9]
minor_velocity_values = 1./((sqrt(constant_vel*minor_energy_values)*constant_time)/constant_dist)  
min_string = strarr(22) 
min_string = string(minor_energy_values)

;************ plot the 3 panels **************
	for plot_no = 0, 2 do begin

!x.window = [location(plot_no,0),location(plot_no,2)]       
!y.window = [location(plot_no,1),location(plot_no,3)]    

;	*********** print the spectrogram portion **************	
	if( plot_no eq 0 ) then showmatrix,xy_image_0,/useaxes
	if( plot_no eq 1 ) then showmatrix,xy_image_1,/useaxes
	if( plot_no eq 2 ) then showmatrix,xy_image_2,/useaxes

;	*********** now print the time box ** this must follow spectrogram call *******
;	*********** so that the axis isn't blocked by the spectrogram *****************

!p.color = 1
!p.position = location(plot_no,*)                                                                                                  
crangex = [stime,etime]

rangey=[0,20]
!y.tickname = ['0','5','10','15','20']
!y.ticks    = 4
!y.minor    = 5
!y.tickv     = [0,5,10,15,20]

	if( plot_no eq 2 ) then nolabels = 0 else nolabels = 1

      timebox, stime, etime,/zero,exact=exact, day=tst,ytype=0, $
      yrange = rangey, yexact = 1, charsize=csize/1.3,$
      ytitle='1/Ion Speed (hour/AU)', $
;      title = title_str, $
      nolabels=nolabels, minutes = minutes, date = 1,noerase = 1   

;	************** for the top plot, plot the top data axis ************
	if( plot_no eq 0) then begin
		time_ticks = stime + indgen(n_days+1)*24
		date_string = strarr(n_days +1)
		result = get_date_string(time_array,date_string)	
		for i = 0, n_days do begin
  		xyouts,/data,time_ticks(i),rangey(1)*1.05,date_string(i),align =0.5,charsize=csize/3.
		endfor
	endif
	


; ********** now plot the log energy axis on right side *****************
maj_tick = (216. + 5.)/216.
min_tick = (216. + 3.)/216.
str_tick = (216. + 6.)/216.

majlos = 0L
while (majlos lt n_elements(major_velocity_values)) do begin
  plots,/data,[etime,etime*maj_tick],[major_velocity_values(majlos),major_velocity_values(majlos)],thick=2  
  energy_string = strcompress(string(format='(g6.3)',major_energy_values(majlos)))
  xyouts,/data,etime*str_tick,major_velocity_values(majlos),energy_string,charsize = csize/2.5
 majlos = majlos + 1
endwhile
 
 minlos = 0L
while (minlos lt n_elements(minor_velocity_values)) do begin
  plots,/data,[etime,etime*min_tick],[minor_velocity_values(minlos),minor_velocity_values(minlos)],thick=2
 minlos = minlos + 1
endwhile


; *********** end of log energy axis *************   


;	************ now plot the shock times if any *******
	cme_times = get_richardson_times()
	for i = 0, n_elements(cme_times) - 1 do begin
		if( (cme_times(i) ge mjd_start) and (cme_times(i) lt mjd_stop) ) then begin
				cme_loc = (cme_times(i) - mjd_start)*24.0
				plots,/data, [cme_loc, cme_loc], [0., 20.], linestyle = 0, thick=8, color = 212	
;				stop
		endif
	endfor 
 
 
;	end of 3 panel loop
	endfor
   
   
; 	*********** Top label ***************
		xyouts,/norm,0.09,0.90,'Mass Range = 10-70 AMU',charsize=csize/3.5,align=0.0

;	*********** plot creation time   
	xyouts,/norm,0.72,0.93,'Created-'+systime(),align=0,charsize = csize/4.5

;	*********** plot labels - spacecraft names
	y_values = [0.83, 0.57, 0.31]
	for i = 0, 2 do begin
		if( longitude(i) lt 0. ) then east_west = 'E' else east_west = 'W'
		xyouts,/norm,0.60,y_values(i),string(plot_labels(i),east_west, abs(longitude(i)), format="(a,x,a,i3)"),align=0,charsize = csize/2.5
	endfor

  	
;   xyouts,/norm,0.65,0.57,plot_labels(1),align=0,charsize = csize/2.5
;   xyouts,/norm,0.65,0.31,plot_labels(2),align=0,charsize = csize/2.5


;	*********** label on right y axis
	for i = 0,2 do xyouts,/norm,0.89, 0.16+0.26*i,'Energy (MeV/n.)',orientation=90,align=0,charsize = csize/2.5


;	************ now plot the color bar ****************
color_index = intarr(212)
color_index = indgen(212)+7

color_bar_edge = 0.82
x_vals = [color_bar_edge,color_bar_edge+0.02]
y_vals = fltarr(212)
y_frac = indgen(212)*0.0006

cnos = 0L
while(cnos lt 212) do begin
   y_vals(cnos) = 0.36 + y_frac(cnos)
   plots,/norm,x_vals + 0.1,[y_vals(cnos),y_vals(cnos)],color=color_index(cnos),thick=1.5
   cnos = cnos + 1
endwhile

max_string = strarr(1)
max_string = strcompress(string(format='(g8.3)',n_max))
min_string = strarr(1)
min_string = strcompress(string(format='(g8.3)',n_min))
xyouts,/norm,color_bar_edge+0.13,y_vals(0),min_string,charsize=csize/2.5,align=0
xyouts,/norm,color_bar_edge+0.13,y_vals(202),max_string,charsize=csize/2.5,align=0
xyouts,/norm,color_bar_edge+0.145,0.35,'Intensity',orientation=90,align=-0.5,charsize = csize/2.5

;	************ end of color bar plotting *************







; close plotting device
      device,/close

;*
;*	goto, nextplot

	status_flag = 1   ; 	set flag so plot to be made will be transferred to ftp site
;    	exit, status = status_flag   ; signal new plot was made  

	stop

end


