pro sit_carr_Fe_spectrogram

; routine to plot SIT ratespectrograms over Carrington rotations
; 
;	Original version:  12-Sept-2011   /gm
;		adapted from program uleis_carr_3He_Fe_spectrograms,
;			(based on pgm by Mihir Desai)

forward_function showmatrix, carr_long,  process_Fe_point
		spacecraft_name = ['a','b']

; ************************* restore the uleis data *******************************

	read, spacecraft, prompt='Enter 0 for STEREO-A, 1 for STEREO-B: '

;	restore xdf file data if not read in
	if(n_elements(data) eq 0 ) then begin
		sav_directory = '/data/joey/masongm1/Data/Data_L1_flight/STEREO/idl_sav/'
		for iyear = 2007, 2012 do begin
			file_name = "sit_" + spacecraft_name(spacecraft) + "_phaflux_1_hr_" + string(iyear,format="(i4)")+".sav
			print, ' restoring file:  ',file_name
			restore, sav_directory + file_name
;	concatenate the data arrays
			if( iyear eq 2007 ) then data = xdf.data else data = [data, xdf.data]
		endfor
		endif
;	free up memory from the last data arry
	xdf.data = 0

	read, averaging_interval, prompt = 'Enter number of hours to test for each point (must be odd number): '



; ************************* get start and stop times ****************************

read, temp0, temp1, prompt = 'Enter start YYYY, DOY: '
read, temp4, temp5, prompt = 'Enter stop YYYY, DOY: '
time_array=[temp0, temp1, 0, 0, temp4, temp5, 0, 0]

mjd_start = date2mjd(time_array(0),time_array(1)) + time_array(2)/24.0 + time_array(3)/1440.0
mjd_stop = date2mjd(time_array(4),time_array(5)) + time_array(6)/24.0 + time_array(7)/1440.0

n_days = mjd_stop - mjd_start

stime = time_array(2)			; ref times for timebox call
etime = n_days*24. + time_array(2)
tst = time_array(0:1)   ; < start time of time box call 

;	print header line for output lines:   5/25/2010 /gm
	print, 'time_now, carr_long_now, carr_long_last, carr_rot_index'

;	************************* set up the image array *************************
	data_size = size(data)       ; data_size = vector; 1st element = #dim, then #dim 1, # dim 2, etc. 


	xy_image=fltarr(300, 36)   ; room for 300 solar rotations
	xy_norm = fltarr(300,36)   ; array for normalizing the image to get intensities right
	carr_rot_index = 0.
	carr_long_last = 360.
	for i = 0UL, data_size(1)-1 do begin
		time_now = date2mjd(data(i,0),data(i,1)) + (data(i,1)-fix(data(i,1)))
		
		if( (time_now ge mjd_start) and (time_now le mjd_stop) ) then begin
		
;		see if we've just crossed a Carrington rotation boundary -- if so carr_long will increase rather than decrease
		carr_long_now = carr_long(time_now)
;		print,carr_long_now
		if( carr_long_now gt carr_long_last ) then begin
			carr_rot_index ++
			print, mjd2str(time_now), carr_long_now, carr_long_last, carr_rot_index
		endif
		carr_long_last = carr_long_now


			carr_index = fix(carr_long_now/10.)
;			print,carr_index
			if( (carr_index lt 0) or (carr_index gt 35) ) then stop

			if(  (i + (averaging_interval -1)/2.) le (data_size(1)-1) ) then $

					process_Fe_point, data, spacecraft, carr_rot_index, carr_index, xy_image, xy_norm, i, averaging_interval, point_added, ratio, intensity_Fe     ; add in this point if it meets intensity and Fe/O ratio tests

			if( point_added ) then begin
				mjd2date,time_now, yearnow, monthnow, daynow
				print, 'Fe: ', yearnow, monthnow, daynow, carr_long_now, ratio, intensity_Fe, format="(a, 2x, i4, 2i3, 2f6.1, f10.3)"
			endif

		endif
	endfor
	
print, 'finished loop: ', carr_long_now, carr_long_last, carr_rot_index	

;	stop
;	renormalize the image to keep intensities normalized
	image_size = size(xy_image)
	for i = 0, (image_size(1) -1) do for j = 0, (image_size(2) - 1) do if( xy_norm(i,j) gt 0.) then xy_image(i,j) /= float(xy_norm(i,j))     	
;	stop
;		
;	trim the image array
	number_data_points = carr_rot_index
	xy_image = xy_image(0:number_data_points,*)

	max_val = max(xy_image)
	min_val = 1e6
	for i = 0, number_data_points  do for j = 0, 35 do if ((xy_image(i,j) gt 0) and (xy_image(i,j) lt min_val)) then min_val = xy_image(i,j)

	n_min = alog10(min_val)
	n_max = alog10(max_val)

;	set any zero values to the minimum value in the table
	for i = 0, number_data_points  do for j = 0, 35 do if (xy_image(i,j) le 0)  then xy_image(i,j) = min_val

;	take the log
	xy_image = alog10(xy_image)


	
;	set up the color scaling -- array xy_image contains the spectrogram information	
	xy_image = (7+218*(xy_image-n_min)/(n_max-n_min))*(xy_image ge n_min)

;	*************************************************************************	


;	*************************** plotting section ****************************
; set the plotting device

dme = 1

 plots_across = 1 ; # of plots across the page
 plots_down = 1; # of plots down the page 
   
!p.multi=[0,plots_across,plots_down,0,0]    
location = fltarr(plots_down,4)
location(0,*) = [0.20888,0.2,0.78999,0.65]


;	make string for output ps file name
        sh_tim = string(time_array(0),time_array(1),time_array(4),time_array(5), format="(i4,'_',i3.3,'_',i4,'_',i3.3)")
 	psfilename = "/data/joey/masongm1/Programs/idl_SIT/sit_spectrograms/sit_carr_3He_Fe_spectrograms/sit-" + spacecraft_name(spacecraft) + $
 		 "_"+sh_tim+ "_Fe.ps"     ;***
    dev = 'ps'
    set_plot,dev
    
     device,/color,/landscape,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
     device,xsize=26,ysize=20
     device,xoff=1.25,yoff=28.0
    !p.color=1  
    !p.font=0

; 	set plot characteristics
	!p.thick    = 2
	!p.charsize=1.1
   	!x.ticklen  = -0.04
   	!y.ticklen  = -0.02   
   	!x.thick=2
   	!y.thick=2
   	ssize = 0.9
   	lthick = 1.2
   	csize=1.5

   ; 	set up a simple color table
   loadct,27
   common colors, r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
   r_curr(1) = 0
   g_curr(1) = 0
   b_curr(1) = 0
   r_curr(2) = 255b
   g_curr(2) = 0
   b_curr(2) = 0
   r_curr(3) = 0
   g_curr(3) = 255b
   b_curr(3) = 0
   r_curr(4) = 0
   g_curr(4) = 0
   b_curr(4) = 255b
   r_curr(219) = 0
   g_curr(219) = 0
   b_curr(219) = 0
   tvlct,r_curr,g_curr,b_curr     

!x.window = [location(0,0),location(0,2)]       
!y.window = [location(0,1),location(0,3)]    


;	*********** reformat the array & print the spectrogram portion **************
	start_x = (number_data_points+1.)*30.
	start_y = 360

	xy_image = rebin(xy_image,start_x,start_y)	
		
  	showmatrix,xy_image,/useaxes


;	*********** now print the time box ** this must follow spectrogram call *******
;	*********** so that the axis isn't blocked by the spectrogram *****************

!p.color = 1
!p.position = location(0,*)                                                                                                  
crangex = [stime,etime]

rangey=[360., 0.]
factor = 45.
;	compute the 9 y tic values
	y_tic_val = strarr(9)
	for i = 0, 8 do y_tic_val(i) = string(i*factor, format="(i3)")
	!y.tickname = y_tic_val
!y.ticks    = 8
!y.minor    = 0
!y.tickv     = indgen(11)*factor
title_str = string(spacecraft_name(spacecraft),0.273, 'Fe', averaging_interval, format="('STEREO-',a,' SIT ',f5.2, ' MeV/n ',a,2x,i2,' hour avg.')")

      timebox, stime, etime,/zero,exact=exact, day=tst,ytype=0, $
      yrange = rangey, yexact = 1, charsize=csize/1.3,$
      ytitle='Carrington Longitude', $
       title=title_str, $
      nolabels=0, minutes = minutes, date = 1,noerase = 1   
   
;	*********** plot creation time   
   xyouts,/norm,0.65,0.70,'Created-'+systime(),align=0,charsize = csize/2.


;	************ now plot the color bar ****************
color_index = intarr(212)
color_index = indgen(212)+7

color_bar_edge = 0.82
x_vals = [color_bar_edge,color_bar_edge+0.02]
y_vals = fltarr(212)
y_frac = indgen(212)*0.0006

cnos = 0L
while(cnos lt 212) do begin
   y_vals(cnos) = 0.36 + y_frac(cnos)
   plots,/norm,x_vals,[y_vals(cnos),y_vals(cnos)],color=color_index(cnos),thick=1.5
   cnos = cnos + 1
endwhile

max_string = strarr(1)
max_string = strcompress(string(format='(g8.3)',max_val))
min_string = strarr(1)
min_string = strcompress(string(format='(g8.3)',min_val))
xyouts,/norm,color_bar_edge+0.03,y_vals(0),min_string,charsize=csize/1.5,align=0
xyouts,/norm,color_bar_edge+0.03,y_vals(202),max_string,charsize=csize/1.5,align=0
xyouts,/norm,color_bar_edge+0.045,0.35,'Intensity',orientation=90,align=-0.5,charsize = csize/1.5

;	************ end of color bar plotting *************

; close plotting device
      device,/close


end


	
	
	pro process_Fe_point, data, spacecraft, carr_rot_index, carr_index, xy_image, xy_norm, i, averaging_interval, point_added, ratio, intensity_Fe


	
;	energy intervals:  add Fe columns (0.193, 0.273, 0.386 MeV/n) 
;	columns start at 98 (sit-a) and 94 (sit-b) for Fe
;	for O:  65 (sit-a) and 61 (sit-b)


;	time intervals:  add intervals from hour (i - (averaging_interval -1)/2.) to (i + (averaging_interval -1)/2.)
	time_low = i - (averaging_interval -1)/2.
	time_high = i + (averaging_interval -1)/2.

	point_added = 0 ; flag for whether or not a data point is added in this routine
	
	intensity_Fe = 0.
	if( spacecraft eq 0 ) then Fe_index_low = 98 else Fe_index_low = 94
	for i_time = time_low, time_high do for j = 0, 2 do intensity_Fe += data(i_time,Fe_index_low+j)


;	check number of non-zero points:
	n_points = 0
	for i_time = time_low, time_high do for j = 0,2 do if( data(i_time,Fe_index_low + j) gt 0) then n_points ++

	if( n_points lt 4 ) then goto, finish

	if( intensity_Fe eq 0 ) then goto, finish
	intensity_Fe /= averaging_interval
	if( intensity_Fe gt 0.1 ) then goto, finish	;don't add in if intense event underway!


	
	intensity_O = 0.
	sigma_O = 0.	
	if( spacecraft eq 0 ) then O_index_low = 65 else O_index_low = 61
	for i_time = time_low, time_high do for j = 0, 2 do intensity_O += data(i_time,O_index_low+j)

;	check number of non-zero points:
	n_points = 0
	for i_time = time_low, time_high do for j = 0,2 do if( data(i_time,O_index_low + j) gt 0) then n_points ++
	if( n_points lt 4 ) then goto, finish


	if( intensity_O eq 0 ) then goto, finish
	intensity_O /= averaging_interval
		
	ratio = intensity_Fe/intensity_O
	if( ratio lt 0.8 ) then goto, finish
	
;	passes test so add in this point 
	xy_image(carr_rot_index, 35 - carr_index) += intensity_Fe
	xy_norm(carr_rot_index, 35 - carr_index) ++
;	if(xy_image(carr_rot_index, 35 - carr_index) gt 1.) then print, carr_rot_index, 35 - carr_index, intensity_fe, xy_image(carr_rot_index, 35 - carr_index), xy_norm(carr_rot_index, 35 - carr_index)
	point_added = 1
	
finish:
	end

	
	
