pro sit_pha_spectrogram_rev1

; routine to plot SIT PHA data
; 
;	Original version:  29-Mar-2010   /gm
;		adapted from program uleis_rate_spectrograms,
;			(based on pgm by Mihir Desai)

; ************************* restore the sit data *******************************
	input_file = ''
	read, input_file, prompt='Enter name of SIT lister pha sav file (no quotes): '

	input_file = strtrim( input_file, 2 ) 
	restore, input_file

	y_max = 200.  ; ns
	x_max = 20.  ;MeV
	x_min = 0.01
	y_min= 1.
	
	read, x_min, x_max, y_min, y_max, prompt='Enter x_min, x_max, y_min, y_max: '
	linear = 0
	if( (x_min eq 0) or (y_min eq 0) ) then linear = 1 else if( (x_max/x_min lt 20) or (y_max/y_min lt 20) ) then linear = 1

	read, nimage_x, nimage_y, prompt="Enter nimage_x, nimage_y: '	
		
	if( linear eq 0 ) then begin
		x_max = alog(x_max)
		y_max = alog(y_max)
		x_min = alog(x_min)
		y_min = alog(y_min)
	endif

;	************************* set up the image array *************************

	xy_image=fltarr(nimage_x,nimage_y)   

	for i = 0UL, nlines-1 do begin
			if(linear eq 0 ) then begin 
				ybin = (alog(array(1,i))-y_min)*nimage_y/(y_max-y_min)
				xbin= (alog(array(0,i))-x_min)*nimage_x/(x_max-x_min)
			endif else begin
				ybin = (array(1,i)-y_min)*nimage_y/(y_max-y_min)
				xbin= (array(0,i)-x_min)*nimage_x/(x_max-x_min)
			endelse		
			if( xbin ge 0) then $
				if (ybin ge 0) then $ 
					if(xbin lt nimage_x) then $ 
						if (ybin lt nimage_y ) then xy_image(xbin,ybin) ++
	endfor
	total_events = total(xy_image)
print, 'finished loop: '
;	

	max_val = max(xy_image)
	min_val = 1e6
	for i = 0, nimage_x-1  do for j = 0, nimage_y-1 do if ((xy_image(i,j) gt 0) and (xy_image(i,j) lt min_val)) then min_val = xy_image(i,j)

	n_min = alog10(min_val)
	n_max = alog10(max_val)
;	n_min = min_val
;	n_max = max_val


;	take the log or set = -4 as a flag
	for i = 0, (nimage_x-1) do for j = 0, (nimage_y-1) do if( xy_image(i,j) ge 0.) then xy_image(i,j) = alog10(xy_image(i,j)) else xy_image(i,j) = -4.  
;	for i = 0, (nimage_x-1) do for j = 0, (nimage_y-1) do if( xy_image(i,j) ge 0.) then xy_image(i,j) = (xy_image(i,j)) else xy_image(i,j) = -4.  
	
;	set up the color scaling -- array xy_image contains the spectrogram information	
	xy_image = (7+218*(xy_image-n_min)/(n_max-n_min))*(xy_image ge n_min)
  	xy_image = xy_image*(xy_image le 218)+218*(xy_image gt 218)

;	*************************************************************************	


;	*************************** plotting section ****************************
; set the plotting device

dme = 1

 plots_across = 1 ; # of plots across the page
 plots_down = 1; # of plots down the page 
   
!p.multi=[0,plots_across,plots_down,0,0]    
location = fltarr(plots_down,4)
location(0,*) = [0.20888,0.2,0.78999,0.65]


;	make string for output ps file name
	output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'
	
 	psfilename = output_folder + 'sit_matrix_plot.ps'     ;***
    dev = 'ps'
    set_plot,dev
    
     device,/color,/landscape,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
     device,xsize=26,ysize=20
     device,xoff=1.25,yoff=28.0
    !p.color=1  
    !p.font=0

; 	set plot characteristics
	!p.thick    = 2
	!p.charsize=1.1
   	!x.ticklen  = -0.04
   	!y.ticklen  = -0.02   
   	!x.thick=2
   	!y.thick=2
   	ssize = 0.9
   	lthick = 1.2
   	csize=1.5

   ; 	set up a simple color table
   loadct,27
   common colors, r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
   r_curr(1) = 0
   g_curr(1) = 0
   b_curr(1) = 0
   r_curr(2) = 255b
   g_curr(2) = 0
   b_curr(2) = 0
   r_curr(3) = 0
   g_curr(3) = 255b
   b_curr(3) = 0
   r_curr(4) = 0
   g_curr(4) = 0
   b_curr(4) = 255b
   r_curr(219) = 0
   g_curr(219) = 0
   b_curr(219) = 0
   tvlct,r_curr,g_curr,b_curr     

!x.window = [location(0,0),location(0,2)]       
!y.window = [location(0,1),location(0,3)]    

  x = !x.window[0]
  xsize = !x.window[1] - x
  y = !y.window[0]
  ysize = !y.window[1] - y



;	*********** reformat the array & print the spectrogram portion **************



	start_x = nimage_x
	start_y = nimage_y

	xy_image = rebin(xy_image,start_x,start_y)	

	tv, xy_image, x,y, xsize=xsize, ysize=ysize, /normal
;  	showmatrix,xy_image,/useaxes


;	*********** now print the time box ** this must follow spectrogram call *******
;	*********** so that the axis isn't blocked by the spectrogram *****************

!p.color = 1
!p.position = location(0,*)                                                                                                  



;	x-axis here***************

;	note: plot title and variable_namees come from save file
	if(linear eq 0 ) then plot, intarr(2),xrange=[exp(x_min),exp(x_max)],yrange=[exp(y_min),exp(y_max)],xstyle=1,ystyle=1,/xlog,/ylog, xtitle=variables(0), $
	     ytitle=variables(1), title = plot_title,/noerase, /nodata
	if(linear eq 1 ) then plot, intarr(2),xrange=[x_min,x_max],yrange=[y_min,y_max],xstyle=1,ystyle=1, xtitle=variables(0), $
	     ytitle=variables(1), title = plot_title,/noerase, /nodata
 
  
  
;	*********** plot creation time   
   xyouts,/norm,0.65,0.70,'Created-'+systime(),align=0,charsize = csize/2.


;	************ now plot the color bar ****************
color_index = intarr(212)
color_index = indgen(212)+7

color_bar_edge = 0.82
x_vals = [color_bar_edge,color_bar_edge+0.02]
y_vals = fltarr(212)
y_frac = indgen(212)*0.0006

cnos = 0L
while(cnos lt 212) do begin
   y_vals(cnos) = 0.36 + y_frac(cnos)
   plots,/norm,x_vals,[y_vals(cnos),y_vals(cnos)],color=color_index(cnos),thick=1.5
   cnos = cnos + 1
endwhile

max_string = strarr(1)
max_string = strcompress(string(format='(g8.3)',max_val))
min_string = strarr(1)
min_string = strcompress(string(format='(g8.3)',min_val))
xyouts,/norm,color_bar_edge+0.03,y_vals(0),min_string,charsize=csize/1.5,align=0
xyouts,/norm,color_bar_edge+0.03,y_vals(202),max_string,charsize=csize/1.5,align=0
xyouts,/norm,color_bar_edge+0.045,0.35,'Intensity',orientation=90,align=-0.5,charsize = csize/1.5

xyouts,/norm,color_bar_edge,0.555,charsize=csize/1.5,string(total_events, format="(i0,' events')" )

;	************ end of color bar plotting *************

; close plotting device
      device,/close
	close,/all
;	stop

end
