	pro sit_pha_sav_file_generator_rev1
;
;	routine to take variables from a sit_lister pha output file and make a save file of
;	2 variables
;
;	Modification history:
;		29-Mar-2010	initial version /gm
;		14-Mar-2012	adjust initial reads to take care of new sit_lister pha output file format /gm
;
;
	input_file = ''
	read, input_file, prompt='Enter name of SIT lister pha file (no quotes): '
	input_file = strtrim( input_file, 2 ) 
		
	spacecraft = strmid(input_file,strpos(input_file,'/',/reverse_search)+5,1)
	


	variable_names = ['mass (amu)', 'Essd (MeV/n)', 'Etof (MeV/n)', 'TOF (ns)', 'SSD energy (MeV)', 'Tch', 'Ech'] 
	print, 'Variable numbers: mass = 0, essd (MeV/n) = 1, etof (MeV/n) = 2, tof ns = 3, SSD energy MeV = 4, tch = 5, ech = 6'
	read, x_sav, prompt= 'Enter variables for save file:  x: '
	read, y_sav, prompt= 'Enter variables for save file:  y: '
	sav_var = [x_sav, y_sav]
	variables = [variable_names(x_sav), variable_names(y_sav)]
	
	file_name_variables = ['_mass','_essd','_etof','_ns','_MeV','_Tch','_Ech']

	input_file = strtrim( input_file ) 
	output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'
	sav_file = strmid(input_file, strpos(input_file,'/', /reverse_search)+1)
	sav_file = strmid(sav_file,0,strlen(sav_file)-4)
	sav_file = sav_file + file_name_variables(x_sav)+ file_name_variables(y_sav)+ '.sav'
	output_file = output_folder + sav_file
	
	instring = ''

	maxrec = 1000000L
	array = fltarr(2,maxrec)

	nlines = 0L
	openr, lun_input, input_file, /get_lun
	for i = 1,12 do readf, lun_input, instring
	plot_title = string(spacecraft, format="('SIT-',a,' PHA data ')") + strmid(instring,0,40)
;	for i = 13,14 do readf, lun_input, instring
	while( strpos(instring,'Time,year,day') eq -1 ) do readf, lun_input, instring

	while ( eof(lun_input) ne 1 ) do begin

;Time,year,day of year,Mass (AMU),Einc ssd (MeV/nuc),Einc tof (MeV/nuc),Tof (ns),Energy (MeV),T ch,E ch,gain,priority,tof flg1,tof flg2,tof error proc,Matrix box,apid,Calc Matrix box, Calc Pri,Calc Bea box, M box err, Pri err,time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X,GSE-Y,GSE-Z,Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg), 
;    2010/02/14 00:00:45,     2010.120549,       45.000568,  1.3549e+01,  8.6671e-02,  8.6696e-02,  
	
	readf, lun_input, instring  	
;	first, remove the first 25 characters containing the calendar date
	instring = strmid(instring, 25, strlen(instring) - 25) 

;  remove nested commas since they are not decoded by IDL
	length = strlen(instring)
next:	instring = replace_text(instring, ',,' , ', 0.,')
	if( strlen(instring) gt length ) then begin
		length = strlen(instring)
		goto, next
	endif
	reads, instring, year, doy, mass, essd, etof, tof, energy, tch, ech, gain, priority, tofflag1, tofflag2, toferror, mboxno, apid
;	readf, lun_input, year, doy, mass, essd, etof, tof, energy, tch, ech, gain, priority, tofflag1, tofflag2, toferror, mboxno, apid, format="(24x,f16.6,x,f16.6,x,14(e12.4,x))"
	
;	i = 0 x-axis
;	i = 1 y-axis
	for i = 0,1 do begin
		case sav_var(i) of
		0:	array(i,nlines) = mass
		1:	array(i,nlines) = essd
		2:	array(i,nlines) = etof		
		3:	array(i,nlines) = tof
		4:	array(i,nlines) = energy
		5:	array(i,nlines) = tch
		6:	array(i,nlines) = ech
		endcase
	endfor

	nlines ++	
;	stop
	endwhile
	
;	trim the array	
	nlines --
	array = array[*,0:nlines]
	

;	now write out the sav file:
	print, 'now saving to file: ',output_file

	save, nlines, input_file, plot_title, variables, array, filename=output_file
	close, /all
	
	end
