	pro	stereo_mag_averager
;
;
;	routine to make 1-hr average stereo mag files from UCLA 1-sec files
;
;	Modification history:
;		15-Aug-2008	initial version  / gm
;
;
	input_directory = '/data/joey/masongm1/Data/Data_other_instr/STEREO_data/magnetometer/'
	spacecraft_names = ['Stereo_A','Stereo_B']
	spacecraft = ['A','B']
	
	openw, lun_output, input_directory + 'Stereo_mag_files.txt', /get_lun
	printf, lun_output, 'Hourly averages from UCLA site 1-sec download monthly files'
	printf, lun_output, 'MJD,Year, DOY, Bx_A, By_A, Bz_A, Btot_A, Bphi_A, Bdelta_A, MJD,Year, DOY, Bx_B, By_B, Bz_B, Btot_B, Bphi_B, Bdelta_B'
	
	read, start_year, stop_year, prompt='enter start, stop year: '
	read, start_month, stop_month, prompt='enter start, stop month: '
	
;	create an array to hold the averages --- will be written out at the end
	base_day = date2mjd(start_year,start_month,1)
	num_hours = date2mjd(stop_year,stop_month+1,1) - base_day
	num_hours = 24.*num_hours
	averages = fltarr(num_hours, 18)  ; each line contains mjd_a, Year, doy, bx, by, bz, btot, bphi, blat, mjd_b, Year, doy, bx, by, bz, btot, bphi, blat
	
	
	
	for i = 0, 1 do begin   ; outer loop for two spacecraft
		num_averages = 0
		first_flag = 0

		bx_avg = 0.
		by_avg = 0.
		bz_avg = 0.
		btot_avg = 0.
		n_points = 0
		day_tot = 0.
		bx_tot  = 0.
		by_tot  = 0.
		bz_tot  = 0.
		b_tot  = 0.
	
	for j = start_year, stop_year do begin

	if(j eq start_year) then begin_month = start_month else begin_month = 1
	if(j eq stop_year) then end_month = stop_month else end_month = 12

	for k = begin_month, end_month do begin

	
	
	infile =  input_directory + string(spacecraft(i),spacecraft(i),j,k,format="('Stereo_',a,'/Mag_',a,'_',i4,'_',i2.2,'.txt')")
	openr, lun_input, infile, /get_lun
	print, ' opening ',infile
	instring = ''
	while( instring ne 'DATA:' ) do readf, lun_input, instring
;	incount = 0.d0
;	while(incount lt 100.d0 ) do begin
;	incount = incount + 1.d0
	
	while( ~ eof(lun_input) ) do begin
	readf, lun_input, instring
	reads, instring, year, month, day, hour, min, sec, msec, bx, by, bz, btot
;	print, instring
	if( (bx+by+bz) gt 1.e10 ) then goto, nextread   ; skip fill data
	mjd_now = date2mjd(year, month, day)
	mjd_fract = hour/24.d0 + min/1440.d0 + sec/86400.d0

	if( first_flag eq 0 ) then begin
		first_flag = 1
		hour_last = hour
	endif
	
	if(hour ne hour_last) then begin   ; make up an average and clear bins

		day_avg = day_tot/n_points
		bx_avg = bx_tot/n_points
		by_avg = by_tot/n_points
		bz_avg = bz_tot/n_points
		btot_avg = b_tot/n_points

		averages(num_averages, 9*i) = day_avg
		averages(num_averages, 9*i+ 1) =  year	
		averages(num_averages, 9*i+ 2) =  day_avg - date2mjd(year,1,1) + 1.
		averages(num_averages, 9*i+ 3) = bx_avg 
		averages(num_averages, 9*i+ 4) = by_avg 
		averages(num_averages, 9*i+ 5) = bz_avg 
		averages(num_averages, 9*i+ 6) = btot_avg 
		averages(num_averages, 9*i+ 7) = atan(by_avg,bx_avg)*360./(2*!pi)
		averages(num_averages, 9*i+ 8) = atan(bz_avg,sqrt(bx_avg^2+by_avg^2))*360./(2*!pi)	
		num_averages ++

		day_tot = mjd_now + mjd_fract
		bx_tot = bx
		by_tot = by
		bz_tot = bz
		b_tot = btot
		n_points = 1.d0	
		hour_last = hour

	
	endif else begin   ; just average these points in
		day_tot += mjd_now + mjd_fract
		bx_tot += bx
		by_tot += by
		bz_tot += bz
		b_tot += btot
		hour_last = hour
		n_points = n_points + 1.d0
	endelse
	
nextread:		
	endwhile   ; end of file reading loop for one month (one file)
	free_lun, lun_input ; close the input file
	endfor ; end of k loop for months (files)
	endfor ; end of j loop for years
	endfor ; end of i loop for spacecraft
	
;	now write out the file
	print, ' now writing out file: '
	for i = 0, (num_averages-1) do printf, lun_output, averages(i,*), format="(x,2(f11.4,',',i5,',',f10.4,',',6(e11.3,',')))"
	
	free_lun, lun_output
	stop
	end
	


