	pro cdf_read_test, input_file
;
;	test routines to read cdf files
;
	id = cdf_open(input_file)
	
	result = cdf_inquire( id )
	
	num_zvars = result.nzvars
	
	names = strarr( num_zvars)
	
	for i = 1, num_zvars -1   do begin
		result = cdf_varinq(id, i, /zvariable)
		names(i-1) = result.name
	endfor
	
;	bfieldrtn is variable #2
	value = 0.

	cdf_varget, id, 0, value_time, rec_count=1000, /ZVARIABLE	
	cdf_varget, id, 2, valueb, rec_count=1000, /ZVARIABLE	

	openw, lun_output, '/data/joey/masongm1/Programs/idl_SIT/production_and_misc/stereo_mag_field/cdf_files/mag_field.txt', /get_lun
	for i = 0, num_zvars-1 do printf, lun_output,'zvariable number: ',i, ' name: ', names(i)
	printf, lun_output, 'line,year,month,day,hour,min,second,Br,Bt,Bn,'
	for i = 0L, 999L do begin
		cdf_epoch, value_time(i), year, month, day, hour, minute, second, milli,/breakdown_epoch
		printf, lun_output, i,  year, month, day, hour, minute, second, valueb(*,i), format="(7(i6,','),3(e15.3,','))"
	endfor

	for i = 0, num_zvars do begin
		cdf_varget, id, i, value, rec_count=10, /ZVARIABLE
	endfor
	
	cdf_close, id
	close,/all		
;	stop
	end
	
	
