	pro reformat_stereo_mag_files, input_file
;
;	routine to take www yearly file downloads and put them into kaleidagraph format
;	data source:	http://aten.igpp.ucla.edu/forms/stereo/level2_plasma_and_magnetic_field.html
;
;	Modification history:
;		21-Jun-2013	initial version /gm
;		28-Jun-2015 get spacecraft name and year of start record from header /gm
;
;
	forward_function find_angles, fov_flags


	openr, lun_input, input_file, /get_lun
	
;	put output file in same directory:  
	instring = ''
;	find the first time (year)
	while( strpos(instring, 'FIRST TIME') eq -1 ) do readf, lun_input, instring
	reads, instring, year, format="(21x,i4)"
;	trap for 2007 file which does not have the spacecraft name!
	if( year = 2007. ) then begin
		spacecraft = ''
		read, spacecraft, prompt='Enter spacecraft name (a or b): '
	goto, spacedown 
	endif
;	find the spacecraft name	
	while( strpos(instring, 'SC TYPE') eq -1 ) do readf, lun_input, instring
	spacecraft = strlowcase(strmid(instring,strlen(instring)-1,1))
spacedown:	
	while( strpos(instring, 'DATA:') eq -1 ) do readf, lun_input, instring


	output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'
	output_file = string(spacecraft, year, format="('st',a,'_',i4,'.txt')")
	openw, lun_output, output_folder + output_file, /get_lun

	printf, lun_output, 'STEREO mag field reformatter run: ', systime(), 'routine is:  reformat_stereo_mag_files.pro'
	printf, lun_output, 'input file: ', input_file
	printf, lun_output, 'Time, Year (dec), DOY, Br RTN nT, Bt RTN nT, Bn RTN nT, B tot nT, HEEQ-X au, HEEQ-Y au, HEEQ-z au, R au, B (theta), B (phi), fov, fov+10 deg, fov + 20 deg, fov + 30 deg,'	
;	space down to the header


	input_data = fltarr(8)			; = br, bt, bn, btot, heeqx, heeqy, heeqz, radius
	while( ~eof(lun_input) ) do begin
		readf, lun_input, year, month, day, hour, min, sec, ms, input_data
;	find the day of year
	doy = date2mjd(year, month, day) - date2mjd(year, 1, 1) + 1
	doy += (hour/24.) + (min/1440.) + (sec/86400.)
	
	if( (year mod 4) eq 0 ) then year_dec = year + doy/366. else year_dec = year + doy/365.  
	
	find_angles, input_data(0), input_data(1), input_data(2), theta, phi
	
	fov_flags, theta, phi, array

	print_line = [input_data, theta, phi, array]
	
		printf, lun_output, year, month, day, hour, min, year_dec, doy, format="($, i5,'/',i2,'/',i2,i3,':',i2,':00,', 2(f15.6,','))" 
		for i = 0, 13 do if( print_line(i) gt 10.e10 ) then printf, lun_output, format="($,',')"  $
				else printf, lun_output, print_line(i), format="($,e12.4,',')"


;	finish line with a blank
		printf, lun_output, ' '
	
	endwhile
	close,/all
	end

	pro find_angles, br, bt, bn, theta, phi
;	finds mag field latitude (theta) and longitude (phi) angle in degrees
 
;	 - calculation of the RTN Cartesian components  of  interplanetary magnetic  - from ftp://ftp.bartol.udel.edu/whm/Voyager/vy2mgd.txt
;	    field from the RTN spherical components:
;                  
;                   BR=|B|*cos(THETA)*cos(PHI)
;                   BT=|B|*cos(THETA)*sin(PHI)
;                   BN=|B|*sin(THETA)
; 	   where THETA - spherical RTN latitude, PHI- spherical RTN longtitude



	part = sqrt( br^2 + bt^2 )
	if( part eq 0 ) then theta = 0. else theta = 57.2958*atan( bn/part )	; returns angles between -pi/2 and + pi/2
	
	if( br ne 0 ) then phi = 57.2958*atan( bt , br ) else phi = 0.   ; returns angles between -pi and + pi
	if( phi lt 0 ) then phi = 360. + phi	; for idl atan function with 2 parameters, this gives proper angles
;
;	if some of the mag field data was missing, flag theta and phi also as missing
	if( br gt 10.e10 ) then begin
		phi = 10.e20
		theta = 10.e20
	endif
	
	end
;	********** test routine ***********
;	for i  = 0, 360 do begin
;	
;		angle = i/57.2958
;		r = cos (angle )
;		t = sin ( angle )
;		
;		tan = 57.2958*atan( t, r )
;		if( tan lt 0 ) then tan = 360. + tan
;		print, i, r, t, tan
;	endfor
;	end
;

	pro 	fov_flags, theta, phi, array
;	sets 4 flags depending on whether mag field is
;	within SIT fov, and SIT fov + 10, 20, or 30 degrees
;	SIT fov is 44 x 17 degrees, with boresight 60 degrees west of S/C-sun line

	array = [10.e20, 10.e20,10.e20,10.e20]

	if( phi lt 1000. ) then begin
			for i = 0,3 do begin	
				ang = i*10.
				if( phi lt 180.) then phi_test = phi else phi_test = phi - 180.
				if( (theta lt (8.5 + ang)) and (theta gt -(8.5+ ang)) and (phi_test lt (144 + ang)) and (phi_test gt (98. - ang)) ) then array(i) = i+1 else array(i) = 0
;	test expression for theta				if( (theta lt (8.5 + ang)) and (theta gt -(8.5+ ang))  ) then array(i) = i+1 else array(i) = 0
;	test expression for phi				if( (phi_test lt (144 + ang)) and (phi_test gt (98. - ang)) ) then array(i) = i+1 else array(i) = 0

			endfor
	endif
	end


                
