	PRO TEST_STEREO_EPHEMERIS, current_mjd
;
;	routine to provide STEREO locations -- both spacecraft positions are found corresponding to the time current_mjd
;
;		3-Apr-2007	/gm
;
common stereo_ephem, au_km, synodic_rotation, gse, angles, rotated_time, position_structure, max_sc_recs, last_index, last_ephem_time
	au_km = 1.4958D8    ; astronomical unit in km
	synodic_rotation = 360./27.2753    ; degrees per day
	gse=fltarr(3,2)     ; units:  km
	angles=fltarr(3)    ; 0 = B to SEarth line; 1 = Sun-Earth line to A;  2 = B to A (degrees)
	rotated_time = { mjd:0UL, time:0UL }	   ; rotated time to Sun-Earth line assuming solar corotation delay   (mjd)
	rotated_time = replicate(rotated_time, 2)
	max_sc_recs = fltarr(2)	; number of entries in position_structure for each spacecraft
	last_index = ulonarr(2)		; index number of the last search
	last_ephem_time = dblarr(2)   ; time of last ephemeris data returned
	current_mjd = 0.d0



;	first, read in the ephemeris data for both spacecraft
	read_position
	print, ' read_position finished'

	spacecraft_id = 0

;	for m = 0, 10 do begin
		read, current_mjd, prompt=' Enter time in mjd: '
		
		for spacecraft_id = 0,1 do begin
		
		last_ephem_time(spacecraft_id) = current_mjd
		if( current_mjd lt last_ephem_time(spacecraft_id) ) then last_index(spacecraft_id) = 0


			for i = last_index(spacecraft_id), (max_sc_recs(spacecraft_id) -2) do begin
				last_index(spacecraft_id) = i
				if( current_mjd ge position_structure[i].mjd(spacecraft_id) ) then $
					if( current_mjd le position_structure[i+1].mjd(spacecraft_id) ) then break
			ENDFOR   ; time loop

;		interpolate the position
		i = last_index(spacecraft_id)
		fraction = double((current_mjd - position_structure[i].mjd(spacecraft_id)))/double((position_structure[i+1].mjd(spacecraft_id)-position_structure[i].mjd(spacecraft_id)))
		gse(*,spacecraft_id) = fraction*double((position_structure[i+1].gse(*,spacecraft_id) - position_structure[i].gse(*,spacecraft_id))) + position_structure[i].gse(*,spacecraft_id)
		angles(spacecraft_id) = - !radeg*atan(gse(1,spacecraft_id), au_km - double(gse(0,spacecraft_id)))
		rotated_time(spacecraft_id).mjd = floor(double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation))

		rotated_time(spacecraft_id).time= (   (  double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation)  ) -rotated_time(spacecraft_id).mjd  )*86400.d0*1000d0
		
		print, ' line 1: ',double(current_mjd), double(angles(spacecraft_id)/synodic_rotation), floor(double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation))
		print, ' line 2: ', double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation)
		help, rotated_time
		print, ' line 3:  ', rotated_time(spacecraft_id)

		ENDFOR  ; spacecraft loop

;		angles between the 2 spacecraft: 
		angles(2) = abs(angles(0)) + abs(angles(1))

		print, current_mjd - double(angles(0)/synodic_rotation), current_mjd, double(angles(0)/synodic_rotation)
		print, current_mjd + double(angles(1)/synodic_rotation),  current_mjd, double(angles(1)/synodic_rotation)

;	if we ran of the end of the table, then return zeroes
	for spacecraft_id = 0,1 do begin
		if( last_index(spacecraft_id) eq (max_sc_recs(spacecraft_id) -2) ) then begin
		last_ephem_time(spacecraft_id) = 0.D0
		last_index(spacecraft_id) = 0
		gse(*,spacecraft_id) = 0.
		angles(*) = 0.
		rotated_time(*) = current_mjd
		return
		endif
	ENDFOR
	
		for spacecraft_id = 0,1 do begin
			print, ' spacecraft id, last index: ', spacecraft_id, last_index(spacecraft_id)
			print, ' gse: ', gse(*,spacecraft_id)
			print, ' angles: ', angles
			print, ' rotated time: ', rotated_time
			print, ' '
		ENDFOR
			

	
;	ENDFOR   ; end statement for prompt loop
	
	end
