	PRO STEREO_EPHEMERIS, current_mjd
;
;	routine to provide STEREO locations -- both spacecraft positions are found corresponding to the time current_mjd
;
;		3-Apr-2007	/gm
;		5-Jan-2009	modify handling of running out off end of table;  in this case quit since
;					it causes problems in some programs that read the txt files /gm
;		15-Jul-2015	rework time stepback section to avoid going back to start of time list, since this can
;					take lots of time /gm
;


common stereo_ephem          ; contains ephemeris data returned & misc counters

;	first, read in the ephemeris data for both spacecraft -- if it isn't read in already
	if(n_elements(max_sc_recs) eq 0) then read_position

		for spacecraft_id = 0,1 do begin
		

;	************ time stepback section (for handling multiple apids, etc) *******************		7/15/2015 /gm
		if( (current_mjd - position_structure(last_index(spacecraft_id)).mjd(spacecraft_id)) gt 0. ) then goto, timeok

		while( (current_mjd - position_structure(last_index(spacecraft_id)).mjd(spacecraft_id)) le 0. ) do begin
;			print, current_mjd, position_structure(last_index(spacecraft_id)).mjd(spacecraft_id), last_index(spacecraft_id)
			last_index(spacecraft_id) --
		endwhile
;	*****************************************************************************************

timeok:  		
			last_ephem_time(spacecraft_id) = current_mjd

			for i = last_index(spacecraft_id), (max_sc_recs(spacecraft_id) -2) do begin
				last_index(spacecraft_id) = i
				if( current_mjd ge position_structure[i].mjd(spacecraft_id) ) then $
					if( current_mjd le position_structure[i+1].mjd(spacecraft_id) ) then break
			ENDFOR   ; time loop

;		interpolate the position
		i = last_index(spacecraft_id)
		fraction = double((current_mjd - position_structure[i].mjd(spacecraft_id)))/double((position_structure[i+1].mjd(spacecraft_id)-position_structure[i].mjd(spacecraft_id)))
		gse(*,spacecraft_id) = fraction*double((position_structure[i+1].gse(*,spacecraft_id) - position_structure[i].gse(*,spacecraft_id))) + position_structure[i].gse(*,spacecraft_id)
		angles(spacecraft_id) = - !radeg*atan(gse(1,spacecraft_id), au_km - double(gse(0,spacecraft_id)))
		rotated_time(spacecraft_id).mjd = floor(double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation))
		rotated_time(spacecraft_id).time= (   (  double(current_mjd) - double(angles(spacecraft_id)/synodic_rotation)  ) $ 
				-rotated_time(spacecraft_id).mjd  )*86400.d0*1000d0

		ENDFOR  ; spacecraft loop

;		angle between spacecraft
		angles(2) = abs(angles(0)) + abs(angles(1))

;	if we ran of the end of the table, then quit
	for spacecraft_id = 0,1 do begin
		if( last_index(spacecraft_id) eq (max_sc_recs(spacecraft_id) -2) ) then begin
			print, 'Ran off end of ephemeris table;  sit_lister quitting early'
			stop
			exit, status=5
		endif
	ENDFOR  ; overrun table loop
;	print,'current_mjd, last_index, position_structure(last_index(*)).mjd(0): ', current_mjd, last_index, position_structure(last_index(*)).mjd(0)
;	stop
	end

;	if we ran of the end of the table, then return zeroes -- old code replaced 1/5/09
;		last_ephem_time(spacecraft_id) = 0.D0
;		last_index(spacecraft_id) = 0
;		gse(*,spacecraft_id) = 0.
;		angles(*) = 0.
;		rotated_time(spacecraft_id).mjd = floor(current_mjd)
;		rotated_time(spacecraft_id).time = (current_mjd-floor(current_mjd))*86400.d0*1000d0
;		return

