	PRO READ_POSITION
;	reads in GSE file -- see IDL book by Gumley, p 153
;
;		3-Apr-2007	/gm
;		6-Jan-2009	get current year for input file reading from systime;  quit if any year missing /gm
;		29-Mar-2010	increase maxrec to 250000 /gm
;		23-Nov-2010	change ephemeris_path source to common paths /gm
;

common stereo_ephem
	common paths
;	ephemeris_path = '/data/joey/masongm1/Data/Data_L1_flight/STEREO/stereo_ephemeris/'
	maxrec = 500000L
	max_sc_recs = fltarr(2)
	record = { time:fltarr(3), flag:0, gse:fltarr(3) }
	data = replicate(record, maxrec)
	position = { mjd:dblarr(2), gse:fltarr(3,2) }   ; dates and positions for 2 spacecraft
	position_structure = replicate(position,maxrec)
	
	for nsc = 0,1 do begin
	nrecords = 0L
	if(nsc eq 0) then name = 'ahead' else name = 'behind'

;	get current year
	reads,systime(),year_ephem_limit,format="(20x,i4)"
	
	for year_file = 2006, year_ephem_limit do begin
		infilename = ephemeris_path  + name + '/position_' + name + string(year_file, format='("_",i4,"_GSE.txt")' )
		openr, lun_position, infilename, /get_lun, ERROR = err
;			section to deal with missing files
				if(err ne 0) then begin
					print, 'file =  ', infilename, ' not found', ' sit_lister quitting early'
					exit, status=5
				endif
		
		while( eof(lun_position) ne 1 ) do begin
			readf, lun_position, record
			data[nrecords] = record
			
;			if(nrecords eq 10) then print, ' record.time: ', record(0).time(*), record.flag, record.gse
;			if(nrecords eq 10) then print, ' data: ', data(0).time(*), data(0).time(0), data(0).time(1), data(0).time(2),data(0).flag, data(0).gse
			
			nrecords = nrecords + 1L
			if( nrecords eq maxrec) then print, ' maximum record reached!'
			
		endwhile
		free_lun, lun_position
		
	endfor   ; loop for reading year files

;	now transfer data into the position structure, and convert the time
		max_sc_recs(nsc) = nrecords - 1L
	for i=0L,nrecords-1L do begin
		current_mjd = date2mjd(data[i].time(0), data[i].time(1)) + double(data[i].time(2))/double(86400.)
		position_structure[i].mjd(nsc) = current_mjd
		position_structure[i].gse(*,nsc) = data[i].gse(*)
	endfor

	
	endfor   ; loop for reading spacecraft files
;	trim data structure
	data=0L
;	print, max_sc_recs, maxrec, format="('number of ephemeris records:  ',i7,' (STEREO-A), ',i7,' (STEREO-B), max allocation = ',i8, ' each') 
;	print, ' number of records: ', max_sc_recs
;	trim down the position_structure
	position_structure = position_structure( 0 : max(max_sc_recs) - 1)
;	help, position_structure
	
;	print, position_structure(2990:3000)
	
;	print, ' ephemeris data read in'
	end
		
		
		
		
