	pro sit_rom_vs_pha_intensity_checker
;
;	routine to read sit_lister 1hr intensity files (pha rates and rom rates) and compute correlations
;
;	modification history:
;		21-Jun-2011	initial version /gm
;
	rom_intensity_avg = fltarr(116)
	pha_intensity_avg = fltarr(116)
	pha_rate_array = fltarr(2000, 116)
	rom_rate_array = fltarr(2000, 116)
	ratio_avg = fltarr(116)

	
	effic = fltarr(2,116)

;
;	open the rom rate input file
	rom_rate_file = ''
	read, rom_rate_file, prompt='Enter the rom rate file name (do not use quotes): '
;	rom_rate_file = '/data/joey/masongm1/Data/work_files_STEREO/sit_box_intensity_checks/SIT_B_2011_111_rates.txt'
	rom_rate_file = strtrim(rom_rate_file)
	openr, lun_rom_rate_input, rom_rate_file, /get_lu
;
;	determine if spacecraft is 'a' or 'b'
	if( strlowcase( strmid(rom_rate_file,strpos(strlowcase(rom_rate_file),'sit_',/reverse_search)+4,1) ) eq 'a' ) then spacecraft_id = 0 else spacecraft_id = 1
	if( spacecraft_id eq 0 ) then spacecraft_name = 'a' else spacecraft_name = 'b'

;
;	open the pha rate input file
	pha_rate_file = ''
	read, pha_rate_file, prompt='Enter the pha rate file name (do not use quotes): '
;	pha_rate_file = '/data/joey/masongm1/Data/work_files_STEREO/sit_box_intensity_checks/SIT_B_2011_111_pha_rates.txt'
	pha_rate_file = strtrim(pha_rate_file)
	openr, lun_pha_rate_input, pha_rate_file, /get_lu
;
;	read in the minimum intensity for rom rates to do a fit
;	read, rom_minimum_intensity,prompt='Enter the minimum rom intensity for doing a fit: '

;	read in the current matrix box definitions
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/SIT_rate_boxes/sit_rate_box_ranges_041811_sav.dat'
;	restores structure matrix_rates;  tag names:  EMIN_NOMINAL EMAX_NOMINAL MASS_MIN MASS_MAX MASS_AVG Z	

;	read in the current efficiency file
	efficiency_file_name = '/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/SIT_efficiencies/sit_efficiencies_2011_04_27.dat'
	openr, lun_eff, efficiency_file_name, /get_lun	
	readf, lun_eff, format='(/)'    ;  skip header line
	for i = 0, 115 do begin
		readf, lun_eff, effic1, effic2
		effic(0,i) = effic1
		effic(1,i) = effic2
	endfor

;	************************* get output folder name from the input folder ***************
	
	output_folder = strmid(rom_rate_file, 0, strpos(rom_rate_file,'/', /reverse_search)) + '/
	output_filename = string( spacecraft_name, format="('sit_',a,'_rom_vs_pha_correlation.txt')" )
	openw, lun_output, output_folder + output_filename ,/get_lun	
	
;	write the output file header
	printf, lun_output, systime(), format="('SIT rom vs pha rate correlation calculation ', a,/)"
	printf, lun_output, 'input rom file name: ', rom_rate_file
	printf, lun_output, 'input pha rates file name: ', pha_rate_file
;	printf, lun_output, 'minimum rom box intensity to do fits: ', rom_minimum_intensity
;	copy the header lines from the input file and determine if file is for fluence or intensity
	input_string = ''
	while( strpos(input_string,' Time,year,day') eq -1 ) do begin
		readf, lun_rom_rate_input, input_string
		printf, lun_output, input_string
	endwhile

;	just space the pha_rates file down to the data also
	input_string = ''
	while( strpos(input_string,' Time,year,day') eq -1 ) do readf, lun_pha_rate_input, input_string


;	now read down each file and put the rates into arrays -- fill in rates that have not been printed out due to eff < 0.
;	figure out how many rate columnns there will be based on how man efficiencies are > 0
	i_cols = 0
	for i = 0, 115 do if( effic(spacecraft_id,i) gt 0. ) then i_cols ++
	input_array = fltarr(i_cols)
	rate_array = fltarr(116)



	header_items = fltarr(11)	
;	*********** main loop for reading file ************	
	for i_file = 0, 1 do begin    ; rom vs pha loops
	
	if( i_file eq 0 ) then lun_input = lun_rom_rate_input else lun_input = lun_pha_rate_input
	line_count = -1
	
	while (~eof(lun_input)) do begin

	readf, lun_input, input_string, format="(a)"
	if( strlen(input_string) lt 40. ) then goto, next_event
	line_count ++

;	strip off the string through end of date/time
	input_string = strmid( input_string, 26, strlen(input_string))

;	undo the kaleidagraph nested commas and fill out end of line with zeroes
	kal_line_undo, input_string, input_string_new

;	read in all the variables from the string
	reads, input_string_new, header_items, input_array

;	now transfer the input_array into the full length array
	col_now = 0
	for i = 0, 115 do begin
		if( effic(spacecraft_id,i) gt 0. ) then begin
			rate_array(i) = input_array(col_now) 
			col_now ++
		endif else begin
			rate_array(i) = 0.
		endelse
	endfor
	
	if( i_file eq 0 ) then for j = 0, 115 do rom_rate_array(line_count,j) = rate_array(j) else $
		for j = 0, 115 do pha_rate_array(line_count,j) = rate_array(j)
;	print, line_count, input_array	
;	if( 	line_count eq 200 ) then stop
next_event:	
	endwhile    ; end of file reading loop

	endfor  ; end if i_file loop


;	now do the linear fits to the correlations
	fits = fltarr(2,116)
	chisave = fltarr(116)
	num_points = fltarr(116)
	maximum = fltarr(116)
	
	for i = 0, 115 do begin
;	find the maximum intensity for this line
		maximum(i) = max(rom_rate_array(*,i))
;	now fit on points from maximum down a factor of 100.		
		x_locs = where( rom_rate_array(*,i) gt maximum(i)/100. ) 
		if( n_elements(x_locs) eq -1 ) then  num_points(i) = 0. else num_points(i) =  n_elements(x_locs)
		if( num_points(i) gt 10. ) then begin
			rom_rate_vector = rom_rate_array(x_locs,i)
			pha_rate_vector = pha_rate_array(x_locs,i)
			result = linfit(rom_rate_vector, pha_rate_vector, chisq=chisq)
			chisave(i) = chisq
			fits(0,i) = result(0)
			fits(1,i) = result(1)
		endif else begin
			fits(0,i) = 1.
			fits(1,i) = 1.
		endelse
;	if the slope is negative, set = 1.0 to keep all output rates positive
		if( fits(1,i) lt 0. ) then fits(1,i) = 1.0
	endfor





;	print the output file header and write out the fits	
	printf, lun_output, 'Box, Rate, Eavg, A coefficient, B coefficient (slope), chisq, number of points, maximum intensity'
	
	for i = 0, 115 do printf, lun_output, i, matrix_rates[i].mat_names(0), $
		(matrix_rates[i].emin_nominal(spacecraft_id) + matrix_rates[i].emax_nominal(spacecraft_id))/2.,  $
	     fits(*,i), chisave(i), num_points(i), maximum(i),format="(i4,',', 2x, a,',', 3x, 3(f10.4,','), e12.3,',',i5,',', e12.3,',')"


	close, /all
;	stop
	end
