PRO sit_apid_counter
;+
;	adapted from sit_lister

;	Modifiction history:
;		28-Apr-2011	original version /gm
;


; ****************************************************************

	spacecraft_name=strarr(2)
	spacecraft_name(0) = "ahead"
	spacecraft_name(1) = "behind"
	apid_name = ['576', '577', '605', '606', '607', '608', '609', '610', '611', '612', '613', '614', '615', '616', '623', '624']
	apid_type = fltarr(16)
	default_directory = '/data/joey/masongm1/Programs/idl_sit/production_and_misc/sit_apid_counter/'


	 flight_data_path = '/data/joey/masongm1/Data/Data_L1_flight/STEREO/'

	read, nsc, start_mjd, stop_mjd, prompt="Enter s/c (0 or 1) and start and stop mjd: "
	if( nsc eq 0 ) then openw, lun_output,default_directory + 'sit_ahead_apid_counter.txt', /get_lun else openw, lun_output,default_directory + 'sit_behind_apid_counter.txt', /get_lun
	printf, lun_output, apid_name, format="('MJD, year, month, day, doy,',17(a,','))"

	
	mjd_open = start_mjd
	
	WHILE (mjd_open le stop_mjd) DO BEGIN      ;  file opening loop

; *************** file opening section **********************

	MJD2DATE, mjd_open, YEAR, MONTH, DAY
	doy = mjd_open-date2mjd(year,1,1)+1
;	print, ' opening:  ', year, month, day
	
	infilename=''

	FOR j = 0,1 DO BEGIN
	
	if(j eq 0) then extension = '.fin'    ; first search for a file with extension fin (final version)
	if(j eq 1) then extension = '.ptp'   ; if ftn not found, look for a preliminary version unless fin_flag has been set  3/17/2010
	
	FOR i=10,0,-1 DO BEGIN                   ; check up to 10 version numbers before quitting:  work from highest version number down
	
	infilename = 'sit_'+spacecraft_name(nsc)+'/sit_'+ spacecraft_name(nsc)+'_'+ $
	                                          string(year,doy,i, format='(i4,"_",i3.3,"_1_",i2.2)' ) + extension                       
	                                          

			
	openr, lun_input, flight_data_path + infilename, /get_lun, ERROR = err
	print, 'opening: ', infilename
;	printf, lun_print, ' error: ', err
		if(err eq 0) then break   ; leave "i" loop if file successfully opened

	ENDFOR  ; loop i
		if(err eq 0) then break   ; leave "j" loop if file successfully opened
	ENDFOR  ; loop j
	
;		section to deal with missing files
		if(err ne 0) then begin
			print,  'file =  ', infilename, ' not found'
			flag_open_sit_file = 0
			goto, skipfile
		endif	
	
; *************** end file opening section **********************
	
	
	apid_type(*) = 0.


	  WHILE 1 DO BEGIN             ; reading loop
	  

newrec: 	read_stereo_pkt, lun_input, packet
	if n_elements(packet) eq 0 then break



	apid = parse_stereo_pkt(packet, /APID )

	branch = apid

	case branch of
	
	576:  apid_type(0) ++
	577:  apid_type(1) ++
	605:  apid_type(2) ++
	606:  apid_type(3) ++
	607:  apid_type(4) ++
	608:  apid_type(5) ++
	609:  apid_type(6) ++
	610:  apid_type(7) ++
	611:  apid_type(8) ++
	612:  apid_type(9) ++
	613:  apid_type(10) ++
	614:  apid_type(11) ++
	615:  apid_type(12) ++
	616:  apid_type(13) ++
	623:  apid_type(14) ++
	624:  apid_type(15) ++
	
	else:	print, ' illegal APID: ', apid  
	
	endcase



	ENDWHILE   ; loop for reading packets from one day (file) ***********
	
;	write tally for this day
	printf, lun_output, mjd_open, year, month, day, doy, apid_type, format="( 21(i6,','))"
	print, ' finished ', year, month, day, ' number of apid 605: ', apid_type(2)

;	now go on to next day

	free_lun, lun_input
skipfile:
	mjd_open ++

	
	ENDWHILE   ; loop for input lines ************************************

;	finish up	
	close, /all
	stop


end 
