	pro idl_files_update_uleis, data_folder
;
;	routine to run uleis idl_files update
;		if latest data includes a year crossing, then update udf_lister.cfg file as well
;		and do any necessary folder cleanup
;
;	Modification history:
;		15-Feb-2012	adapted from basicrates_update_uleis /gm
;
;
	old_file_name = strarr(1000)

;	*********** note, must separately set the default directory before entering this pgm *********
;			trying to change it inside the program does not work
;
;	now run udf_lister
	command = '/data/joey/masongm1/Programs/fortran_vax/udf_lister/udf_lister'
	spawn, command

	cd, '/data/joey/masongm1/Data/Production/ACE/4_idl_files_update/IDL_sav_file_update/'

	spawn, 'idl -quiet /data/joey/masongm1/Data/Production/ACE/0_batch_jobs/main_romsave_uleis_update.batch'
	
	
;	find the range of ACE data in order to find year of latest data
	spacecraft = 0 ;  (ACE)
	data_range, spacecraft, mjd_start, mjd_stop
	mjd2date,mjd_stop, year_latest_data, month_latest_data, day_latest_data

;	if we've crossed a year boundary, update the udf_lister.cgf file for the next run
;	and take care of other housekeeping
	udf_lister_cfg_update, data_folder, mjd_stop, update_flag

	if( update_flag ) then begin
		print, '********************* udf_lister.cfg updated to new year ***********************'	
;		send a mail message notifying of a year change:
		command = 'echo "idl_files folder updated" | mail -s "udf_lister.cfg updated to new year" joey@swri.org
		spawn, command
	endif

;	stop
	end
