PRO SIT_packet_counter
;+
; 	routine to count packets (looking for

; ****************************************************************
flag_open_sit_file=0L
files_missed = 0L

	packet_type = [576, 577, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 624]
	packet_sum=fltarr(16)


	read, iyear, prompt = "enter year number to process: " 
	read, spacecraft_id, prompt = "enter spacecraft id (0/1): " 	
	read, istart, prompt = "enter start day of year to process: " 	
	read, iend, prompt = "enter end day of year to process: " 	
	
	start_mjd =  DATE2MJD(iyear, istart)
	stop_mjd = date2mjd(iyear,iend)
	
	print, ' start/stop dates: ', start_mjd, stop_mjd
	
	
	mjd_open = start_mjd
	
	WHILE (mjd_open le stop_mjd) DO BEGIN      ;  file opening loop
	
	open_sit_file, flag_open_sit_file, spacecraft_id, mjd_open


	count_reads=0L	
	packet = 0

	  WHILE 1 DO BEGIN             ; reading loop
;	if flag_open_sit_file = 0, then input file wasn't found;  so skip this day ... count missed files, if 10 in a row, then stop  /gm 5/29/07
	if flag_open_sit_file eq 1 then files_missed = 0 else begin
		files_missed ++
		if (files_missed lt 10) then break else begin         ; if less than 10 files missing, go open next day
		printf, lun_print, '10 input files in a row missing. sit_lister quitting early'
		goto, finish
		endelse
		endelse

newrec: 	read_stereo_pkt, lun_input, packet
	if n_elements(packet) eq 0 then break

;
;	compute current time
;
;	current_time = tai2utc(double(packet.pkt.seconds), /NOCORRECT)
;	current_mjd = double(current_time.mjd) + double(current_time.time)/double(86400.*1000)


;	process this packet
;	calculate swoosh_energies for this packet time (they are put into the common time_bounds)
	swoosh_energies, current_mjd

	apid = parse_stereo_pkt(packet, /APID )
	
		packet_type = [576, 577, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 624]
	packet_sum=fltarr(16)
	
	for i = 0,15  do if( apid eq packet_type(i) ) then packet_sum(i) ++ else print, " unknown packet id: ", apid
	
	goto, newrec

;	if(count_reads gt 100) then break


	ENDWHILE   ; loop for reading packets from one day (file) ***********

;	now go on to next day
	mjd_open ++

	ENDWHILE   ; loop for file finishing an interval / file opening  *********************************


	
finish:	close, /all     ; close all the files			
			print, " sit_packet_counter is finished"

end 
