PRO SIT_BOX_CHECKER
;
; Project     :	STEREO - IMPACT, SIT
;
; Name        : SIT_LISTER
;
; Purpose     :	Test program to step throuogh SIT PHA matrices and show boxes

;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech
;			Modified from program sit_rates.pro by Andrew Davis / gm
;-
;

sit_common ; setup SIT beacon global variables
sep_beacon_common ; setup SEP beacon global variables

common sitcom
common calibration
common spacecraft
common lun_numbers
common hex_tables

common paths


flag_pha=0L

flag_pha_plots=0L

	read, iunit, prompt='Enter S/C (0/1): '


;	open the output file
		openw, lun_phalist, '/users/masongm1/Programs/sit/sit_programs/sit_box_checker/SIT_BOX_CHECKER.txt', /get_lun
		print, ' opening output file on lun ', lun_phalist
	printf, lun_phalist, iunit, format='(" STEREO unit ",i1,/)
	printf, lun_phalist, format='($,"SSD MeV,")'		
	for i=0,116 do printf, lun_phalist, i, format='($,"Box ",i3,",")'
;		write out a character to force a line feed
		printf, lun_phalist,' ',format='(a1)'



	iprint = 0    ;  0 = don't print;  1 = print	
	
	for igain=0,1 DO BEGIN
	
	issdch = 0
	if igain then issdch = 220    ; for high gain start at channel 220
	
	while issdch le 2047 DO BEGIN
	
	itofch = 0
	
;	itofch = 30
	
	while itofch le 511 DO  begin

	
		channel_to_fme_int, iunit, issdch, igain, itofch,  ixbin, iybin
	if iprint then print, iunit, issdch, igain, itofch,  ixbin, iybin
		
		ibox_contents = 0U
		if((ixbin gt 0) and (iybin gt 0) ) then ibox_contents = ibox_array(ixbin-1, iybin-1, iunit) ; adjust for IDL array
																	; start a ch 0
;	endwhile
	
	if iprint then print, ibox_contents
		calc_matrix_box = ibox_contents mod 128
	if iprint then print, calc_matrix_box
		calc_pri = ishft( ibox_contents, -7 ) mod 2
		calc_bea_box = ishft( ibox_contents, -8 ) mod 16
		m_box_err = 0
		p_box_err = 0

	 	if (calc_matrix_box lt 0) or (calc_matrix_box gt 128) then break     ; leave loop if box outside allowed range
;	 	print, ' printing string for box ', calc_matrix_box
	 	print_to_file = 0
	 	


	 	print_string= string(energy_array(issdch,igain,iunit), format='(f7.3,",")')
		for i=0, 116 do begin
			if( calc_matrix_box eq i ) then begin
			print_string = print_string + string(tof_array(itofch,iunit), format='(f7.3,",")' )
	 	
;	 	print_string= string(issdch, format='(i6,",")')
;		for i=iboxlo, 116 do begin
;			if( calc_matrix_box eq i ) then begin
;			print_string = print_string + string(itofch, format='(i3,",")' )
			print_to_file = 1
		ENDIF else begin	
			print_string = print_string + ','
		ENDELSE
	ENDFOR
	
	if calc_matrix_box eq 63 then print, issdch, igain, itofch, ixbin,iybin, calc_matrix_box, energy_array(issdch,igain,iunit), tof_array(itofch,iunit)
	
	if print_to_file then printf, lun_phalist, print_string	
	
	itofch=itofch+1
	if itofch gt 100 then itofch = itofch + 5
	ENDwhile   ; tloop
	
	issdch=issdch+1
	if issdch gt 100 then issdch = issdch + 5
	if issdch gt 500 then issdch = issdch + 10
	if issdch gt 1000 then issdch = issdch + 25
	ENDwhile  ; eloop
	
	ENDFOR   ; gain loop
	 
			close, /all     ; close all the files
			print, " sit_box_checker is finished"


end 
