PRO channel_to_fme_int, iunit, issdch, igain, itofch,  ixbin, iybin
;
;	19-Oct-2006 /gm
;
;	procedure to calculate SIT matrix bins using integer data
;
	common hex_tables
	ixbin = 0U
	iybin = 0U
	
;	skip events with channels out of bounds
	if(issdch le issdhi_array(1,iunit)) then return
	if(issdch gt issdhi_array(2,iunit)) then return
	if(issdch le issdlo_array(1,iunit)) then return
	if(issdch gt issdlo_array(2,iunit)) then return
	if(itofch le itof_array(1,iunit)) then return
	if(itofch ge itof_array(2,iunit)) then return
	
	if( igain eq 1 ) then begin
		issd = issdlo_array(issdch-1,iunit)     ; adjust ssd ch by -1 for IDL vs fortran indexing provided to Kristin
		ioffset=issdlo_array(0,iunit)
		issdlim1=issdlo_array(1,iunit)
		issdlim2 =issdlo_array(2,iunit)
	endif
	
	if( igain eq 0 ) then begin
		issd = issdhi_array(issdch-1,iunit)	; adjust ssd ch "
		ioffset=issdhi_array(0,iunit)
		issdlim1=issdhi_array(1,iunit)
		issdlim2 =issdhi_array(2,iunit)
	endif


	ilnmass = issd + ulong(itof_array(itofch-1,iunit))	; adjust tof ch "
	
	iybin = ulong(ilnmass)

	iybin = ulong(iybin) + ulong(65536)

	iybin = ulong(iybin) - ulong(ioffset)

	iybin = ulong(iybin) - ulong(itof_array(0,iunit))

	itemp = ulong(iybin)
	
	iybin = ulong(itemp/8) + ulong(itemp/64)

	iybin = ulong(iybin/512)

	
	
	ilneinc = -ulong(itof_array(itofch-1,iunit)) + ulong(itof_array(0,iunit))    ;adjust tof ch #
;	print, ' ilneinc: ', ilneinc
	ixbin = ulong(ilneinc) + ulong(5.5*65536)
;	print, ' ixbin: ', ixbin
	ixbin = ulong(ixbin)/4096
;	print, ' ixbin2: ', ixbin
;	check for out of bounds

	if(( ixbin le 0) or (ixbin gt 128) ) then ixbin = 0
	if(( iybin le 0 ) or (iybin gt 128 ) ) then iybin = 0
	
	return
	end
	
	