	pro sit_box_area_checker
;
;	routine to calculate number of t,e channels in each box for 
;	pha lookup vs. using on board matrix table lookup
;
;	initial version:  20-Jun-2010   /gm
;
;
	matrix_box_tally = fltarr(117,2,2)  ; box #, sc, lookup vs pha data

	@sit_common.inc
	
	read_paths
	
;	zero items used by read_calibration
	pha_rates_out =1
	pha_out =0 
	pha_spectra_out =0 
	histogram_out =0
	multi_panel_out = 0
	control_file_path='/data/joey/masongm1/Data/work_files_STEREO/sit_lister_control/'
	read_calibration
	
;	now go through loop for both spacecraft
	for iunit = 0, 1 do begin
	print, ' starting unit', iunit
	for igain = 0, 1 do begin
	print, ' starting gain state ', igain
;	iunit = 0
;	igain = 0
	for issdch = 0, 2047 do begin
;	for issdch = 0, 1 do begin
	for itofch = 0, 511 do begin

;	calculate the pseudo log bins	
	channel_to_fme_int, iunit, issdch, igain, itofch,  ixbin, iybin
;	look up the box number associated with this bin pair
		ibox_contents = 0U
		if((ixbin gt 0) and (iybin gt 0) ) then ibox_contents = ibox_array(ixbin-1, iybin-1, iunit)
	calc_matrix_box = ibox_contents mod 128
	matrix_box_tally(calc_matrix_box, iunit, 0) ++
	
;	now look up the box number based on detailed pha calibration
	einc = einc_tof_array(issdch,igain,itofch,iunit)
	amass = amass_array(issdch,igain,itofch,iunit)
	   		box = -1
	   		for j=7,115 do begin
	   		box=j
;	   		if( (einc ge matrix_rates(j).emin_nominal(iunit)) and (einc lt matrix_rates(j).emax_nominal(iunit)) and $
;	   			(amass ge matrix_rates(j).mass_min(iunit)) and (amass lt matrix_rates(j).mass_max(iunit)) ) then break	
	   		if(einc ge matrix_rates(j).emin_nominal(iunit)) then $
	   			if (einc lt matrix_rates(j).emax_nominal(iunit)) then  $
		   			if(amass ge matrix_rates(j).mass_min(iunit)) then $
		   				if (amass lt matrix_rates(j).mass_max(iunit)) then break
			box = 6
	   		ENDFOR
	matrix_box_tally(box + 1, iunit, 1) ++   
;	if( box eq 35 ) then stop
	endfor    ; itofch loop
	endfor    ; issdch loop
	endfor    ; igain loop
	endfor    ; iunit loop
	;
	
	
	for j = 1, 116 do begin
		if(  matrix_box_tally(j,0,1) gt 0 ) then ratio1 = matrix_box_tally(j,0,0)/matrix_box_tally(j,0,1) else ratio1 = 0.
		if(  matrix_box_tally(j,1,1) gt 0 ) then ratio2 = matrix_box_tally(j,1,0)/matrix_box_tally(j,1,1) else ratio2 = 0.	
		print, j, matrix_rates[j-1].mat_names(0), matrix_box_tally(j,0,0), matrix_box_tally(j,0,1), $ 
		ratio1, matrix_box_tally(j,1,0), matrix_box_tally(j,1,1), ratio2, format="(i6, 3x, a, 2i8, f8.3, 5x, 2i8, f8.3)"
	endfor
	
	close, /all
	stop
	
	end
