	pro	let_sectored_he_rates
;
;	routine to take a file of stereo-let sectored helium data and make a couple of 
;	sums for easy use
;	input:  level1 files from LET web site at Caltech
;	output:  a new ascii file with 
;			1) forward and backward sectors all summed
;			2) forward sectors 3+4 (numbered 0-7) to correspond to Parker
;				spiral +/- 12.5 degrees, similar to SIT
;			3) ratio of maximum to minimum sector (both forward & backward tested)/ gm
;
	input_file = ''
startup:
	read, input_file, prompt='Enter txt file name (no quotes): '
	input_file=strtrim(input_file,2)   ; remove any leading or trailing blanks
	if( strpos(strlowcase(input_file),'.txt') eq -1) then begin
		print, '******************* input file not a txt file **********************'
		goto, startup
	endif

;	extract the folder name fron the input file:
	output_folder = strmid( input_file, 0, strpos(input_file,'/',/reverse_search)+1 )

;	now open the output file:
;	extract the year and spacecraft from the input_file
	year = strmid(input_file,strpos(input_file,'_1hr_')-4,4)	
	spacecraft = strmid(input_file,strpos(input_file,'_1hr_')-11,6)
	if( spacecraft eq '_ahead' ) then sc_name = 'a' else sc_name = 'b'
	openw, lun_output, output_folder + 'stereo_let_' + sc_name + '_he_sect_' + year + '.txt', /get_lun
	printf, lun_output, 'year, DOY, forward_sum, backward_sum, sectors 3+4, forward+backward sum, sectors 3+4/f +b sum,max/min sector,'
	
	openr, lun_input, input_file, /get_lun
	
	input_line = ''
	while( strpos(input_line, 'BEGIN DATA') eq -1 ) do readf, lun_input, input_line

	while( ~eof(lun_input) ) do begin
	times = fltarr(6)
	fluxes = fltarr(16)
	counts = fltarr(16)
	sigmas = fltarr(16)
	readf, lun_input, times, fluxes, counts, sigmas
	
	sectors_forward = 8.
	sectors_backward = 8.
	sectors_3and4 = 2.
	sectors_total = 16.
	
;	take care of fill data!
	filled = where(fluxes eq -9999.9 )
	if( filled(0) eq -1 ) then goto, nofill
;	total up the number of sectors with good data
		sectors_forward = 0.
		sectors_backward = 0.
		sectors_3and4 = 0.
		sectors_total = 0.
		
		for i = 0, 7 do if( fluxes(i) ne -9999.9 ) then sectors_forward ++
		for i = 8, 15 do if( fluxes(i) ne -9999.9 ) then sectors_backward ++	
		for i = 3, 4 do if( fluxes(i) ne -9999.9 ) then sectors_3and4 ++	
		for i = 0, 15 do if( fluxes(i) ne -9999.9 ) then sectors_total ++
	
;	zero out the fill values
	fluxes(filled) = 0.
	
nofill:  	
	
	if( total(fluxes(0:15)) gt 0. ) then ratio = (total(fluxes(3:4))/sectors_3and4)/(total(fluxes(0:15))/sectors_total) else ratio = 0.
	
;	now find ratio of max and min sectors	
	max_sector = max( fluxes )
	min_sector = min(fluxes(where(fluxes gt 0)))
	if( min_sector gt 0. ) then max_min_ratio = max_sector/min_sector else max_min_ratio = 0.
		
	printf, lun_output, times(0:1), total(fluxes(0:7))/sectors_forward, total(fluxes(8:15))/sectors_backward, total(fluxes(3:4))/sectors_3and4, $
	    total(fluxes(0:15))/sectors_total, ratio,  max_min_ratio, format = "(i5, ',', f10.6, ',', 6(e12.4,','))"
	
	
;	stop	
	
	endwhile
	
	close,/all
	
;	stop
	end