@/data/joey/mdesai/Desktop/IDL/ace/top_level/programs/convert_udf_times.pro

pro sit_webplots_mass_custom,timall,location,dme, stereo_spacecraft, start_year, start_doy, stop_year, stop_doy

; +
; SIT_WEBPLOTS_MASS
; Program to plot ACE/ULEIS pulse height data as 1/v spectrograms vs. time
; Usage final_smoosh,tiamll,location,dme
;  
;
; 
; Keywords:
; timall int input 8-element integer array start and stop times 
;                         e.g., timall = (97,121,0,0,97,126,0,0)
;                              - plots the data from 1997 day 121 - 1997 day 126
; location float input 4-element floating point array 
;                      - position of panels on plotting device
;                      - location = fltarr(3,4) create a 3-panel plot
; dme int 1-element integer array containg device name
;         0 = screen, x-window
;         1 = postcript plot
;                     
; History 
; Original M.I.Desai 12/1/1999 - new_swoosh.pro
; Modified M. I. Desai 10/28/2003 - final_mass.pro
; Modified M. I. Desai 2/13/2004 - webplots_mass.pro
; Modified M. I. Desai 4/25/2007 - sit_webplots_mass.pro to include STEREO data
; Modified 11/5/08 to change source location -- otherwise identical to sit_webplots_mass /gm


; define working constants

constant_vel  = (1.6022e-19*1e6*2)/1.6726e-27
constant_dist =  1.49597870691e11
constant_time  = 3600.

; Convert Energy/nuc. into 1./velocity (hour/AU)
; given energy of particle in MeV/nucleon
; velocity  = 1./((sqrt(constant_vel*energy_nuc)*constant_time)/constant_dist)  

major_velocity_values = fltarr(4)
major_energy_values = [0.022533666,0.1,1.0,10.0]
major_velocity_values = 1./((sqrt(constant_vel*major_energy_values)*constant_time)/constant_dist) 

minor_velocity_values = fltarr(22)
minor_energy_values = [0.03,0.04,0.05,0.06,0.08,0.09,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,2,3,4,5,6,7,8,9]
minor_velocity_values = 1./((sqrt(constant_vel*minor_energy_values)*constant_time)/constant_dist)  
min_string = strarr(22) 
min_string = string(minor_energy_values)

;days_94 = 365.
;days_95 = 365.
;days_96 = 366.
;days_97 = 365.
;days_98 = 365.
;days_99 = 365.
;days_00 = 366.
;days_01 = 365.
;days_02 = 365.
;days_03 = 365.

dbegt = 276.

dtor = !dtor

iy = timall(0)
id = timall(1)
ih = timall(2)
im = timall(3)
ey = timall(4)
ed = timall(5)
eh = timall(6)
em = timall(7)

circ=findgen(16)*(!pi*2/16.)
usersym,cos(circ),sin(circ),/fill

   !p.charsize=1.1
   !x.ticklen  = 0.08
   !y.ticklen  = 0.02   
   !x.thick=2
   !y.thick=2
   ssize = 0.9
   lthick = 1.2
   csize=2.5
   loadct,27
   common colors, r_orig,g_orig,b_orig,r_curr,g_curr,b_curr
   r_curr(1) = 0
   g_curr(1) = 0
   b_curr(1) = 0
   r_curr(2) = 255b
   g_curr(2) = 0
   b_curr(2) = 0
   r_curr(3) = 0
   g_curr(3) = 255b
   b_curr(3) = 0
   r_curr(4) = 0
   g_curr(4) = 0
   b_curr(4) = 255b
   r_curr(219) = 0
   g_curr(219) = 0
   b_curr(219) = 0
   tvlct,r_curr,g_curr,b_curr     
   
;file_name  = "/data/joey/mihirdes/Desktop/IDL/ace/interplanetary_shocks/newphapros/4day_times.dat"  <--commented out temp 5/16/07
;day_times  = read_ascii(file_name,data_start=0,count=number_data_points)

begt = hours(timall(0:1),[95,1]) + timall(2) + timall(3)/60.
endt = hours(timall(4:5),[95,1]) + timall(6) + timall(7)/60.


tim_all = timall

if (tim_all(0) gt 95) then begin
   tim_all(0) = 1900 + tim_all(0)
endif

if (tim_all(0) lt 95) then begin
   tim_all(0) = 2000 + tim_all(0)
endif

if (tim_all(4) gt 95) then begin
   tim_all(4) = 1900 + tim_all(4)
endif

if (tim_all(4) lt 95) then begin
   tim_all(4) = 2000 + tim_all(4)
endif

shtim = string(tim_all(0),tim_all(1),tim_all(2),tim_all(3),tim_all(4),tim_all(5),tim_all(6),tim_all(7), $
   format="(i4.2,':',i3.2,':',i2.2,':',i2.2,'-',i4.2,':',i3.2,':',i2.2,':',i2.2)")
shtim = strcompress(shtim,/remove)

file_subscript = string(tim_all(0),tim_all(1), $
   format="(i4.2,'_',i3.3)")
file_subscript = strcompress(file_subscript,/remove)

file_prefix = "/users/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_sav_files/"  ;  <--needs editing if source file location changed

mass_file = file_prefix + "SIT_" + stereo_spacecraft + "_" + file_subscript + "_multi_panel_pha.sav" 
restore,mass_file

phadata   = transpose(xdf.data)
data_size = size(phadata)

print,phadata(0,0),phadata(0,1),phadata(data_size(1)-1,1)

        year           = phadata(*,0)        
        day            = phadata(*,1)
        tof2_mass      = phadata(*,3)
        phadata(*,0)   = fix(phadata(*,0)) 

udf_times  = dblarr(data_size(1),2)
udf_times  = phadata(0:data_size(1)-1,0:1)
udf_hours  = dblarr(data_size(1))
result     = convert_udf_times(udf_times,udf_hours)

nhours = udf_hours
 
;tof_einc       = phadata(*,4)

;stop

min_time = min_nz(day)*100
min_time = fix(min_time)
min_time = min_time/100.

max_time = max(day)*100
max_time = fix(max_time) + 1
max_time = max_time/100.

iyear = year(0)
iday  = day(0)

; get the data only for the given start and stop times                 
                                            
day_he3he4      = nhours
tofmass2        = tof2_mass  

shtim = strarr(1)
shtim = string(timall(0),timall(1),timall(2),timall(3),timall(4),timall(5), timall(6),timall(7), $
   format="(i2.2,':',i3.2,':',i2.2,':',i2.2,'-',i2.2,':',i3.2,':',i2.2,':',i2.2)")

shtim = strcompress(shtim,/remove)

; get the data only for the given start and stop times                 

nume = where(nhours ge begt and nhours lt endt, countm)
if (countm ge 1) then begin

day_he3he4      = nhours(nume)
tofmass2        = tofmass2(nume)
 
; plots vs time                                 

 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)      

new_hours = day_he3he4-begt+ih

!x.window = [location(1,0),location(1,2)]       
!y.window = [location(1,1),location(1,3)]    

if (dme eq 0) then begin
  pos_x   = (!x.window*!d.x_vsize)
  pos_y   = (!y.window*!d.y_vsize)
  
start_x = round(pos_x(1)-pos_x(0)) 
start_y = round(pos_y(1)-pos_y(0))

endif else begin
 
start_x = 648
start_y = 150

start_x = 608
start_y = 180

start_x = 568
start_y = 150


endelse 

; stop
   
; Time bin

xmass_val = start_x
xn_frac   =  etime/start_x

xmin_vals   = fltarr(xmass_val)
xmin_vals   = findgen(xmass_val)*xn_frac + stime

xmax_vals   = fltarr(xmass_val)
xmax_vals   = findgen(xmass_val)*xn_frac + xn_frac + stime

; logarithmic Mass bins

ymass_val      = start_y
yn_frac        = (alog10(70)-alog10(2))/start_y

ymin_vals      = fltarr(ymass_val)
ymin_vals      = findgen(ymass_val)*yn_frac + alog10(2)

ymax_vals      = fltarr(ymass_val)
ymax_vals      = findgen(ymass_val)*yn_frac + yn_frac + alog10(2)

xy_events      = fltarr(xmass_val,ymass_val) 

xy_events = hist_2d(new_hours,alog10(tofmass2),bin1=xn_frac,bin2=yn_frac,max1=xmax_vals(xmass_val-1),max2=ymax_vals(ymass_val-1),min1=xmin_vals(0),min2=ymin_vals(0)) 

new_max   = max(xy_events)
new_total = n_elements(tofmass2)

               
  new_xyevents = xy_events  
  n_min = min_nz(new_xyevents)
  n_max = max(new_xyevents)
    
  new_xyevents = (7+218*(new_xyevents-n_min)/(n_max-n_min))*(new_xyevents ge n_min)
  new_xyevents = new_xyevents*(new_xyevents le 218)+218*(new_xyevents gt 218)
 
if (dme eq 0) then begin    
  tv,new_xyevents,pos_x(0),pos_y(0),$
  xsize = pos_x(1) - pos_x(0),$
  ysize = pos_y(1) - pos_y(0),/device
  ;xyouts,/device,pos_x(0)+10,pos_y(1)-20,'(b)'
endif else begin
;  tv, [[[indgen(256)]], [[indgen(256)]], [[indgen(256)]]], true=3  
  tv,new_xyevents,!x.window(0),!y.window(0),$
  xsize = (!x.window(1) - !x.window(0)),$
  ysize = (!y.window(1) - !y.window(0)),/norm
  ;xyouts,/norm,!x.window(0)+0.03,!y.window(1)-0.03,'(b)'
endelse  

max_string = strarr(1)
max_string = strcompress(string(new_max))


 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)      

!p.color = 1
!p.position = location(1,*)                                                                                                  
crangex = [stime,etime]

crangey     = [2,80]
!y.tickname = ['10']
!y.ticks    = 0
!y.minor    = 9
!y.tickv    = [10] 

      timebox, stime, etime, /zero, exact=exact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize/1.3,$
      ytitle='Mass (AMU)', $
      nolabels=1, minutes = minutes, date = 1,noerase = 0    

species_string = strarr(11)
species_string = ['!U3!nHe','!U4!nHe','C','N','O','Ne','Mg','Si','S','Ca','Fe']
mass_values    = intarr(11)
mass_values    = [3,4,12,14,16,20,24,28,32,40,56]

for i = 0, 10 do begin
   xyouts,/data,etime+1,mass_values(i),species_string(i),align=0,charsize=csize/3.5
endfor   

color_index = intarr(212)
color_index = indgen(212)+7

x_vals = [0.93,0.95]
y_vals = fltarr(212)
y_frac = indgen(212)*0.0006

cnos = 0L
while(cnos lt 212) do begin
   y_vals(cnos) = 0.41 + y_frac(cnos)
   
   plots,/norm,x_vals,[y_vals(cnos),y_vals(cnos)],color=color_index(cnos),thick=1.5
  
  cnos = cnos + 1
endwhile

xyouts,/norm,0.95,y_vals(0),'1',charsize=csize/3.2,align=-0.5
xyouts,/norm,0.95,y_vals(202),max_string,charsize=csize/3.2,align=0
xyouts,/norm,0.97,0.41,'Counts/bin',orientation=90,align=-0.5,charsize = csize/3.2

xyouts,/norm,0.94,0.555,charsize=csize/3.2,align=0.5,string(format='(i7,a)',new_total,' events') 
  
;plots,/data,[stime,etime],[20,20],linestyle=2

type_axis = intarr(1)
type_axis = 0
;plot_aceshocks,timall,crangey,type_axis

;plot_sattimes,timall,crangey
;plot_shocktimes,timall,crangey
;plot_bdetimes,timall,crangey
;plot_upstreamtimes,timall,crangey

endif

if (countm eq 0) then begin
   
   stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)      

!p.color = 1
!p.position = location(1,*)                                                                                                  
crangex = [stime,etime]

crangey     = [2,80]
!y.tickname = ['10']
!y.ticks    = 0
!y.minor    = 9
!y.tickv    = [10] 

      timebox, stime, etime, /zero, exact=exact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize/1.3,$
      ytitle='Mass (AMU)', $
      nolabels=1, minutes = minutes, date = 1,noerase = 0 
 
endif

;print,countm

;stop

                                                                                                                                                                                                                                                    
end
