@/data/joey/ace/top_level/programs/convert_udf_times.pro

pro sit_webplots_custom

;
; program to plot 1-Hour averaged ULEIS data 
; Original M. Desai 2/13/04
;

; ***************************** get the file dates to process ***********************
	stereo_spacecraft=''
	;openr, lun_ctl,  '/data/joey/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_multipanel_custom.dat', /get_lun	
	 openr, lun_ctl, '/data/joey/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_multipanel_custom.dat', /get_lun  
	readf, lun_ctl, stereo_spacecraft, start_year, start_doy, stop_year, stop_doy, format='(a1, 4i5)'
	free_lun, lun_ctl

	if( start_year ge 2000) then two_digit_start_year = start_year - 2000 else two_digit_start_year = start_year - 1900
	if( stop_year ge 2000) then two_digit_stop_year = stop_year - 2000 else two_digit_stop_year = stop_year - 1900


!p.thick    = 2
!x.ticklen  = 0.08
!y.ticklen  = 0.04      
!x.thick=2
!y.thick=2
csize=2.5
syms  = 0
ebars = 1
lthick = 5
ssize = 1.0

y_vals = fltarr(4)
y_vals = [5e-2,1e-1,5e-3,1e-3]

; get time range

;timall = [7,24,0,0,7,28,0,0]
;timall = [8,40,0,0,8,44,0,0]
timall = [two_digit_start_year, start_doy, 0, 0, two_digit_stop_year, stop_doy, 0, 0]
  

@time_limits
time,timall(0:3),timall(4:7)

tim_all = timall

if (tim_all(0) gt 95) then begin
   tim_all(0) = 1900 + tim_all(0)
endif

if (tim_all(0) lt 95) then begin
   tim_all(0) = 2000 + tim_all(0)
endif

if (tim_all(4) gt 95) then begin
   tim_all(4) = 1900 + tim_all(4)
endif

if (tim_all(4) lt 95) then begin
   tim_all(4) = 2000 + tim_all(4)
endif

shtim = string(tim_all(0),tim_all(1),tim_all(2),tim_all(3),tim_all(4),tim_all(5),tim_all(6),tim_all(7), $
   format="(i4.2,':',i3.2,':',i2.2,':',i2.2,'-',i4.2,':',i3.2,':',i2.2,':',i2.2)")
shtim = strcompress(shtim,/remove)

file_subscript = string(tim_all(0),tim_all(1), $
   format="(i4.2,'_',i3.3)")
file_subscript = strcompress(file_subscript,/remove)



file_prefix = "/data/joey/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_sav_files/"  ; <----needs editing for source sav file paths
rates_file = file_prefix + "SIT_" + stereo_spacecraft + "_" + file_subscript + "_multi_panel_rates.sav" 
restore,rates_file


begt = hours(timall(0:1),[95,1]) + timall(2) + timall(3)/60.
endt = hours(timall(4:5),[95,1]) + timall(6) + timall(7)/60.
 
if (timall(0) gt 95) then begin
   start_year = 1900 + timall(0)
endif

if (timall(0) lt 95) then begin
   start_year = 2000 + timall(0)
endif

if (timall(4) gt 95) then begin
   stop_year = 1900 + timall(4)
endif

if (timall(4) lt 95) then begin
   stop_year = 2000 + timall(4)
endif

start_day  = timall(1)
start_hour = timall(2)
start_mins = timall(3)
stop_day   = timall(5)
stop_hour  = timall(6)
stop_mins  = timall(7)

tim_all = [start_year,start_day,start_hour,start_mins,stop_year,stop_day,stop_hour,stop_mins]

  data        = xdf.data
  data        = transpose(data)  
 
  data_size   = size(data)
  data(*,0)   = fix(data(*,0)) 
 

udf_times  = dblarr(data_size(1),2)
udf_times  = data(0:data_size(1)-1,0:1)
udf_hours  = dblarr(data_size(1))
result     = convert_udf_times(udf_times,udf_hours)

nhours = udf_hours

n_days = round((endt-begt)/24.)
doy = intarr(n_days + 1)
doy    = timall(1) + indgen(n_days+1)
yy     = intarr(n_days + 1) 

date_string = strarr(n_days +1)
result = get_date_string(timall,date_string)

tim_all = timall

if (tim_all(0) gt 95) then begin
   tim_all(0) = 1900 + tim_all(0)
endif
if (tim_all(0) lt 95) then begin
   tim_all(0) = 2000 + tim_all(0)
endif
if (tim_all(4) gt 95) then begin
   tim_all(4) = 1900 + tim_all(4)
endif
if (tim_all(4) lt 95) then begin
   tim_all(4) = 2000 + tim_all(4)
endif

sh_tim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
   format="(i4.2,'_',i3.3,'_',i4.2,'_',i3.3)")
sh_tim = strcompress(sh_tim,/remove)

; set the plotting device



dme = 1
spect = 10
if (dme eq 1) then begin
	ps_file_prefix = '/data/joey/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_multipanel_custom_ps_files/'
    psfilename = ps_file_prefix + "SIT_" + stereo_spacecraft + "_" + sh_tim + ".ps"
    dev = 'ps'
    set_plot,dev
endif else begin
   plot_open,dme,spect
endelse 

if (dme eq 1) then begin               
  if (spect eq 10) then begin   
     device,/color,/portrait,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
     device,xsize=20,ysize=24
     device,xoff=0.5,yoff=2.0
  endif   
    !p.color=1  
    !p.font=0
endif
   
   ; set up a simple color table
   
        bbc = 255b
        bfg = 0b
        
    if (n_elements(red) eq 0) then begin
        red = [bbc, bfg, 255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
               0b, 127b, 255b, 85b, 170b]
        gre = [bbc, bfg, 0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
               127b, 0b, 0b, 85b, 170b]
        blu = [bbc, bfg, 0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
               255b, 255b, 127b, 85b, 170b]
    endif else begin
        red(0:1) = [bbc, bfg]
        gre(0:1) = [bbc, bfg]
        blu(0:1) = [bbc, bfg]
    endelse
    tvlct, red, gre, blu
    tvlct, bfg, bfg, bfg, !d.n_colors-1 

;define a solid dot as a symbol

circ=findgen(16)*(!pi*2/16.)
usersym,cos(circ),sin(circ),/fill 
  
 plots_across = 1 ; # of plots across the page
 plots_down = 3; # of plots down the page 
   
!p.multi=[0,plots_across,plots_down,0,0]    

location = fltarr(plots_down,4)

location(0,*) = [0.09,0.6,0.8,0.85]
location(1,*) = [0.09,0.34,0.8,0.59]
location(2,*) = [0.09,0.08,0.8,0.33]
      
iyear = tstart(0)
iday  = tstart(1)

ih = timall(2)
im = timall(3)
eh = timall(6)
em = timall(7)

; get the data only for the given start and stop times                 

begt = hours(timall(0:1),[95,1]) + timall(2) + timall(3)/60.
endt = hours(timall(4:5),[95,1]) + timall(6) + timall(7)/60.

 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)  

locs_max = where(nhours ge begt and nhours le endt, countm)
 if (countm gt 1) then begin
   max_value = max(data(locs_max,3:6))
     if (max_value lt 100) then begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n']
       !y.ticks    = 5
       crangey     = [1e-3,1e+2]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2] 
     endif else begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
     endelse
 endif else begin 
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
 endelse 



; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize/1.2,$
      ytitle='#/(cm!U2!n s sr MeV/n.)',$
      nolabels=1, minutes = minutes, date = 0,noerase = 0    

xyouts,/norm,0.03,0.91,'STEREO-' + stereo_spacecraft + '/IMPACT/SEP/SIT',charsize=csize/3.0,align=0.0
xyouts,/norm,0.03,0.89,'Top: 0.19 MeV/n; Middle: mass < 8 AMU, 0.25-0.90 MeV/n; mass > 8 AMU, 0.08-0.15 MeV/n; Bottom: Mass 10-70 AMU',charsize=csize/3.5,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/4.5

time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/3.
endfor  

!p.color=4
;xyouts,/norm,0.9,0.81,'TF - CME F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.79,'TR - CME R/S',align=0,charsize = csize/4
!p.color=1

!p.color=2
;xyouts,/norm,0.9,0.77,'CF - CIR F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.75,'CR - CIR R/S',align=0,charsize = csize/4
!p.color=1

data_array = intarr(4)
data_array = indgen(4) + 3
array_name = strarr(4)
array_name = ['!U3!nHe','!U4!nHe','O','Fe']
col_index = intarr(4)
col_index = [1,2,3,4]
  

nume = where(nhours ge begt and nhours le endt, countm)
if (countm gt 1) then begin
    
dat_los = 1L    ; changed from:  dat_los = 0L  to suppress 3He trace  3/12/2010 /gm  
while (dat_los lt 4) do begin
  
         !p.color=col_index(dat_los)
         !p.thick=1
         oplot,nhours(nume)-begt+ih,data(nume,data_array(dat_los)),thick=lthick
         xyouts,/data,etime,y_vals(dat_los),array_name(dat_los),align = -0.2,charsize = csize/3.5
         !p.color = 1 

 dat_los = dat_los + 1
endwhile

        
type_axis = intarr(1)
type_axis = 1


crangex = [stime,etime]

endif

if (countm le 0) then begin
 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)  

!y.tickname = ['10!U-4!n','10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
!y.ticks    = 8
crangey     = [1e-4,1e+4]
!y.minor    = 9
!y.tickv    = [1e-4,1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 

; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize,$
      ytitle='particles/(cm!U2!n s sr MeV/nuc)', $
      nolabels=1, minutes = minutes, date = 0,noerase = 0    

time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/3.
endfor  

xyouts,/data,stime+3,crangey(1)/5.,'NO DATA AVAILABLE FOR THIS PERIOD'

!p.color=4
;xyouts,/norm,0.9,0.81,'TF - CME F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.79,'TR - CME R/S',align=0,charsize = csize/4
!p.color=1


xyouts,/norm,0.03,0.89,'Top: 0.270 MeV/n. Intensity; Middle: Energy range = 0.4-0.9 MeV/n.; Bottom: Mass Range = 10-70 AMU',charsize=csize/3.5,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/4.5

endif

sit_webplots_mass_custom,timall,location,dme, stereo_spacecraft, start_year, start_doy, stop_year, stop_doy
sit_webplots_smoosh_custom,timall,location,dme, stereo_spacecraft, start_year, start_doy, stop_year, stop_doy

; close plotting device
  
if (dme eq 0) then goto, docomp
  if (dme ne 0) then begin
      device,/close
  endif
docomp:


end
