	pro	sit_multipanel_custom
;
;
;	procedure to update sit 4-day webplots  /gm   Aug 2008
;		Modification history:
;			12-Sept-2008	require file version to be ge 2 to accept (avoids plots
;						being made with short files) /gm
;
;	program tasks
;		1) get days of new plot -- also spacecraft
;		2) generate new sit_lister_times files with the correct times
;
;

	read, start_year, start_day, prompt='enter start year, day of plot: '
	read, stop_year, stop_day, prompt='enter stop year, day of plot: '
	read, i_sc, prompt='enter 0 for Ahead S/C, 1 for Behind: '                  ; typo fixed 5/25/2010 /gm
	
	start_mjd = date2mjd(start_year,start_day)
	stop_mjd = date2mjd(stop_year,stop_day)

	
;	write out the new sit_lister_timesfile
	timeCDS = { MJD: 0L , TIME: 0L }
	timecds.mjd = start_mjd
	start_year = mjd2yr(timecds)   ; start year
	start_day = mjd2doy(timecds)    ; start day of year
	timecds.mjd =  stop_mjd
	stop_year = mjd2yr(timecds)   ; stop year
	stop_day = mjd2doy(timecds)    ; stop day of year	

;	print, start_year, start_day, stop_year, stop_day

	openw, lun_cfg, '/users/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_lister_times.dat', /get_lun	
;	copy line 1
	printf, lun_cfg, 'year,month,day,hour,minute, year_stop, month_stop, day_stop, hour_stop, minute_stop,  control_flag'
;	line 2 has the times -- print as month 1 followed by doy
	printf, lun_cfg, start_year, start_day, stop_year, stop_day, format="(x,i4,' 1 ',i3,' 0 0 ',i4,' 1 ',i3,' 0 0 3   ')"
	
	free_lun, lun_cfg

;	now write out the cfg file that has the spacecraft number and length of the period in days
	openw, lun_cfg, '/users/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_lister_cfg.dat', /get_lun	
;	just copy the first three lines:
	printf, lun_cfg, 'OUTPUT FOLDER:'
	printf, lun_cfg, '/users/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_lister_output/'
	printf, lun_cfg, 'spacecraft  avg_int(min) type(0,flx; 1 flu; 2 cts)   run_checks? (output true = odd)   pha_plot (0,1=t,e;2=m,e)  error limit (fraction) bkgd corr (1=on)'
;	now the line with the spacecraft name
	printf, lun_cfg, i_sc, 60, 0, 0, 0, 2, 0
;	now the next header line
	printf, lun_cfg, 'output files (0 = no; 1 = yes):   rate     pha     beacon    hk    spectra     pha_spectra  pha_rates      histograms   multi_panel_plot (length in days; usually = 4)  '
;	now the line with the length of the plot in days, etc.
	printf, lun_cfg, 0, 0, 0, 0, 0, 0, 0, 0, stop_mjd-start_mjd	
;	now the last 2 lines
	printf, lun_cfg, ' mass cuts for PHA file:  mlo,  mhi,     elo,        ehi   bin width (for histogram) (units:  AMU and MeV/n)'
	printf, lun_cfg, '     0.0    200.0     0.0  2000.0  0.1  '
	printf, lun_cfg, ' '

	free_lun, lun_cfg

;	write out the spacecraft choice and plot dates
	openw, lun_out,  '/users/masongm1/Programs/idl_SIT/multipanel_plot_maker_sit_custom/sit_multipanel_custom.dat', /get_lun	
	if( i_sc eq 0 ) then printf, lun_out, start_year, start_day, stop_year, stop_day, format='("A", 4i5)' else	$
		printf, lun_out, start_year, start_day, stop_year, stop_day, format='("B", 4i5)' 
	free_lun , lun_out
	
	
	end
	
	
