PRO OPEN_SIT_FILE, flag_open_sit_file, nsc, mjd_open, fin_flag
;
;	procedure to open a sit data file for reading
;
;	Initital version:	28-Aug-2006    /gm
;	
;	Modification history:
;		4-Dec-2006		modify directory structure for separate ptp file folders
;		27-Jun-2008		remove variable list from common sitcom /gm
;		17-Mar-2009		add variable fin_flag: if it is defined, then open .fin files only /gm
;		14-Jul-2014		increase version number search from 10 to 20 (error  sit_behind_2014_026_1_11.fin 
;						reported as not found) /gm

common sitcom
common calibration
common spacecraft
common output_items
common lun_numbers
common time_bounds
common misc_counters
common paths

;	if flag_open_sit_file = 1, then close the previous file
	if( flag_open_sit_file eq 1) then free_lun, lun_input
	flag_open_sit_file = 1   ; set this flag = 1 after the first call

;	printf, lun_print, start_mjd, stop_mjd, control_flag


;	find the start year and day of year

	MJD2DATE, mjd_open, YEAR, MONTH, DAY
	
	doy = mjd_open-date2mjd(year,1,1)+1
;	printf, lun_print, doy



	infilename=''
	loop_limit = 0
	if( n_elements(fin_flag) eq 0 ) then loop_limit = 1  ; if fin_flag not defined, then search .ptp also if .fin not found   3/17/2010 /gm 
;	print, fin_flag, n_elements(fin_flag)
	FOR j = 0,loop_limit DO BEGIN
	
	if(j eq 0) then extension = '.fin'    ; first search for a file with extension fin (final version)
	if(j eq 1) then extension = '.ptp'   ; if ftn not found, look for a preliminary version unless fin_flag has been set  3/17/2010
	
	FOR i=20,0,-1 DO BEGIN                   ; check up to 20 version numbers before quitting:  work from highest version number down
	
	infilename = 'sit_'+spacecraft_name(nsc)+'/sit_'+ spacecraft_name(nsc)+'_'+ $
	                                          string(year,doy,i, format='(i4,"_",i3.3,"_1_",i2.2)' ) + extension                       
	                                          

;			printf, lun_print, 'opening file = ', infilename
			
	openr, lun_input, flight_data_path + infilename, /get_lun, ERROR = err
;	printf, lun_print, ' error: ', err
		if(err eq 0) then break   ; leave "i" loop if file successfully opened

	ENDFOR  ; loop i
		if(err eq 0) then break   ; leave "j" loop if file successfully opened
	ENDFOR  ; loop j


	time_now = systime(1)
	index= strpos(infilename,"/")
;	if (err eq 0) then printf, lun_print, strmid(infilename,index+1), lun_input, time_now-start_time, format='("opening file: ", a, ",  lunit = ",i3,",  sec since last file open: ",f8.3)'
	start_time=time_now

;		section to deal with missing files
		if(err ne 0) then begin
;			printf, lun_print, 'file =  ', strmid(infilename,index+1), ' and .fin not found'	; **** add '.fin' to message 7/13/2015 /gm
			flag_open_sit_file = 0
		endif


end	

