
; Compute decompressed HET/SIT compressed counter values.  The HET
; and SIT counters are compressed using an 11-bit
; mantissa and a 5-bit exponent.
;
; Parameters
;   compressed = compressed counter values to be decompressed - can be an array or a scalar


function decompressHetSitCounters, compressed

common sitcom

  decompressed = ulong64(compressed) and 'FFFF'XL
  power = ishft(decompressed, -11)
  index = where(power gt 1, count)
  if (count gt 0) then begin
    decompressed[index] = (decompressed[index] and '7ff'X) or '800'X
    decompressed[index] = ishft(decompressed[index], power[index] - 1)
  endif

  index2 = where(decompressed gt 'FFFFFF'X, count)
  if (count gt 0) then $
;       decompressed[index2] = ulong64(FILL_L)
		decompressed[index2] = ulong64('FFFFFFFFFFFFFFFF'X)		; **** FILL-L above not defined; fixed 8/27/2015 /gm

  return, long(decompressed)
end

