	function datedoy2mjdfract, year, doy, hour, min
;
;	routine to calculate fractional mjd
;
;	gm	27_Aug_2014
;
;	Case 1:  if 2 paramteters passed, then interpreted as YYYY, decimal day of year
;	Case 2:  if 3 parameters passed, then interpreted as YYYY, doy, hour (minute set = 0)
;	Case 3:  if 4 parameters passed, than interpreted as YYYY, doy, Hr, Min
;
;;
;	year:  year number (4 digits required); may be an integer or decimal, but integer component will be used
;
;	decday:  decimal day of year

	Case n_params() of
		2:   return, date2mjd( floor(year), floor(doy)) + doy*1.d0 - floor(doy)
		3:   return,  date2mjd( floor(year), floor(doy)) + hour/24.d0
		4:   return,  date2mjd( floor(year), floor(doy)) + hour/24.d0 + min/1440.d0
	endcase
	print, " call to function datedoy2mjdfract with illegal number of parameters: ", n_params()
	end