	function date2mjdfract, year, decday, day, hour, min
;
;	routine to calculate fractional mjd
;
;	gm	10-Jul-2007
;
;	Case 1:  if 2 paramteters passed, then interpreted as YYYY, decimal day of year
;	Case 3:  if 3 paramteters passed, then interpreted as YYYY, Month, day of month (hr, min = 0)
;	Case 2:  if 4 parameters passed, then interpreted as YYYY, Month, Day of Month, hour (minute set = 0)
;	Case 3:  if 5 parameters passed, than interpreted as YYYY, Month, Da, Hr, Min
;
;;
;	year:  year number (4 digits required); may be an integer or decimal, but integer component will be used
;
;	decday:  decimal day of year

	Case n_params() of
		2:   return, date2mjd( floor(year), floor(decday)) + decday - floor(decday)
		3:   return,  date2mjd( floor(year), decday, day)
		4:   return,  date2mjd( floor(year), decday, day) + hour/24.d0
		5:   return,  date2mjd( floor(year), decday, day) + hour/24.d0 + min/1440.d0
	endcase
	print, " call to function date2mjdfract with illegal number of parameters: ", n_params()
	end