	pro sit_spectra_sum, input_file_now
;
;	routine to read sit_lister spectra files and create a single summed output
;
;	modification history:
;		7-Jun-2011	initial version /gm
;
	intensity_avg = fltarr(116)
	intensity_sigma_avg = fltarr(116)
	ratio_avg = fltarr(116)
	ratio_sigma_avg = fltarr(116)
	ratio_avg_ints = fltarr(116)
	input_items = fltarr(34)
	input_sum = fltarr(34)
	year_avg = 0.
	day_avg = 0.
	line_count = 0.
	effic = fltarr(2,116)
;	set up element names: H, 3He, 4He, C, O, NeS, Fe, or UH
	element_name = ['H', '3He', '4He', 'C', 'O', 'NeS', 'Fe', 'UH']
;	ratio_indices array generated with an Excel spread sheet then pasted into Word, etc.  ; specifies which of the 
;	0-115 matrix rates are divided by another rate, and gives the index;  if 0, no ratio is calculated
	ratio_indices = [0, 0, 0, 0, 0, 0, 0, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, $
		33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, $
		73, 74, 75, 76, 77, 78, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, $
		77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, $
		72, 73, 74, 75, 76, 77, 0, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 0, 0, 0, 0, 0, 0, 0, 0]

;
;	open the input file
	input_file_now = strtrim(input_file_now)
	openr, lun_input, input_file_now, /get_lun
;
;	determine if spacecraft is 'a' or 'b'
	if( strmid(input_file_now,strpos(strlowcase(input_file_now),'sit_',/reverse_search)+4,1) eq 'a' ) then spacecraft_id = 0 else spacecraft_id = 1

;	read in the current matrix box definitions
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/SIT_rate_boxes/sit_rate_box_ranges_041811_sav.dat'
;	restores structure matrix_rates;  tag names:  EMIN_NOMINAL EMAX_NOMINAL MASS_MIN MASS_MAX MASS_AVG Z	

;	read in the current efficiency file
	efficiency_file_name = '/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/SIT_efficiencies/sit_efficiencies_2011_04_27.dat'
	openr, lun_eff, efficiency_file_name, /get_lun	
	readf, lun_eff, format='(/)'    ;  skip header line
	for i = 0, 115 do begin
		readf, lun_eff, effic1, effic2
		effic(0,i) = effic1
		effic(1,i) = effic2
	endfor

	
;	************************* get output file name from the input file ***************
		output_file = strmid(input_file_now, 0, strpos(input_file_now,'.', /reverse_search)) + '_sum.txt'
		openw, lun_output, output_file ,/get_lun
;	copy the header lines from the input file and determine if file is for fluence or intensity
	input_string = ''
	readf, lun_input, input_string, format="(a)"
	printf, lun_output, input_string
	readf, lun_input, input_string, format="(a)"	
;	get number of header lines from line 2
	reads, strmid(input_string, 24,4), header_lines
;	write out the new header line count increased by 1 likne
	input_string_start = strmid(input_string,0,24)
	input_string_end = strmid(input_string,28,strlen(input_string))
	printf, lun_output, string(input_string_start,header_lines+1,input_string_end,format="(a,i4,a)")
;	print out the input file used:
	printf, lun_output, input_file_now, format="(' Spectra summed from file: ',a)"
	readf, lun_input, input_string, format="(a)"
	printf, lun_output, input_string
;	determne if intensity or fluences from the next header line
	readf, lun_input, input_string, format="(a)"
	printf, lun_output, input_string
	if( strpos(input_string, 'intensity') ne -1 ) then type_out = 0
	if( strpos(input_string, 'fluence') ne -1 ) then type_out = 1
;	now just fill out the rest of the lines
	for i = 5, header_lines + 1 do begin
		readf, lun_input, input_string, format="(a)"
		printf, lun_output, input_string	
	endfor

;	now read down the whole file and add up the intensities and the squares of the sigmas

	
;	*********** main loop for reading file ************	
	while (~eof(lun_input)) do begin
	readf, lun_input, input_string, format="(a)"
	line_count ++

;	extract the event number
	reads, input_string, event_number

;	strip off the string through end of date/time
	input_string = strmid( input_string, 32, strlen(input_string))

;	undo the kaleidagraph nested commas and fill out end of line with zeroes
	kal_line_undo, input_string, input_string_new

;	read in all the variables from the string
	reads, input_string_new, input_items

;	sum up the year and day	
	year_avg += input_items(0)
	day_avg += input_items(1)
	
;	find the matrix box number for this line
	find_box_number, matrix_rates, spacecraft_id, element_name, input_items, item_number, box_number
	if( box_number eq -1 ) then goto, next_event
;	print, line_count, event_number, box_number, input_items(0:19)

;	now add up the intensities and ratio values  (note:  skip around O since other ratios wrt 0)
	intensity_avg(box_number) += input_items(item_number)
	intensity_sigma_avg(box_number) += input_items(item_number+ 1)^2
	
	if( item_number le 12 ) then begin	; do weighted average (see Bevington p 73)
		if( input_items(item_number + 16) gt 0. ) then begin
			ratio_avg(box_number) += double(input_items(item_number + 16))/input_items(item_number + 1 + 16)^2
			ratio_sigma_avg(box_number) += 1.d0/input_items(item_number + 1 + 16)^2
;			code below is for unweighted average
;			ratio_avg_ints(box_number) ++
;			ratio_avg(box_number) += double(input_items(item_number + 16))
;			ratio_sigma_avg(box_number) += input_items(item_number + 1 + 16)^2
		endif
	endif
	if( (item_number ge 16) and (item_number lt 20) ) then begin
		if( input_items(item_number + 14) gt 0. ) then begin
			ratio_avg(box_number) += double(input_items(item_number + 14)/input_items(item_number + 1 + 14)^2)
			ratio_sigma_avg(box_number) += double(1./input_items(item_number + 1 + 14)^2)
;			ratio_avg_ints(box_number) ++
;			if( box_number eq 96 ) then stop
		endif
	endif
next_event:	
	endwhile    ; end of file reading loop

;	average the results over the number of averaging periods (if fluences, do not divide by number of periods)
;	first average year and day
	year_avg /= float(line_count)
	day_avg /= float(line_count)

	intensity_sigma_avg = sqrt( intensity_sigma_avg )   ; use number of events so as to not ignore missing (=0) values
	if( type_out eq 0 ) then begin 
		intensity_avg /= float( event_number)
		intensity_sigma_avg /= float( event_number)
	endif

	ratio_avg /= ratio_sigma_avg
	ratio_sigma_avg = sqrt( 1.d0/ratio_sigma_avg)
;	unweighted average code
;	ratio_avg = ratio_avg/ratio_avg_ints
;	ratio_sigma_avg = sqrt(ratio_sigma_avg/ratio_avg_ints)


;	now print out the results (adapted from write_pha_spectra.pro)

	header_string = string( event_number, ' date', year_avg, day_avg, format ='(1x, i6, ",", a,"," 2(f16.6,","))'   )
	for i=7,115 do begin
	
;	skip lines if intensity if zero
	if( intensity_avg(i) gt 0.) then begin
;	first part of the string is the energy ranges, taken from the matrix rate box table
		print_string=''
		print_string = print_string + string( matrix_rates(i).emin_nominal(spacecraft_id),matrix_rates(i).emax_nominal(spacecraft_id),(matrix_rates(i).emin_nominal(spacecraft_id)+matrix_rates(i).emax_nominal(spacecraft_id))/2., $
				(matrix_rates(i).emax_nominal(spacecraft_id)-matrix_rates(i).emin_nominal(spacecraft_id))/2., format ='(4(f10.5,","))' )
		if((i ge 7) and (i le 18)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(2(e15.5,","))' )
		if((i ge 19) and (i le 28)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='((",,"),2(e15.5,","))' )
		if((i ge 29) and (i le 44)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(2(",,"),2(e15.5,","))' )
		if((i ge 45) and (i le 61)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(3(",,"),2(e15.5,","))' )
		if((i ge 62) and (i le 77)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(4(",,"),2(e15.5,","))' )
		if((i ge 78) and (i le 93)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(5(",,"),2(e15.5,","))' )
		if((i ge 94) and (i le 107)) then print_string = print_string + string(intensity_avg(i), intensity_sigma_avg(i), format ='(6(",,"),2(e15.5,","))' )

;	print out the ratios if the efficiencies for both numerator and denominator are gt 0.
		if( ( ratio_avg(i) gt 0. ) and (effic(spacecraft_id,i) gt 0.) and  (effic(spacecraft_id, ratio_indices(i)) gt 0.) ) then begin
			if((i ge 7) and (i le 18)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 19) and (i le 28)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 29) and (i le 44)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 46) and (i le 61)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 78) and (i le 93)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(6(",,"),2(e15.5,","))' )
			if((i ge 95) and (i le 107)  ) then print_string = print_string + string(ratio_avg(i), ratio_sigma_avg(i), format ='(6(",,")2(e15.5,","))' )
		endif
		
	printf,  lun_output, header_string + print_string	

	endif  ; for intensity > 0 test
	
	endfor

	close, /all
;	stop
	end
