	pro 	find_box_number, matrix_rates, spacecraft_id, element_name, input_items, item_number, box_number
;
;	routine to find a matrix_rate box number from the input line data
;	
;	inputs to routine:
;		matrix_rates: structure containing box names, energy limits, etc.
;		spacecraft_id:  0 = ahead, 1 = behind
;		element_name:  array of element names
;		input_items:  array of values from input line
;
;	outputs from routine:
;		item_number:  first non-zero intensity value on the input line
;		box_number:  matrix box number for this line
;



;	the element for this line is identified by the first data quantity with non zero value
	element_number = min( where( input_items(6:33) gt 0. ) )/2

;	item_number is array index for this value
	item_number = element_number*2 + 6

;	now get the box number
	box_number = where( (matrix_rates.mat_names(spacecraft_id) eq element_name(element_number)) and (matrix_rates.emin_nominal(spacecraft_id) eq input_items(2)) )

	return
	end
