	pro sit_quiet_time_calculator
;	pro sit_quiet_time_calculator, input_file

;
;	routine to analyze 24 hour files and 
;		find lowest X days of a given year or range of years
;		compute background spectra for the selected period
;		produce a file of sit_lister time intervals that can be used to add up all species
;
;	Modification history: 
;		30-Jul-2013 	initial version /gm
;
;
	input_file = '/data/joey/masongm1/Data/ACE_flight_misc/Mewaldt_suprathermals/2013_07_update/SIT_B_2007_030_rates.txt'


;	extract the folder where the output file will go	
	output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'
	
;	read, start_year, stop_year, prompt="Enter start and stop year for search: "
	read, num_days, prompt="Enter number of days of lowest intensity for search: "

;	open the output file for the times selected
	openw, lun_output, output_folder + 'time_intervals.txt', /get_lun
	printf, lun_output, 'year,month,day,hour,minute, year_stop, month_stop, day_stop, hour_stop, minute_stop,  bound_flag'

	for year = 2007, 2013 do begin

;	open input file
	input_file=strtrim(input_file,2)   ; remove any leading or trailing blanks
	print, 'opening: ', input_file	
	openr, lun_input, input_file, /get_lun

	
;	now open the input file and read in the  proton intensities for the years indicated
	openr, lun_input, input_file, /get_lun 
;	space down to the start of the data
	input_string = ''
	test_string = ''
	input_array = fltarr(124)
	data_array = fltarr(10000, 124)
	day_num = 0L
	while( strpos( input_string, 'Time,year,day' ) eq -1 ) do readf, lun_input, input_string
;	now read the file and keep the days falling into the year bounds
	while( ~eof(lun_input) ) do begin
		readf, lun_input, input_string
		if( strlen(input_string) gt 100.) then begin	; skip short data records
;			strip off the time column
			input_string = strmid(input_string, 26, strlen(input_string) )

;			get rid of ALL of the ',,' entries
			while( strpos(input_string,',,') ne -1) do input_string = replace_text(input_string, ',,', ', 0.,')
		
			reads, input_string, input_array
;			stop
			if( (input_array(0) ge year) and (input_array(0) le (year + 1) ) ) then begin
				data_array(day_num,*) = input_array
				day_num ++
			endif
		endif
	endwhile
;	get rid of unused part of data_array
	data_array = data_array(0:day_num-1,*)
	
;	now select the num_days lowest days based on the 540 keV H intensity data_array(x,20)
	h_intensity=data_array(*,19)
	lowest_days = sort(h_intensity)
;	now restrict to the number of days requested
	lowest_days = lowest_days(0:num_days-1)	
	lowest_intensities = h_intensity(lowest_days)
	
;	now compute the average value for protons (items 18-27) for these lowest days
	proton_average = fltarr(10)
	for i = 18, 27 do proton_average(i-18) = mean(data_array(lowest_days, i))
	for i = 0, 9 do print, i, proton_average(i)
	
;	write output time lines
;	2007 1 30 0 0 2013 1 206 0 0 3
	continue = 1
	for i = 0, num_days-1 do begin
		if(i eq (num_days-1) ) then continue = 2
		year_start = data_array(lowest_days(i),0)
		day_start = data_array(lowest_days(i),1)
		printf, lun_output, year_start, 1, day_start, 0, 0, year_start, 1, day_start+1, 0, 0, continue, format="(11i6)"

	endfor
	
	free_lun, lun_input

	
	endfor	; year loop

	close,/all
	
	stop
	end
