PRO SIT_LISTER_webfiles, spacecraft,  avg_int, pha_rates_flag
;+
;	
; 	procedure to read STEREO telemetry data files and write ascii webfiles
;
;	Input parameters:
;		spacecraft:	0 = ahead
;					1 = behind
;		avg_int:		1 = 1 min
;					10 = 10 min
;					60 = 1 hr
;					1440 = 1 day
;		pha_rates_flag (optional)
;					0 = intensities will be calculated with rom boxes
;					1 = intensities will be calculated with pha data
;					not present:  program switches after dates given in array: cal_table_date
;
;
;
;
; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech
;			Modified from program sit_rates.pro by Andrew Davis / gm
;	Modification history:
;		17-Mar-2009	Adapted from sit_lister /gm
;		21-Feb-2011	check for file sit file not found, and skip day in that case /gm
;		10-May-2011	add option to compute rates using pha data /gm
;		15-Mar-2013	modify to handle dropping of apid 606-616 packets if empty, using
;					modified process_pha and process_pha_times subroutines in sdf_lister /gm
;		18-Jun-2013	modify output log writing to support split _a and _b logs (see get_webfiles_start_stop.pro) /gm
;		8-Aug-2014	remove 3 lowest energy Fe bins;  now do Fe rates 97-107 instead of old 94-107 (see line 66) /gm
;		13-Nov-2018	pha_rates_flag hard wired to = 1 to give intensities from pha data / gm

; ****************************************************************

	@sit_common.inc

	read_paths

;	initialize control flags --  	0 = open file and set up headers
;						1 = running value
;						2 = close file
flag_rates=0L
flag_open_sit_file=0L
files_missed = 0L
;	initialize control flags used in sit_lister -- 
;
	spacecraft_name_log_file = ['a','b']

pha_spectra_out = 0L
pha_out = 0L
histogram_out = 0L
spectra_out = 0L
multi_panel_out = 0L
spacecraft_id = spacecraft
swoosh_flag = intarr(1)
control_flag = 3
interval_number = 1
type_out = 0			; flux units
avg_int_rates = avg_int
avg_int_pha_rates = avg_int
run_checks = 0L
histogram_num = 1

;	initialize low and high energy rate boundaries;  high energies same for both units, but low energy is not
;	use common bounds for both units;  choose higher of the low energy bins where effic > 0
;	see efficiency file:   sit_efficiencies_2011_04_27
	rate_lo = [9, 32, 65, 97]				; H, He, O, Fe	********************* 8/8/2014
	rate_hi = [15, 41, 74, 107]			; H, He, O, Fe
	lun_output = intarr(n_elements(rate_lo))
	num_rates = intarr(n_elements(rate_lo))

	get_webfiles_start_stop, spacecraft,  avg_int, mjd_first, mjd_last, line_no
	
;	if pha_rates_flag not set then automatically select pha rates, matrix rates, or both in this file
	cal_table_date = [55671,  55686]     ; 4/20/2011 for sit-a,  5/5/2011 for sit-b
		rates_out = 0L				; default case -- pha rates used
		pha_rates_out = 1L			; default case -- pha rates used
	rate_type = 1    ; mixed case -- switch between pha and matrix rates in this file
	if( mjd_last lt cal_table_date(spacecraft) ) then rate_type = 2  ; pha_rates
	if( mjd_first ge (cal_table_date(spacecraft) + 1) ) then begin   ;  file is all matrix rates
		rate_type = 0L
		rates_out = 1L
		pha_rates_out = 0L
	endif

;	if pha_rate_flag is used, then use that choice to determing processing mode
;
;	***************** pha_rates_flag set =1 to handle data after SIT-A matrix box problem ************
;
	pha_rates_flag = 1

	if( n_elements( pha_rates_flag) ne 0 ) then begin
		if( pha_rates_flag eq 0 ) then begin
			rate_type = 0L    ; matrix rates
			rates_out = 1L
			pha_rates_out = 0L		
		endif
		if( pha_rates_flag eq 1 ) then begin
			rate_type = 2  ; pha_rates
			rates_out = 0L
			pha_rates_out = 1L
		endif
	endif
;
;	********************* read calibration after output types known (to see if large files can be skipped ***********	
	read_calibration

;	open output files
	open_outputs_webfiles, spacecraft,  avg_int, mjd_first, mjd_last, rate_type, cal_table_date

	mjd_now = mjd_first	
	WHILE (mjd_now le mjd_last) DO BEGIN      ;  file opening loop

	
	open_sit_file, flag_open_sit_file, spacecraft, mjd_now, 1  ; fin_flag = 1, so open .fin files only
	if( flag_open_sit_file eq 0 ) then goto, nextday		; skip this day if file missing   2/21/2011 /gm
	count_reads=0L	
	packet = 0
;	stop
;	when opening a new day see if we switch between pha rates and matrix rates
	if( (rate_type eq 1) and (mjd_now eq (cal_table_date(spacecraft) + 1)) ) then begin
		rate_type = 0L
		rates_out = 1L
		pha_rates_out = 0L
	endif
	

	  WHILE 1 DO BEGIN             ; reading loop

	read_stereo_pkt, lun_input, packet
	if n_elements(packet) eq 0 then break
;
;	compute current time
;
	current_time = tai2utc(double(packet.pkt.seconds), /NOCORRECT)
	current_mjd = double(current_time.mjd) + double(current_time.time)/(86400.d0*1000.d0)


;	process this packet

	apid = parse_stereo_pkt(packet, /APID )
	proc_flag = 1   ; running value

	if( apid eq 605 ) then begin
		process_rates, packet, flag_rates, proc_flag
		if( pha_rates_out ) then process_pha_times, packet, apid, run_checks,  histogram_num, proc_flag, pha_case
	endif
	
	if( ( apid ge 606) and ( apid le 616) and pha_rates_out ) then process_pha, packet, apid, run_checks,  histogram_num, proc_flag, pha_case

	
	if((apid ge 577) and (apid le 616) ) then count_reads=count_reads+1
;	if(count_reads gt 100) then break


	ENDWHILE   ; loop for reading packets from one day (file) ***********
	
;	write out any partial sums at end of day (averaging interval gt 1)
nextday:  
	proc_flag = 4
	if(avg_int gt 1 ) then begin
		if ( rates_out ) then process_rates, packet, flag_rates, proc_flag
		if ( pha_rates_out ) then begin
;			print, ' calling process pha at end of day  -- main pgm line 139'
;		for writing out pha rates at day crossing, use the current interval start			
			utc_interval_start_pha_rates = utc_interval_start
			process_pha, packet, apid, run_checks,  histogram_num, proc_flag, pha_case
		endif
	endif

	if( mjd_now eq mjd_last) then break  ; leave file processing loop if we've gone beyond end time

;	now go on to next day
	mjd_now ++


	ENDWHILE   ; loop for files   *********************************

;	write out any partial sums at end of run (averaging interval gt 1)
	proc_flag = 4
	if(avg_int gt 1 ) then begin
		if ( rates_out ) then process_rates, packet, flag_rates, proc_flag
		if ( pha_rates_out ) then begin
;			print, ' calling process pha at end of run -- main pgm line 157
			process_pha, packet, apid, run_checks,  histogram_num, proc_flag, pha_case
		endif
	endif


;	finish up	
		
;	now update the log file with the date processed information
	openr, lun_log, '/data/joey/masongm1/Data/Production/STEREO/0_batch_jobs/logs/last_webfiles_' + spacecraft_name_log_file(spacecraft) + '.txt', /get_lun
	instring = strarr(4)
	instring_temp=''
	for i = 0, 3 do begin 
		readf, lun_log, instring_temp
		instring(i) = instring_temp
	endfor
	free_lun, lun_log

;	get the output file entries for the mjd_last
	mjd2date, mjd_last, year_last, month_last, day_last
	if( avg_int eq 10) then param2 = month_last else param2 = mjd_last - date2mjd(year_last, 1) + 1.d0

	openw, lun_log, '/data/joey/masongm1/Data/Production/STEREO/0_batch_jobs/logs/last_webfiles_' + spacecraft_name_log_file(spacecraft) + '.txt', /get_lun	
	for i = 0,3 do begin
		if( i eq line_no ) then printf, lun_log,  year_last, param2, strmid(instring(i),20,strlen(instring(i))) , format="(2(3x,i5,2x),a)" ELSE printf, lun_log, instring(i)
	endfor
	free_lun, lun_log
	
;	printf, lun_print, " sit_lister_webfiles is finished at ",systime()
;	printf, lun_print, format="(50('*'), //)"
	close,/all

;	exit with status = 2 (new file has been written out);  NOTE: if no new data, exit with status = 1 from proc get_webfiles_start_stop
	exit, status = 2
		
end 
