	pro open_outputs_webfiles, spacecraft,  avg_int, mjd_first, mjd_last, rate_type, cal_table_date
;	routine to open output files
;
;	Modification history
;		19-Mar-2010	initial version /gm
;		17-May-2011	change output file directory structure to mirror ftp site /gm
;		24-Jun-2011	fix doy change bug in rate_type eq 1 section /gm
;
common lun_numbers
common rate_information
common rate_averages
common mbox_factors
common spacecraft
common webfiles

	folder_name = ['a','b']

;	initialize flag that shows webfiles are being generated
	webfiles_out = 1

	path = string(folder_name(spacecraft), format="('/data/joey/masongm1/Data/Production/STEREO/4_webfiles/webfiles_sit_',a,'_')" )
	case avg_int of
		1:			path = path + '1min/'
		10:			path = path + '10min/'
		60:			path = path + '1hr/'
		1440:		path = path + '1day/'
	endcase

	
	mjd2date, mjd_first, year, month, day
	doy = mjd_first - date2mjd(year,1,1) + 1.d0
	
	for i = 0, (n_elements(rate_lo)-1) do begin
;		print, ' entering open file loop: ', i, doy, spacecraft,  avg_int, mjd_first, mjd_last, rate_type, cal_table_date
		if(avg_int eq 1) then file_name = string(spacecraft_name(spacecraft), matrix_rates[rate_lo(i)].mat_names(spacecraft), year, doy, format="('SIT_',a,'_1min_',a,'_',i4,'_',i3.3,'.txt')" )
		if(avg_int eq 10) then file_name = string(spacecraft_name(spacecraft), matrix_rates[rate_lo(i)].mat_names(spacecraft), year, month, format="('SIT_',a,'_10min_',a,'_',i4,'_',i2.2,'.txt')" )
		if(avg_int eq 60) then file_name = string(spacecraft_name(spacecraft), matrix_rates[rate_lo(i)].mat_names(spacecraft), year, format="('SIT_',a,'_1hr_',a,'_',i4,'.txt')" )
		if(avg_int eq 1440) then file_name = string(spacecraft_name(spacecraft), matrix_rates[rate_lo(i)].mat_names(spacecraft), year, format="('SIT_',a,'_1day_',a,'_',i4,'.txt')" )
		if( avg_int le 10) then begin 
                  full_path = path + matrix_rates[rate_lo(i)].mat_names(spacecraft) + '/' + file_name
                endif else begin
                  full_path = path  + file_name
                endelse
;                print, "JM - opening ", full_path
                openw, lun_out, full_path, /get_lun
		lun_output(i) = lun_out
		printf, lun_output(i), spacecraft_name(spacecraft), matrix_rates[rate_lo(i)].mat_names(spacecraft), format="('STEREO SIT_',a,' Level 1 ',a,' intensity')"
		printf, lun_output(i), systime(), format="('File created: ',a, ' at SWRI')"		;	1/8/2016/gm note version for SWRI production
		print_cal_files, lun_output(i)
		if( rate_type eq 0 ) then printf, lun_output(i), 'Intensities calculated using on-board matrix rate binning'
		if( rate_type eq 1 ) then begin
			mjd2date,cal_table_date(spacecraft), year_table, month_table, day_table
			timeCDS =   { MJD: 0L , TIME: 0L }
			timecds.mjd = cal_table_date(spacecraft)
			timecds.time = 0.
			doy_table = mjd2doy(timecds)
			month_name = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sept','Oct','Nov','Dec']
			printf, lun_output(i), month_name(month_table-1), day_table, year_table, doy_table, format="( 'Intensities calculated using pulse-height-analysis data through ',a,' ',i0,',',i5,' (day ',i0,') ; on-board matrix rate binning thereafter')"	
		endif
		if( rate_type eq 2 ) then printf, lun_output(i), 'Intensities calculated using pulse-height-analysis data'
		if(avg_int eq 1) then printf, lun_output(i), 'Averaging interval: 1 minute (highest SIT time resolution)'
		if(avg_int eq 10) then printf, lun_output(i), 'Averaging interval: 10 minutes'
		if(avg_int eq 60) then  printf, lun_output(i), 'Averaging interval: 1 hour'
		if(avg_int eq 1440) then  printf, lun_output(i), 'Averaging interval: 1 day'
		printf, lun_output(i), 'Note:  timestamps mark beginning of averaging interval'
		printf, lun_output(i), 'Column 1: Year'
		printf, lun_output(i), 'Column 2: Day of year (fractional)'
		printf, lun_output(i), 'Column 3: Hour of day'
		printf, lun_output(i), 'Column 4: Minute of hour'
		printf, lun_output(i), 'Column 5: Second of minute'
		printf, lun_output(i), 'Column 6: number of minutes summed in rate'
;		for j= rate_lo(i), rate_hi(i) do printf, lun_output(i), j+7-rate_lo(i) , matrix_rates[j].emin_nominal(spacecraft), matrix_rates[j].emax_nominal(spacecraft), matrix_rates[j].mat_names(spacecraft), format="('Column ',i0,':',2x,f5.3, ' - ', f5.3,' MeV/n ',a,' intensity (1/(cm^2 s sr MeV/nuc))' )"
		for j= rate_lo(i), rate_hi(i) do printf, lun_output(i), j+7-rate_lo(i) , matrix_rates[j].emin_nominal(spacecraft), matrix_rates[j].emax_nominal(spacecraft), matrix_rates[j].mat_names(spacecraft), format="('Column ',i0,':',2x,f5.3, ' - ', f5.3,' MeV/n ',a,' intensity (1/(cm^2 s sr MeV/nuc))' )"
		next_line =  (rate_hi(i) - rate_lo(i)) + 1 + 6 + 1
		num_rates(i) =  (rate_hi(i) - rate_lo(i)) + 1 
		printf, lun_output(i), next_line, next_line + num_rates(i) -1, matrix_rates[rate_lo(i)].mat_names(spacecraft), format="('Columns ',i0,' - ',i0,':  ', a,' total counts for same energy ranges as above' )"
		printf, lun_output(i), 'BEGIN DATA'

			
	endfor	

	end
