	pro get_webfiles_start_stop, spacecraft,  avg_int, mjd_first, mjd_last ,line_no
;
;	routine to get start and stop day for this run
;
;	Parameters passed to procedure:
;			spacecraft		0 =  STEREO-A;  1 = STEREO-B
;			avg_int			averaging interval in minutes (1, 10, 60, 1440 allowed values)
;	Parameters returned from procedure
;			mjd_first			first date file to process
;			mjd_last			first date file to process
;			line_no			line number on last_webfiles.txt log where last data processed is located
;			year				year of last data processed
;			param2			day of year of last data processed (if avg_int = 1, or 10)
;
;	Note: if all files to process an interval are not present, then the routine EXITS with status = 1
;
;
;
;	Modification history:
;		17-Mar-2010	initial version /gm
;		20-Jan-2011	add provision to handle missing days using get_sit_missing_days.pro  /gm
;		21-Feb-2011	comment out stop statement in line 131 left from Jan 20 mod!  /gm
;		May-2011		misc changes for modified sit_lister_webfiles support
;
;	******** get list of any missing days of data
	get_sit_missing_days, spacecraft,  n_missing, mjd_missing


;	******** get last period processed ************
	openr, lun_log, '/data/joey/masongm1/Data/Production/STEREO/0_batch_jobs/logs/last_webfiles.txt', /get_lun
;
;	compute the line number for the last period for this data type
	
	case avg_int of
	
	1:		line_no = 0 + spacecraft	; lines 0, 1 have last file for 1 min average daily files
	10:		line_no = 2 + spacecraft	; lines 2, 3 have last line for 10 min average monthly files
	60:		line_no = 4 + spacecraft	; lines 4, 5 have last line for 60 min average yearly files
	1440:	line_no = 6 + spacecraft	; lines 6, 7 have last line for daily average yearly files
	
	endcase
	
	for i = 0, 1 do begin
		readf, lun_log, param1, param2
		if(i eq line_no) then begin
			year = param1
			doy = param2
		endif
	endfor
	
	for i = 2, 3 do begin
		readf, lun_log, param1, param2
		if(i eq line_no) then begin
			year = param1
			month = param2
		endif
	endfor
		
	for i = 4, 7 do begin
		readf, lun_log, param1, param2
		if(i eq line_no) then begin
			year = param1
			doy = param2
		endif
	endfor	
	free_lun, lun_log
	
;	find the start and end date of this run (1 day after last date)
	if( avg_int eq 1 ) then begin
		mjd_first = date2mjd(year, doy) + 1.d0
		mjd_last = mjd_first
	endif
	
	if( avg_int eq 10 ) then begin
		mjd_first = date2mjd(year, month + 1, 1)
		mjd_last = date2mjd(year, month + 2, 1) - 1.d0
	endif
	if( avg_int ge 60 ) then begin
;		did the last run end on the last day of the year?
		mjd_test = date2mjd(year, doy)
		mjd2date, mjd_test + 1.d0, year_test, month, day
		if( year eq year_test ) then begin
;		year number did not change so we use the same year as previous run		
			mjd_first = date2mjd(year, 1)
			mjd_last = date2mjd(year + 1, 1) - 1.d0   ; tentative value of mjd_last (if whole year is present)
		endif else begin
;		prior run was on last day of year, so go to next year
			mjd_first = date2mjd(year + 1, 1)
			mjd_last = date2mjd(year + 2, 1) - 1.d0   ; tentative value of mjd_last (if whole year is present)				
		endelse
	endif

;	print, ' interval length: ', avg_int, ' minutes, start & stop mjd: ', mjd_first, mjd_last
	
;	now see if ALL the necessary .fin files are present for this interval: 
	if( spacecraft eq 0 ) then openr, lun_log, '/data/joey/masongm1/Data/Production/General/get_data/data_status/stereo_ahead_files.txt', /get_lun
	if( spacecraft eq 1 ) then openr, lun_log, '/data/joey/masongm1/Data/Production/General/get_data/data_status/stereo_behind_files.txt', /get_lun
;
;	create an array that has the mjdates of all the needed days
	date_array = lindgen(mjd_last - mjd_first+ 1) + mjd_first
	in_string = ''
	while( eof(lun_log) ne 1 ) do begin
;		sit_ahead_2006_305_1_00.fin
		readf, lun_log, in_string
		if( strpos(in_string, 'fin') gt 0) then begin
			if(spacecraft eq 0) then reads, in_string, year, doy, format="(10x, i4, x, i3)"
			if(spacecraft eq 1) then reads, in_string, year, doy, format="(11x, i4, x, i3)"
			file_date = date2mjd(year, doy)
			index = where(date_array eq file_date)
			if(index ge 0) then begin
				date_array(index) = 0   ; zero out date_array cells where a file is present
			endif else begin
;	now check to see if there are missing days for this period, and if so mark as "present" to allow plot to go forward   1/20/2011  /gm
			if( (n_missing gt 0) and (avg_int gt 1 ) ) then begin
					for j = 0, (n_missing - 1) do begin
						for i = 0, (size(date_array,/n_elements) - 1) do if(mjd_missing(j) eq date_array(i) ) then date_array(i) = 0
					endfor
			endif
			endelse
		endif
	endwhile
	free_lun, lun_log	
	
;	if avg_int = 1 see if a missing day corresponds to the selected date;  if so, just go to the next date  5/18/2011 /gm
;	will not handle multiple missing days in a row

				if( (n_missing gt 0) and (avg_int eq 1 ) and (date_array(0) gt 0) ) then begin
					for j = 0, (n_missing - 1) do begin
						if(mjd_missing(j) eq date_array(0) ) then begin
							date_array(0) = 0
							mjd_first ++
							mjd_last ++
							return
						endif
					endfor
				endif
				
			

			
;			print,  year, doy, file_date, total(date_array)

;	****************** special exception -- if sit-b start date cannot be before 1/27/2007 *************** 5/20/2011 /gm
	if( (spacecraft eq 1) and (mjd_first lt 54127 ) ) then mjd_first = 54127
;	***************************************************************************************************

;	if all of date_array string is zero, then all the dates have been found
	if( total(date_array) eq 0) then return
;	stop -- commented out 2/21/2011  /gm
;	if a yearly array, just use the last mjd found if it is less than the last day of the year
	if( avg_int ge 60) then begin
		first_non_zero = where(date_array)
		if( first_non_zero(0) ge 0 ) then mjd_last = date_array(first_non_zero(0)) - 1.d0
	endif

;	if some dates missing from 1 or 10 min avg, exit with status = 1;  no changes made to input log file	
	if( avg_int le 10 ) then exit, status=1
	
;	if yearly files (60 or 1440 min averages) exit with status = 1 if new end data is same as prior end date
	if(mjd_last eq mjd_test ) then exit, status = 1

	end
