	PRO read_calibration
;
;	reads in SIT tables etc., contains statements moved from old sit_common.pro
;
;		27-Jun-2008	/gm
;		test versioni with hex table date variable  10/20/2010 /gm
;
	common sitcom
	common paths	
	common calibration
	common hex_tables
	common spacecraft
	common rate_information
	common background_correction
	common output_items
	common pha_plots

	hex_table_date='102910'

	; test if the elements have already been read in:
		restore_tables = 0   ; set restore tables = false
		if n_elements(amass_array) eq 0 then restore_tables = 1
	if restore_tables then BEGIN
		print,'Reading in instrument calibration'
		restore,filename = calibration_data_path +'amass_sav.dat'
		restore,filename = calibration_data_path +'energy_sav.dat'
		restore,filename = calibration_data_path +'einc_ssd_sav.dat'
		restore,filename = calibration_data_path +'einc_tof_sav.dat'
		restore,filename = calibration_data_path +'tof_sav.dat'
		print,'Instrument calibration read in'	
		
;		print, ' restoring hex file: ','sit_hex_tables_042806.dat'
;		restore, filename=hex_table_path + 'sit_hex_tables_042806.dat'
;		print, ' restoring hex file: ','sit_hex_tables_030507.dat'
;		restore, filename=hex_table_path + 'sit_hex_tables_030507.dat'
;		print, ' restoring hex file: ','sit_hex_tables_041107.dat'
;		restore, filename=hex_table_path + 'sit_hex_tables_041107.dat'
		print, ' restoring hex file: ','sit_hex_tables_'+hex_table_date+'.dat'
		restore, filename=hex_table_path + 'sit_hex_tables_'+hex_table_date+'.dat'
		hex_table_mjd = date2mjd(2010,09,24)    ; store table date -- box check is only for data after date of current table
		
	ENDIF
	
	if restore_tables then BEGIN
		print, 'restoring sit_rate_box_ranges_'+hex_table_date+'_sav.dat'
		restore,filename=sit_rate_box_ranges_path + 'sit_rate_box_ranges_'+hex_table_date+'_sav.dat'
	ENDIF
; 	calculate the delta_e values:
	for iunit=0,1 do begin
	for irate=0,6 do delta_e(iunit,irate) = 1.
	for irate=7,115 do begin
		delta_e(iunit,irate) =  matrix_rates[irate].emax[iunit] - matrix_rates[irate].emin[iunit]
		if( delta_e(iunit,irate) eq 0) then delta_e(iunit,irate) = -1.  ; since we later divide by delta_e, don't allow zero values
	endfor  ; iunit loop
	endfor  ; box number loop
	
	sit_efficiencies         ; read in the efficiencies

;	read in the background data if not yet done
	if(n_elements(bkgd_flux) eq 0.) then begin 
		bkgd_flux = fltarr(116,2)
		spillover_fraction = fltarr(116,2)
		spillover_box = intarr(116,2)
		box_width_adjust = fltarr(116,2)
		read_background_correction
		print,'Background correction files read in'
	ENDIF



	end
