PRO  PROCESS_PHA, packet, apid, run_checks, flag_pha_plots, pha_plot_out, histogram_num, proc_flag

;
;	procedure to list SIT pha
;
;	gm	25-Aug-2006;  15-Mar-2007 move file opening to open_outputs.pro;  20 Mar-2007 remove time checks
;
;	Modification history:
;		22-Mar-2011	move pha_writes counter to actual write statements; change write limit to 999,900 /gm

common lun_numbers
common output_items
common spacecraft
common time_bounds
common box_check
common misc_counters
common paths
common pha_rate_averages
common rate_averages

	if(proc_flag eq 4) then goto, writeout

;	process next packet


	SIT_PHA, PACKET, SITPHADATA, num_pha, apid    ; pack the data into the structure sitphadata

;	********* note:  if no pha events, then sitphadata is not defined so just return ***********
;	********* unless apid is 606 -- then process anyway so as to add in the live time *********

	IF n_elements(sitphadata) ne 0 THEN BEGIN	

;	*******************************	

;	check the matrix boxes
	if run_checks then calc_box, spacecraft_id, sitphadata

;	***************** if pha_rates or pha_spectra being calculated *******************
;	***************** calculate bins for pha_rates and pha_spectra ******************

	if(  (pha_rates_out gt 0) or (multi_panel_out gt 0)  or pha_spectra_out ) then begin

		bin_now_pha_rates = sitphadata.header.timeCDS.time/(avg_int_pha_rates*60.*1000)
		bin_now_pha_rates=floor(bin_now_pha_rates)

;		IF this is a first call after clearing accumulators, just add in the data
		if( bin_last_pha_rates eq -1 ) then pha_case = 1
	
;		if we're in same time bin as before, just add in the data 
		IF( (bin_now_pha_rates eq bin_last_pha_rates) and (bin_last_pha_rates ge 0) ) then pha_case = 2
	
;		if we're crossed into a new bin and this is apid 606, then write out the pha rates, clear, and start a new sum
		IF( ((bin_now_pha_rates ne bin_last_pha_rates) and (bin_last_pha_rates ge 0)) and (apid eq 606) ) then pha_case = 3

;		if averaging interval is 1 min, add in the rates and write them out
		if( avg_int_pha_rates eq 1 ) then pha_case = 4

;		if we get here and pha_case is not defined, return since something out of sequence, as in a data gap where apid can
;		move backwards (e.g. sit-b 8/1/2010)
		if( n_elements(pha_case) eq 0 ) then return

	case pha_case of
	
	1:	add_pha_rates, sitphadata, apid
	2:	add_pha_rates, sitphadata, apid
	3:	begin
			if( pha_spectra_out ) then WRITE_PHA_SPECTRA,  sitphadata, apid, proc_flag
			if( ( pha_rates_out gt 0) or (multi_panel_out gt 0)  ) then begin
;				print, ' process_pha:  write_pha_rates called from line 69 -- bin crossing'
				WRITE_PHA_rates,  sitratedata_last, proc_flag
			endif
			clear_pha_rates
			add_pha_rates, sitphadata, apid
		end
	4:	begin
			add_pha_rates, sitphadata, apid
			if( pha_spectra_out ) then WRITE_PHA_SPECTRA,  sitphadata, apid, proc_flag
			if( ( pha_rates_out gt 0) or (multi_panel_out gt 0) ) then WRITE_PHA_rates,  sitratedata_last, proc_flag
			clear_pha_rates	
			clear_rates   ;  clear rates accumulators also 
		end	
	endcase

	endif    ; end of pha_case section if doing pha_rates or pha_spectra

;	*******************************

	if( histogram_out ) then add_hist_pha, sitphadata, histogram_num


writeout: 	if(pha_plot_out ne 0) then PLOT_PHA, sitphadata, flag_pha_plots, pha_plot_out, proc_flag

	if( ((pha_out) and (pha_writes lt 999900.d0)) or (multi_panel_out gt 0))  then WRITE_PHA,  sitphadata, apid, proc_flag   ; write out the pha data
;		clear_PHA  - not implemented

	if( proc_flag eq 4 ) then begin	
		if( pha_spectra_out ) then WRITE_PHA_SPECTRA,  sitphadata, apid, proc_flag
		if( ( pha_rates_out gt 0) or (multi_panel_out gt 0) ) then begin
;			print, ' calling write pha rates from line 97 process_pha'
			WRITE_PHA_rates,  sitratedata_last, proc_flag
		endif
		clear_pha_rates
		clear_rates   ;  clear rates accumulators also 
	endif
	
	return

	ENDIF  ; for n_elements ne 0 loop	
	
	end
