PRO PLOT_PHA, sitphadata, flag_pha_plots, pha_plot_out, proc_flag
;
;	plots PHA data
;
;	flag_pha_plots = 0 at start
;	
;	pha_plot_out = 0 -- this routine will not be called
;				1:  produce ln t vs ln e plot
;				2:  produce mass vs ln einc plot
;	modification history:
;		7-Feb-08	change output header format to include function mjd2modayrhrmn() /gm

common calibration
common spacecraft
common pha_plots
common time_bounds

	if(flag_pha_plots eq 0) then begin
	flag_pha_plots = 1
	
	
;	establish a coordinate system for plot
	plot,intarr(2),xrange=[0.1,200],yrange=[1,200],xstyle=1,ystyle=1,/xlog,/ylog,xtitle='MeV', $
	     ytitle='ns'
	     
;	set up a title string

	i = interval_number-1
	i2=number_times-1
	
		t_start = 	date2mjd(time_data.(0)(0,i),time_data.(0)(1,i),time_data.(0)(2,i)) + $
			    					double(time_data.(0)(3,i)/24.) + double(time_data.(0)(4,i)/(24.*60.))					
		t_stop = date2mjd(time_data.(0)(5,i),time_data.(0)(6,i),time_data.(0)(7,i)) + $
			    double(time_data.(0)(8,i)/24.) + double(time_data.(0)(9,i)/(24.*60.))

	title_string = string( spacecraft_name(spacecraft_id), mjd2modayrhrmn(t_start), mjd2modayrhrmn(t_stop), $
		 format='("SIT-",a6,5x,i2,"/",i02,"/",i4,2x,i02,":",i02," to ", i2,"/",i02,"/",i4,2x,i02,":",i02)' )

	
;	title_string = string( spacecraft_name(spacecraft_id), time_data.(0)(1,i),time_data.(0)(2,i),time_data.(0)(0,i),time_data.(0)(3,i),time_data.(0)(4,i), $
;		 time_data.(0)(6,i2),time_data.(0)(7,i2),time_data.(0)(5,i2),time_data.(0)(8,i2),time_data.(0)(9,i2),  $
;		 format='("SIT-",a6,5x,i2,"/",i02,"/",i4,2x,i02,":",i02," to ", i2,"/",i02,"/",i4,2x,i02,":",i02)' )
	
;	pick array size in x and y:
	xbounds = !x.window*!d.x_vsize
	ybounds = !y.window*!d.y_vsize
	xscale = xbounds(1)-xbounds(0)
	yscale = ybounds(1)-ybounds(0)	
	image=ulonarr(xscale+2,yscale+2)
;	print,xscale,yscale,xbounds,ybounds
	
;	test section to put in a grid for alignment test
	
	if(pha_plot_out eq -1) THEN BEGIN
	
	estart=0.01
	for i = 1, 5 do begin
		elog = fix(    (alog10( estart ) + 2.0)*xscale/(alog10(200)+2)    )
		image(elog,*) = 100
		estart=estart*10
	ENDFOR

	tstart = 10
	for i=1,2 do begin
		tlog = fix(  alog10( tstart ) *yscale/alog10(200))
		image(*,tlog) = 100
		tstart = tstart * 10
	ENDFOR
	
	ENDIF
	
	if(pha_plot_out eq -2) THEN BEGIN
	
		estart=0.1
	for i = 1, 3 do begin
		elog = fix(    (alog10( estart ) + 2.0)*xscale/(alog10(20)+2)    )
		image(elog,*) = 100
		estart=estart*10
	ENDFOR

	tstart = 1
	for i=1,2 do begin
		tlog = fix( ( alog10( tstart ) + 1.)*yscale/(alog10(100)+1.))
		image(*,tlog) = 100
		tstart = tstart * 10
	ENDFOR
	
	ENDIF


	ENDIF   ; end of setup
	
;	if proc_flag = 4, just jump to writing out the image
	if(proc_flag eq 4 ) then goto, writeout
	
;	print, ' call to write_pha with sitphadata.num_pha = ', sitphadata.num_pha
	ntop = sitphadata.num_pha-1
	if(ntop gt 63) then ntop = 63

	   for i = 0, ntop do begin 
	   	randmx = randomu(s)
	   	randmy = randomu(s)
;	add a small amount to the quantites in the alog10() to prevent error message when the quantity is zero.
		epsilon = 1e-6

		if( pha_plot_out eq 1) THEN BEGIN
		
			elog = fix(    (alog10( energy_array(sitphadata.energy_ch(i),sitphadata.gain(i),spacecraft_id) + epsilon ) + 2.0)*xscale/(alog10(200)+2)    )
			if(sitphadata.energy_ch(i) lt 2047 ) then begin
				elog1 = fix(    (alog10( energy_array(sitphadata.energy_ch(i)+1,sitphadata.gain(i),spacecraft_id) + epsilon ) + 2.0)*xscale/(alog10(200)+2)    )
				elog = elog*(1-randmx) + randmx*elog1
			endif

			
			tlog = fix(   (  alog10(    tof_array(sitphadata.tof_ch(i),spacecraft_id) + epsilon          )*yscale/alog10(200) ) )
		if( sitphadata.tof_ch(i) lt 511) then begin
			tlog1 = fix(   (  alog10(    tof_array(sitphadata.tof_ch(i)+1,spacecraft_id) + epsilon          )*yscale/alog10(200) ) )
			tlog = tlog*(1-randmy) + randmy*tlog1
		endif
	
		ENDIF ELSE BEGIN
		
			elog = fix(    (alog10( einc_ssd_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id) + epsilon ) + 2.0)*xscale/(alog10(20)+2)    )
			if ((sitphadata.energy_ch(i) lt 2047 ) and (sitphadata.tof_ch(i) lt 511) )then begin
				elog1 = fix(    (alog10( einc_ssd_array(sitphadata.energy_ch(i)+1,sitphadata.gain(i),sitphadata.tof_ch(i)+1,spacecraft_id) + epsilon ) + 2.0)*xscale/(alog10(20)+2)    )
				elog = elog*(1-randmx) + randmx*elog1
			endif

			
			tlog = fix(   (  alog10(    amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id) + epsilon ) +1.      )*yscale/(alog10(100)+1.) ) 
		if ((sitphadata.energy_ch(i) lt 2047 ) and (sitphadata.tof_ch(i) lt 511) ) then begin
			tlog1 = fix(   (  alog10(    amass_array(sitphadata.energy_ch(i)+1,sitphadata.gain(i),sitphadata.tof_ch(i)+1,spacecraft_id) + epsilon  ) +1.     )*yscale/(alog10(100)+1.) ) 
			tlog = tlog*(1-randmy) + randmy*tlog1
		endif
		
		ENDELSE
			
		
	
	
		if((elog ge 0) and (elog lt xscale+2) and (tlog ge 0) and (tlog lt yscale+2) ) then $
				image(elog,tlog) = image(elog,tlog)+1
	   		
;		if sitphadata.energy_ch(i) le 511 then image(sitphadata.energy_ch(i),sitphadata.tof_ch(i)) = $
;				image(sitphadata.energy_ch(i),sitphadata.tof_ch(i)) + 1

;			 array = [ amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;			 einc_ssd_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;			 einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;			 tof_array(sitphadata.tof_ch(i),spacecraft_id), $
;			 energy_array(sitphadata.energy_ch(i),sitphadata.gain(i),spacecraft_id), $
;			 sitphadata.tof_ch(i), $
;			 sitphadata.energy_ch(i), $
;			 sitphadata.gain(i), $
;			 sitphadata.priority(i), $
;			 sitphadata.tof_flg_1(i), $
;			 sitphadata.tof_flg_2(i), $
;			 sitphadata.tof_err_proc(i), $
;			 sitphadata.matrix_box(i), $
;			 apid, calc_matrix_box(i), calc_pri(i), calc_bea_box(i), m_box_err(i), p_box_err(i) ]



	ENDFOR
	
	pha_total=ulong(pha_total)+ulong(ntop)
	if pha_total gt 100000UL then begin
	
	
writeout:		pha_plot_sum = ulong(pha_plot_sum) + ulong(pha_total)
			erase
		
;		amax = max(image)
;		image=image*256/amax
		
		tv,image, xbounds(0),ybounds(0)

		if( pha_plot_out eq 1) then plot,intarr(2),xrange=[0.01,200],yrange=[1,200],xstyle=1,ystyle=1,/xlog,/ylog,/noerase,xtitle='MeV', $
	  		   ytitle='ns', TITLE=title_string, ticklen = 1, xgridstyle=1, ygridstyle=1

		if( pha_plot_out eq 2) then plot,intarr(2),xrange=[0.01,20],yrange=[0.1,100],xstyle=1,ystyle=1,/xlog,/ylog,/noerase,xtitle='MeV/nuc', $
	  		   ytitle='Mass (AMU)', TITLE=title_string, ticklen = 1, xgridstyle=1, ygridstyle=1
	     	
;		print, ' number of pha events plotted: ', pha_plot_sum, ' max cell value: ',amax
		print, ' number of pha events plotted: ', pha_plot_sum


;		for i=0, xscale do for j=0, yscale do begin
;			if(image(i,j) ge amax ) then print, image(i,j), i, j
;		endfor
		
		pha_total=0ul
	endif
	
end
