PRO  multi_panel_outputs, current_mjd
;
;	procedure to open SIT lister multi-panel plot files
;
;	gm	16-Apr-2007;  adapted from open_outputs
;
;

common lun_numbers
common output_items
common spacecraft
common time_bounds
common rate_information
common multi_panel_plot_items



; **************** first call:  set up start/stop times and open files ****************
	if( flag_multi_panel eq 0 ) then begin
		flag_multi_panel = 1
		multi_panel_start_mjd = floor(start_MJD)
		multi_panel_stop_mjd = multi_panel_start_mjd + multi_panel_out
;		save output file name for final message call from sit_lister
		out_file = make_multi_panel_filename('xxx')
		goto, openfiles
	ENDIF

	
; ***************** subsequent calls, check to see if we are at end of interval, if not, return **********
	if( current_mjd lt multi_panel_stop_mjd ) then return
	
; ***** at end of interval, so close files, calculate new start/stop dates, and open new files
	free_lun,  lun_multi_rate, lun_multi_mass, lun_multi_smoosh
		multi_panel_start_mjd = multi_panel_start_mjd  + multi_panel_out
		multi_panel_stop_mjd = multi_panel_stop_mjd + multi_panel_out
		print, ' current start, stop: ', multi_panel_start_mjd , multi_panel_stop_mjd 


; ************************** RATES *************************
;	get system time for headers
openfiles:	current_time=systime()

	openw, lun_multi_rate, make_multi_panel_filename('multi_panel_rates'), /get_lun
		print, ' opening multi-panel rates output file, unit = ', lun_multi_rate
;	write the output header:
		printf, lun_multi_rate,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," count rates for multi panel plots --- run time: ",a0)'
		printf, lun_multi_rate,  7, multi_panel_out, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days")
		printf, lun_multi_rate,' ',format='(a1)'
		print_multi_panel_intervals, lun_multi_rate, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_rate,format='($," Time,year,day of year,delta t/2,")'
		for i=0, 3 do printf, lun_multi_rate, matrix_rates[multi_panel_rates(i)].mat_names(spacecraft_id), (matrix_rates[multi_panel_rates(i)].emin(spacecraft_id) + matrix_rates[multi_panel_rates(i)].emax(spacecraft_id))/2., $
			format='($,(a,f7.3," MeV/n,"))'
;		printf, lun_multi_rate,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X,GSE-Y,GSE-Z,Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'
;		write out a character to force a line feed
		printf, lun_multi_rate,' ',format='(a1)'



; ************************* PHA_MASS ***********************

	
		openw, lun_multi_mass, make_multi_panel_filename('multi_panel_pha'), /get_lun
		print, ' opening multi-panel pha output file, unit = ', lun_multi_mass
;	write the output header:
		printf, lun_multi_mass,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," pha data for multi panel plots --- run time: ",a0)'
		printf, lun_multi_mass,  9, multi_panel_out, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days")
		printf, lun_multi_mass,' ',format='(a1)'
		printf, lun_multi_mass,  2., 70., 0.4, 0.9, $
		       format='(" PHA limits:  mass between ",f6.2," and ",f6.2," AMU, energy between ",f7.3," and ",f7.3," MeV/nucleon",/)'
		print_multi_panel_intervals, lun_multi_mass, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_mass,format='($," Time,year,day of year,delta t/2,Mass (AMU),")'
;		printf, lun_multi_mass,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X,GSE-Y,GSE-Z,Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'			
		printf, lun_multi_mass,' ',format='(a1)'


; ************************* PHA_SMOOSH ***********************

	
		openw, lun_multi_smoosh, make_multi_panel_filename('multi_panel_smoosh'), /get_lun
		print, ' opening multi-panel smoosh output file, unit = ', lun_multi_smoosh
;	write the output header:
		printf, lun_multi_smoosh,spacecraft_name(spacecraft_id), current_time, format='(" STEREO",1x,a0," pha data for multi panel smoosh plots --- run time: ",a0)'
		printf, lun_multi_smoosh,  9, multi_panel_out, format='(" Number of header lines:",i4, 6x,"Plot length is ",i3," days")
		printf, lun_multi_smoosh,' ',format='(a1)'
		printf, lun_multi_smoosh,   10., 70., $
		       format='(" PHA limits:  mass between ",f6.2," and ",f6.2," AMU",/)'
		print_multi_panel_intervals, lun_multi_smoosh, multi_panel_start_mjd, multi_panel_stop_mjd
		printf, lun_multi_smoosh,format='($," Time,year,day of year,delta t/2,Mass (AMU),Einc tof (MeV/nuc),")'
;		printf, lun_multi_smoosh,format='($,"time rotated to Earth-Sun line,year rotated to Earth-Sun line,day rotated to Earth-Sun line,GSE-X,GSE-Y,GSE-Z,Earth - Sun - STEREO-A (deg),Earth - Sun - STEREO-B (deg),STEREO-B - Sun - STEREO-A (deg),")'			
		printf, lun_multi_smoosh,' ',format='(a1)'



end
