PRO SIT_sav_generator
;+
; Project     :	STEREO - IMPACT, SIT
;
; Name        : SIT_LISTER
;
; Purpose     :	Program to read SIT packets sequentially and print output fi les
;
; Category    :	STEREO, IMPACT, SIT
;
; Explanation :	reads a STEREO telemetry data file and extracts data from SIT packets.
;

; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech
;			Modified from program sit_rates.pro by Andrew Davis / gm
;	Modification history:
;		29-Oct-2010	adapted from sit_lister /gm
;


; ****************************************************************

	@sit_common.inc
	@sep_beacon_common.inc
	read_paths

	mjd_start = 55197   ; 1/1/2010
	mjd_start = 55341   ;  2010 day 145 (missing data)  
	mjd_end = 55439   ; day 243
	
	mjd_start = 55409  ; 2010/213
	mjd_end = 55415    ; 2010/218
	spacecraft = 'behind'
	spacecraft_id = 1
	
;	restore the calibration files:
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/Energy_tof/amass_sav.dat'
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/Energy_tof/einc_ssd_sav.dat'
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/Energy_tof/einc_tof_sav.dat'
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/Energy_tof/energy_sav.dat'
	restore,'/data/joey/masongm1/Data/Instrument_cal_files/sit_cal/Energy_tof/tof_sav.dat'
	print, 'calibration files read in'	
	
	inpath = '/data/joey/masongm1/Data/Data_L1_flight/STEREO/SIT_'
	for i_date = mjd_start, mjd_end do begin
;	find the date
	MJD2DATE, i_date, year, month, day
	doy = i_date-date2mjd(year,1,1)+1

	FOR i_vers=10,0,-1 DO BEGIN                   ; check up to 10 version numbers before quitting:  work from highest version number down
;	input_file = '/data/joey/masongm1/Data/Data_L1_flight/STEREO/SIT_behind/sit_behind_2010_212_1_04.fin'  ; file name 	
	infilename = inpath + spacecraft + '/sit_'+spacecraft + '_' + $
	                                          string(year,doy,i_vers, format='(i4,"_",i3.3,"_1_",i2.2)' ) + '.fin'                 
;	printf, lun_print, 'opening file = ', infilename
	openr, lun_input, infilename, /get_lun, ERROR = err	
;	printf, lun_print, ' error: ', err
		if(err eq 0) then break   ; leave "i" loop if file successfully opened
	ENDFOR  ; loop i


	spacecraft_id = 1
	flag_open_sit_file = 1


	count_reads=0L	
	count_hk = -1L
	count_rate = -1L
	count_pha = -1L
	count_beacon = -1L
	packet_index = intarr(30000)   ; index for packets
	packet_count = -1L
	
	packet = 0


newrec: 	
	while ( ~eof(lun_input) ) do begin
		read_stereo_pkt, lun_input, packet   ; *********************** reading loop
	if (n_elements(packet) eq 0) then break
	
;
;	compute current time
;
	current_time = tai2utc(double(packet.pkt.seconds), /NOCORRECT)
	current_mjd = double(current_time.mjd) + double(current_time.time)/(86400.d0*1000.d0)
	
;	process this packet

	apid = parse_stereo_pkt(packet, /APID )
	proc_flag = 1   ; running value
	branch = apid
	if( (apid ge 606) and (apid le 616) ) then branch = 606

	case branch of

	577:	begin	
			sit_hk, packet, sithkdata
			if( n_elements(sithkdata) ne 0 ) then begin
				count_hk ++
				if( count_hk eq 0 ) then data_hk = replicate( sithkdata, 2000)	; set up daily structure on first read
				data_hk(count_hk) = sithkdata
				packet_count ++
				packet_index[packet_count] = apid
			endif
		end
			
	605: begin 
			sit_rates, packet, sitratedata
			if( n_elements(sitratedata) ne 0 ) then begin
				count_rate ++
				if( count_rate eq 0 ) then data_rate = replicate( sitratedata, 2000)	; set up daily structure on first read
				data_rate(count_rate) = sitratedata
				packet_count ++
				packet_index[packet_count] = apid
			endif
		end

	606:	begin
			SIT_PHA, PACKET, SITPHADATA, num_pha
			if( (n_elements(sitphadata) ne 0) and (num_pha gt 0)  ) then begin
				count_pha ++
				if( count_pha eq 0 ) then begin
					data_pha = replicate( sitphadata, 11*2000)	; set up daily structure on first read
						amass = fltarr(64)
						einc_tof = fltarr(64)
						einc_ssd = fltarr(64)
						tof_ns = fltarr(64)
						energy_MeV = fltarr(64)
					data_pha_float = { amass:fltarr(64), einc_tof:fltarr(64), einc_ssd:fltarr(64), tof_ns:fltarr(64), energy_MeV:fltarr(64) }
					data_pha_float_array = replicate( data_pha_float, 11*2000)
				endif
				data_pha(count_pha) = sitphadata
				for i = 0, sitphadata.num_pha -1 do begin
					data_pha_float.amass(i) = amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
					data_pha_float.einc_tof(i) = einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
					data_pha_float.einc_ssd(i) = einc_ssd_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
					data_pha_float.tof_ns(i) = tof_array(sitphadata.tof_ch(i),spacecraft_id)
					data_pha_float.energy_MeV(i) = energy_array(sitphadata.energy_ch(i), sitphadata.gain(i), spacecraft_id )
				endfor
				data_pha_float_array(count_pha) = data_pha_float
				packet_count ++
				packet_index[packet_count] = apid
			endif
		end
		
	624: begin
			sep_beacon, packet, sepbeacondata
			if( n_elements(sepbeacondata) eq 0 ) then stop
			if( n_elements(sepbeacondata) ne 0 ) then begin
				count_beacon ++
				if( count_beacon eq 0 ) then data_beacon = replicate( sepbeacondata, 2000)	; set up daily structure on first read
				data_beacon(count_beacon) = sepbeacondata
				packet_count ++
				packet_index[packet_count] = apid
			endif
		end

	else:	if(apid ne 576) then printf, lun_print, ' illegal APID: ', apid    ; APID 576 is command response; not processed; other values not expected
	
	endcase
	
	if((apid ge 577) and (apid le 616) ) then count_reads=count_reads+1
;	if(count_reads gt 100) then break


	ENDWHILE   ; loop for reading packets from one file ***********

;	finish up	
		
finish:		
;	trim the arrays -- include trap for missing days (will have count values still = -1)
		if( packet_count ge 0 ) then packet_index = packet_index[0:packet_count] else packet_index = fltarr(1)
		if( count_hk ge 0 ) then data_hk = data_hk[0:count_hk] else data_hk = fltarr(1)
		if( count_rate ge 0 ) then data_rate = data_rate[0:count_rate] else data_rate = fltarr(1)
		if( count_pha ge 0 ) then data_pha = data_pha[0:count_pha] else data_pha = fltarr(1)
		if( count_pha ge 0 ) then data_pha_float_array = data_pha_float_array[0:count_pha] else data_pha_float_array = fltarr(1)
		if( count_beacon ge 0 ) then data_beacon = data_beacon[0:count_beacon] else data_beacon = fltarr(1)
		
		file = string(doy, i_vers, format="('/data/joey/masongm1/Data/Data_L1_flight/STEREO/SIT_behind_sav/sit_behind_2010_',i3.3,'_1_',i2.2,'.sav')")
		print, 'save file opened: ', file
		save, packet_index, data_hk, data_rate, data_pha, data_pha_float_array, data_beacon, filename = file
;		save, packet_index, data_hk, data_rate, data_pha, data_pha_float_array, data_beacon, filename = 'sit_behind_save_2010_212.sav',/compress
	close,/all
	
	ENDFOR   ; main loop for each day (variable i_date)

end 
