PRO WRITE_PHA_SPECTRA_sav,  sitphadata, data_pha_float, apid, proc_flag

;
;	writes out SIT spectra		16-Mar-2007 /gm;   22 Mar-2007 add ratios;  28-Mar-2008 modify for PHA inensities
;							6-Nov-2008	fix spectral sigma calculation /gm
;
 common rate_averages
 common last_write_times
 common spacecraft
 common rate_information		
 common mbox_factors
 common intensity_ratios
 common calibration
 common pha_rate_averages
 common output_items
 common background_correction
common lun_numbers
common event_counter

	if(proc_flag eq 4) then goto, writeout
	
; ****************************** add in this packet's pha data into the intensity totals *****************************
; add in PHA live time (1 min) only for APID 606
	if ( apid eq 606 )then begin
		num_avg_ints_pha_rates = num_avg_ints_pha_rates + 1
		utc_average_pha_rates.mjd = double(utc_average_pha_rates.mjd) + double(sitphadata.header.timeCDS.mjd)
		utc_average_pha_rates.time = double(utc_average_pha_rates.time) + double(sitphadata.header.timeCDS.time)
	ENDIF

	ntop = sitphadata.num_pha-1
	if(ntop gt 63) then ntop = 63
	   for i = 0, ntop do begin 
	   
;	   		amass = amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
;	   		einc = einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)

			amass = data_pha_float.amass(i)
			einc = data_pha_float.einc_tof(i)

	   		
	   	; find box number
	   		box = -1
	   		for j=7,115 do begin
	   		box=j
;	   		if( (einc ge matrix_rates[j].emin(spacecraft_id)) and (einc lt matrix_rates[j].emax(spacecraft_id)) and $
;	   			(amass ge matrix_rates[j].mass_min(spacecraft_id)) and (amass lt matrix_rates[j].mass_max(spacecraft_id)) ) then break
; ************ splitting up this if statement so tests can end at any stage cuts time for 1/30/07 processing from 48 to 25 sec ****************	   			
	   		if(einc ge matrix_rates[j].emin(spacecraft_id)) then $
	   			if (einc lt matrix_rates[j].emax(spacecraft_id)) then  $
		   			if(amass ge matrix_rates[j].mass_min(spacecraft_id)) then $
		   				if (amass lt matrix_rates[j].mass_max(spacecraft_id)) then $
		   					if(swoosh_test(einc)) then break
	   			
	   		ENDFOR
	   		
	   	; add in the count to the mbox and priority counter
	   		if( box ge 0) then begin 
	   			mpha_rate_counts(box,sitphadata.priority(i)) =   double(mpha_rate_counts(box,sitphadata.priority(i))) + 1
		   		mpha_priority_counts(sitphadata.priority(i)) =double(mpha_priority_counts(sitphadata.priority(i))) + 1
			ENDIF

;			if(box eq 71) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass,sitphadata.energy_ch(i),sitphadata.tof_ch(i),sitphadata.matrix_box(i), format='(10i6)'

;			if(box eq 20) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass
;			if(sitphadata.matrix_box(i) eq 20) then print, i, box, mpha_rate_counts(box,sitphadata.priority(0)), einc, amass
;			j=box
;			if(sitphadata.matrix_box(i) eq 20) then print, matrix_rates[j].emin(spacecraft_id), matrix_rates[j].emax(spacecraft_id)
;	   		if(sitphadata.matrix_box(i) eq 20) then print, matrix_rates[j].mass_min(spacecraft_id), matrix_rates[j].mass_max(spacecraft_id)
	
	ENDFOR
	
	
	return



;****************************write out pha spectra***********************
;			if there were no pha_averaging intervals then return
writeout:	if( num_avg_ints_pha_rates eq 0 ) then return
		mpha_rate_average = double(mpha_rate_counts)
		if(type_out eq 0) then mpha_rate_average = mpha_rate_average/(num_avg_ints_pha_rates*60.)
		utc_average_pha_rates.mjd = double(utc_average_pha_rates.mjd)/double(num_avg_ints_pha_rates)
		utc_average_pha_rates.time = double(utc_average_pha_rates.time)/double(num_avg_ints_pha_rates)

	; **** now add together the 2 priority states, weighted by total # of that priority and the matrix_rate counts ****
		mpha_rate_out = fltarr(116)
		mpha_rate_sigma_out = fltarr(116)
		mparts = fltarr(2)
		for i = 7, 115 do begin



;										*** use double precision to prevent intermediate products overflowing ****		
			if( mpha_priority_counts(0) gt 0) then mparts(0) = double(mpha_rate_average(i,0))*mpha_priority_rate_counts(0)/mpha_priority_counts(0) else mparts(0) = 0.
			if( mpha_priority_counts(1) gt 0) then mparts(1) = double(mpha_rate_average(i,1))*mpha_priority_rate_counts(1)/mpha_priority_counts(1) else mparts(1) = 0.


;		if output is intensity or fluence fold in efficiency, etc.; otherwise just pass along counts
;		calculate sigmas  -- attribute all the statistical error to the counting statistics in the boxes
			if(type_out le 1) then begin
				low_pri_part = mparts(0)/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
				high_pri_part = mparts(1)/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
				if( mpha_rate_counts(i,0) gt 0 ) then low_pri_sigma = low_pri_part/sqrt(mpha_rate_counts(i,0)) else low_pri_sigma = 0.
				if( mpha_rate_counts(i,1) gt 0 ) then high_pri_sigma = high_pri_part/sqrt(mpha_rate_counts(i,1)) else high_pri_sigma = 0.				
				mpha_rate_out(i) = low_pri_part + high_pri_part				
				mpha_rate_sigma_out(i) = sqrt(low_pri_sigma^2 + high_pri_sigma^2)

			endif else begin
				mpha_rate_out(i)=double(mpha_rate_counts(i,0))+double(mpha_rate_counts(i,1))   
				mpha_rate_sigma_out(i) = sqrt(mpha_rate_out(i))
			endelse	
			
;		if((i ge 62) and (i le 78) ) then print, i, mpha_rate_counts(i,*), mparts, low_pri_part, high_pri_part, (effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor), mpha_rate_out(i), mpha_rate_sigma_out(i), format='(3i6, 8f15.8)'
			
;			if((i ge 94) and (i le 102) ) then print, "i, mpha_rate_out(i), mparts(1), mpha_rate_counts(i,1), mpha_priority_rate_counts(1), mpha_priority_counts(1), factor:" , $
;				i, mpha_rate_out(i), mparts(1), mpha_rate_counts(i,1), mpha_priority_rate_counts(1), mpha_priority_counts(1), (effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
				
;			if((i ge 30) and (i le 35) ) then print, "i, mpha_rate_out(i), mparts(0), mpha_rate_counts(i,0), mpha_priority_rate_counts(0), mpha_priority_counts(0), factor:" , $
;				i, mpha_rate_out(i), mparts(0), mpha_rate_counts(i,0), mpha_priority_rate_counts(0), mpha_priority_counts(0), (effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
			
		endfor
	
;
;	correct for background
;
	if( (bkgd_correction_on) and (type_out le 1) )  then correct_mpha_rate_background

;	put the header stuff into a string
	header_string=''
	header_string = header_string + string( event_number_pha_spectra, utc2str(utc_average_pha_rates,/ecs,/truncate), $
		mjd2decyr(utc_average_pha_rates), mjd2decdoy(utc_average_pha_rates),  format ='(1x, i6, ",", a23,"," 2(f16.6,","))'   )
;	print,header_string

	for i=7,115 do begin
;	for i = 36, 36 do begin   <-- test line to produce only 0.5 MeV/n He points  9/30/08 /gm
	
;	if the 1-sigma fractional error is > error_limit, zero out the bin  (will not be printed)    8-Feb-08   /gm
			if( mpha_rate_sigma_out(i) gt 0. ) then $
				if( (mpha_rate_sigma_out(i)/mpha_rate_out(i)) gt error_limit ) then begin
					mpha_rate_out(i) = 0.
					mpha_rate_sigma_out(i) = 0.
			endif

		
		if(  ((mpha_rate_counts(i,0) + mpha_rate_counts(i,1)) ge 2) and (effic(spacecraft_id,i) gt 0) and (delta_e(spacecraft_id,i) gt 0) $
			and (mpha_rate_out[i] gt 0.) ) then begin   ; don't write pha_rates with zero flux or < 2 counts	

;		check that there are counts for the ratios calculation, or else set a flag
		ratio_out = 0   ; don't do ratios line
		if( (mpha_rate_counts(i,0) + mpha_rate_counts(i,1)) ge 2 )  then   $
			if( (mpha_rate_counts(ratio_indices(i),0) + mpha_rate_counts(ratio_indices(i),1)) ge 2) then $
				if (mpha_rate_out(i) gt 0. ) then ratio_out = 1  ; (true)

		
;	first part of the string is the energy ranges, taken from the matrix rate box table
		print_string=''
		print_string = print_string + string( matrix_rates[i].emin[spacecraft_id],matrix_rates[i].emax[spacecraft_id],(matrix_rates[i].emin[spacecraft_id]+matrix_rates[i].emax[spacecraft_id])/2., $
				(matrix_rates[i].emax[spacecraft_id]-matrix_rates[i].emin[spacecraft_id])/2., format ='(4(f10.5,","))' )
		if((i ge 7) and (i le 18)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(2(e15.5,","))' )
		if((i ge 19) and (i le 28)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='((",,"),2(e15.5,","))' )
		if((i ge 29) and (i le 44)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(2(",,"),2(e15.5,","))' )
		if((i ge 45) and (i le 61)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(3(",,"),2(e15.5,","))' )
		if((i ge 62) and (i le 77)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(4(",,"),2(e15.5,","))' )
		if((i ge 78) and (i le 93)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(5(",,"),2(e15.5,","))' )
		if((i ge 94) and (i le 107)) then print_string = print_string + string(mpha_rate_out[i], mpha_rate_sigma_out[i], format ='(6(",,"),2(e15.5,","))' )

;		now calculate the ratios (H/He, 3He/4He, He/O,C/O, NeS/O, and Fe/O and add them to the print strings

		
			if((i ge 7) and (i le 18) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 19) and (i le 28) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 29) and (i le 44) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 46) and (i le 61) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(7(",,"),2(e15.5,","))' )
			if((i ge 78) and (i le 93) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(6(",,"),2(e15.5,","))' )
			if((i ge 95) and (i le 107) and ratio_out ) then print_string = print_string + string(mpha_rate_ratio(i), mpha_rate_ratio_sigma(i), format ='(6(",,")2(e15.5,","))' )
	
		printf,  lun_pha_spectralist, header_string + print_string	
		ENDIF

	ENDFOR

;	zero out the sums for next spectral period
	mpha_rate_average=fltarr(116,2)              ; each pha average has 2 priority bins
	mpha_rate_counts=ulonarr(116,2)
	mpha_rate_sigma=fltarr(116,2)	
	mpha_priority_counts=ulonarr(2)		; number of pha events of each priority	
	mpha_priority_rate_counts=ulonarr(2)	; number of matrix rate counts of each priority
	mpha_rate_out = fltarr(116)			; summed lo + high priority
	mpha_rate_sigma_out = fltarr(116)		;     "
	
	event_number_pha_spectra ++    ; bump event counter
	num_avg_ints_pha_rates = 0L
	utc_average_pha_rates.mjd = 0.d0
	utc_average_pha_rates.time = 0.d0



end
