PRO WRITE_PHA_sav,  sitphadata, apid, proc_flag
;
;	writes out PHA data
;
;	Modification history:  
;		11-Mar-2010	change mass panel energy and mass ranges to improve appearance
;						of plots /gm
;
common calibration
common spacecraft
common box_check
common pha_limits
common stereo_ephem          ; contains ephemeris data returned & misc counters
common lun_numbers
common output_items
common multi_panel_plot_items

	if(proc_flag eq 4) then goto, writeout

;	print, ' call to write_pha with sitphadata.num_pha = ', sitphadata.num_pha
	ntop = sitphadata.num_pha
	if(ntop gt 64) then ntop = 64
	if(ntop eq 0) then return
;	   for i = 0, ntop do begin 

;		calculate and format the ephemeris only once per minute of data (apid = 606, event 0):

;		if((apid eq 606) and (i eq 0) ) then begin
		if((apid eq 606) ) then begin
			current_mjd = double(sitphadata.header.timeCDS.mjd) + double(sitphadata.header.timeCDS.time)/double(86400.*1000)
;			calculate ephemeris data
			stereo_ephemeris, current_mjd
;			build up ephemeris string, which will be added to each pha output line
			ephem_string_pha = string( utc2str(rotated_time(spacecraft_id),/ecs,/truncate), $
				mjd2decyr(rotated_time(spacecraft_id)), mjd2decdoy(rotated_time(spacecraft_id)), gse(0,spacecraft_id), gse(1,spacecraft_id), gse(2,spacecraft_id),  $
				angles, format ='(a23,"," 2(f16.6,","),3(e15.6,","), 3(f8.3,","))'   )			
		ENDIF
	   
;			array dimensions are:  amass_array(2048,2,512,2)
			index_array = sitphadata.energy_ch + 2048L*sitphadata.gain + 4096L*sitphadata.tof_ch + 2097152L*spacecraft_id

;			tof array dimensions are:  tof_array(512,2)
			index_array_tof = sitphadata.tof_ch + 512L*spacecraft_id

;			energy array dimentions are energy_array(2048,2,2)
			index_array_energy = sitphadata.energy_ch + 2048L*sitphadata.gain + 4096L*spacecraft_id

;			get rid of any empty phas
			index_array = index_array[0:ntop-1]
			index_array_tof = index_array_tof[0:ntop-1]
			index_array_energy = index_array_energy[0:ntop-1]

;			make up an array of apid numbers for building up the print array below
			apid_array = apid*(intarr(ntop)+1)

			amass = amass_array[index_array]
			einc = einc_tof_array[index_array]
			einc_tof = einc
			einc_ssd = einc_ssd_array[index_array]
			tof_ns = tof_array[ index_array_tof ]
			energy_MeV = energy_array[ index_array_energy ]
			
;	   		amass = amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
;	   		einc = einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)

; ***** determine which output files will have this event listed *******
			phalist_out = intarr(ntop)
			multi_panel_phalist_out = intarr(ntop)
			multi_panel_smoosh_out = intarr(ntop)
			
			phalist_out = where(	(pha_out) and (amass ge pha_mlo) and (amass le pha_mhi) and (einc ge pha_elo) and (einc le  pha_ehi) and (swoosh_test(einc)) )


;			if(pha_out) then $
;		   		if(amass ge pha_mlo) then $ 
;		   			if(amass le pha_mhi) then $
;	   					if(einc ge pha_elo) then $
;	   						if(einc le  pha_ehi) then $
;	   							if(swoosh_test(einc))then phalist_out = 1
	   							


	   		header_string=''
	   		header_string = header_string + string(utc2str(sitphadata.header.timeCDS,/ecs,/truncate),  $
			 mjd2decyr(sitphadata.header.timeCDS), mjd2decdoy(sitphadata.header.timeCDS), $
			 	 format ='(a23,"," 2(f16.6,","))'  )
			 


;			for i = 0, n_elements(phalist_out) - 1 do begin
;			print,i, phalist_out(i), amass(phalist_out(i))
;			if(phalist_out) then begin
;				 array = [ amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;				 einc_ssd_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;				 einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
;				array = [amass(phalist_out(i)), einc_ssd(phalist_out(i)), einc_tof(phalist_out(i)), $
;				 tof_array(sitphadata.tof_ch(phalist_out(i)),spacecraft_id), $
;				 energy_array(sitphadata.energy_ch(phalist_out(i)),sitphadata.gain(phalist_out(i)),spacecraft_id), $
;				 sitphadata.tof_ch(phalist_out(i)), $
;				 sitphadata.energy_ch(phalist_out(i)), $
;				 sitphadata.gain(phalist_out(i)), $
;				 sitphadata.priority(phalist_out(i)), $
;				 sitphadata.tof_flg_1(phalist_out(i)), $
;				 sitphadata.tof_flg_2(phalist_out(i)), $
;				 sitphadata.tof_err_proc(phalist_out(i)), $
;				 sitphadata.matrix_box(phalist_out(i)), $
;				 apid, calc_matrix_box(phalist_out(i)), calc_pri(phalist_out(i)), calc_bea_box(phalist_out(i)), m_box_err(phalist_out(i)), p_box_err(phalist_out(i)) ]	
				print_array = [amass(phalist_out), einc_ssd(phalist_out), einc_tof(phalist_out), $
				 tof_ns(phalist_out), $
				 energy_MeV(phalist_out), $
				 sitphadata.tof_ch(phalist_out), $
				 sitphadata.energy_ch(phalist_out), $
				 sitphadata.gain(phalist_out), $
				 sitphadata.priority(phalist_out), $
				 sitphadata.tof_flg_1(phalist_out), $
				 sitphadata.tof_flg_2(phalist_out), $
 				 sitphadata.tof_err_proc(phalist_out), $
				 sitphadata.matrix_box(phalist_out), $
				 apid_array(phalist_out), calc_matrix_box(phalist_out), calc_pri(phalist_out), calc_bea_box(phalist_out), m_box_err(phalist_out), p_box_err(phalist_out) ]	

				print_index = n_elements(phalist_out)*indgen(19) -1 ;  19 elements in print line
				for print_line = 0, n_elements(phalist_out)-1  do begin
					print_index ++
;					if(print_line eq 0 ) then print, print_line, ntop, sitphadata.num_pha, print_index(0:3), print_array(print_index(0:3)), format="(7i4, 4f10.6)"
					write_kal_string, print_array(print_index), print_string
;				 	if(n_elements(ephem_string) gt 0) then printf, lun_phalist, header_string + print_string + ephem_string_pha else printf, lun_phalist, header_string + print_string
				endfor



;			ENDIF
;			ENDFOR

	   	if(multi_panel_out gt 0) then begin			
			for i_event = 0, ntop - 1
			
			amass_test = amass_array[i_event]
			einc_test  = einc_test _tof_array[i_event]
			multi_panel_phalist_out = 0
			multi_panel_smoosh_out = 0			

		   		if(amass_test ge 2.0) then $ 
		   			if(amass_test le 8.0 ) then $
	   					if(einc_test  ge 0.25) then $
	   						if(einc_test  le  0.9) then $
	   							if(swoosh_test(einc_test ))then multi_panel_phalist_out = 1

		   		if(amass_test gt 8.0) then $ 
		   			if(amass_test le 70.0 ) then $amass 
	   					if(einc_test  ge 0.08) then $
	   						if(einc_test  le  0.15) then $
	   							if(swoosh_test(einc_test ))then multi_panel_phalist_out = 1

		   		if(amass_test ge 10.0) then $ 
		   			if(amass_test le 70.0 ) then $
	   					if(einc_test  ge 0.03) then $
	   						if(einc_test  le  10. ) then $
	   							if(swoosh_test(einc_test ))then multi_panel_smoosh_out = 1
	
			if( multi_panel_phalist_out) then printf, lun_multi_mass, header_string, amass_test,  format='(a0," 0.,", e12.4,",")'
			
			if(multi_panel_smoosh_out) then printf, lun_multi_smoosh,  header_string, amass_test, einc_test , format='(a0," 0.,",2(e12.4,","))'
 	endfor    ; i_event loop
 endif ;  multi_panel_out test
			
;	ENDFOR

	return

;	write out string to disk (not implemented)
writeout:	return
end
