PRO SIT_LISTER_sav, inpathname
;+
; Project     :	STEREO - IMPACT, SIT
;
; Name        : SIT_LISTER
;
; Purpose     :	Program to read SIT packets sequentially and print output fi les
;
; Category    :	STEREO, IMPACT, SIT
;
; Explanation :	reads a STEREO telemetry data file and extracts data from SIT packets.
;

; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech
;			Modified from program sit_rates.pro by Andrew Davis / gm
;	Modification history:
;		26-Jun-2008	convert sit_common and sep_beacon_common to include files
;					move initialization statements from sit_common to new routine
;					read_calibration  /gm
;


; ****************************************************************

	@sit_common_sav.inc
	@sep_beacon_common.inc

	read_paths
	if (n_elements(inpathname) eq 0) then inpathname='' else print, 'batch job from folder : ', inpathname
	if( inpathname eq '' ) then batch_out = 0 else batch_out = 1     ; batch output flag
	
	read_calibration



;	initialize control flags --  	0 = open file and set up headers
;						1 = running value
;						2 = close file

flag_rates=0L
flag_spectra=0L
flag_hk=0L
flag_beacon=0L
flag_open_sit_file=0L
files_missed = 0L
flag_pha_plots=0L
histogram_num = 1

;	***************************************************************
;	read in the cfg file from standard directory if no foldername passed to program; otherwise from current directory
;
;	************ note:  for any single run, the cdf and times files are read from the same folder ! **********

	if (inpathname eq '' ) then control_file_path='/data/joey/masongm1/Data/work_files_STEREO/sit_lister_control/' $
		else control_file_path=inpathname
	input_file= control_file_path + 'sit_lister_cfg.dat'
	print, ' opening cfg file: ', input_file
	openr, lun_cfg, input_file, /get_lun
	readf, lun_cfg, format='(/)'    ;  skip header line
	output_file_path=''
	readf, lun_cfg, output_file_path
	readf, lun_cfg, format='(/)'    ;  skip header line	
	readf, lun_cfg,  spacecraft_id,  avg_int,  type_out, run_checks, pha_plot_out, error_limit, bkgd_correction_on
	readf, lun_cfg, format='(/)'    ;  skip header line
	readf, lun_cfg,  rates_out,  pha_out,  beacon_out,  hk_out, spectra_out, pha_spectra_out, histogram_out, multi_panel_out
	if( pha_out or histogram_out ) then begin 
		readf, lun_cfg, format='(/)'    ;  skip header line
		readf, lun_cfg,  pha_mlo, pha_mhi, pha_elo,  pha_ehi, bin_width
	endif

; ***************************************************************************
;	device setup for plots -- note: works only when running under IDLDE
		if( pha_plot_out gt 0 ) then begin
			loadct,27
			print, 'loadct called'
			device, decomposed=0
			image=ulonarr(640,512)
			pha_total=0ul
			pha_plot_sum=0UL
			xbounds = fltarr(2)
			ybounds = fltarr(2)
			title_string=''
		endif


	
;	***************************************************************
;	 set flags to control which types of packets will be processed
	if( rates_out or spectra_out or pha_spectra_out or multi_panel_out ) then call_process_rates = 1 else call_process_rates = 0
	if( run_checks or pha_out or multi_panel_out or (pha_plot_out gt 0) or (histogram_out gt 0) or (pha_spectra_out gt 0) ) then call_process_pha = 1 else $
		call_process_pha = 0 
	if( run_checks or hk_out ) then call_process_hk = 1 else call_process_hk = 0   ; 2/13/08
	
		
		avg_int_hk=avg_int
		avg_int_rates=avg_int
		avg_int_beacon=avg_int
		

	time_list_file = control_file_path + 'sit_lister_times.dat'
	if (n_elements(inpathname) eq 0) then input_file =  inpathname +'sit_lister_times.dat'    ; 6/24/08 /gm
	 
	 WHILE ( interval_number lt number_times ) DO BEGIN   ; interval_number = 0,1,2...   number_times = # lines in time list

	get_start_stop_time, time_list_file		; get start and stop days to analyze
	
;	printf, lun_print, ' reading new interval',   start_mjd
	
;	open all output files first time around
	if(interval_number eq 1) then begin
		open_outputs
		if( multi_panel_out gt 0 ) then multi_panel_outputs, start_mjd    ; open files for multi panel plots
	endif
	
	mjd_open = start_mjd
	
	WHILE (mjd_open le stop_mjd) DO BEGIN      ;  file opening loop
	
	open_sit_file_sav, flag_open_sit_file, spacecraft_id, mjd_open


	count_reads=0L	
	packet = 0

	packet_count = -1L
	hk_count = -1L
	rate_count = -1L
	pha_count = -1L
	beacon_count = -1L


	  WHILE 1 DO BEGIN             ; reading loop
;	if flag_open_sit_file = 0, then input file wasn't found;  so skip this day ... count missed files, if 10 in a row, then stop  /gm 5/29/07
	if flag_open_sit_file eq 1 then files_missed = 0 else begin
		files_missed ++
		if (files_missed lt 10) then break else begin         ; if less than 10 files missing, go open next day
		printf, lun_print, '10 input files in a row missing. sit_lister quitting early'
		goto, finish
		endelse
		endelse



;newrec: 	read_stereo_pkt, lun_input, packet
newrec: 	packet_count ++
		if (packet_count eq n_elements(packet_index) ) then break    ; check if we've reached end of day's data
		apid = packet_index(packet_count)
		branch = apid		
		if( (apid ge 606) and (apid le 616) ) then branch = 606

;	compute current time

	CASE branch of
	
	577:  begin
			hk_count ++
			current_mjd = double(data_hk(hk_count).header.timecds.mjd) + double(data_hk(hk_count).header.timecds.time)/(86400.d0*1000.d0)
		end
		
	605: 	 begin 
			rate_count ++
			current_mjd = double(data_rate(rate_count).header.timecds.mjd) + double(data_rate(rate_count).header.timecds.time)/(86400.d0*1000.d0)
		end

	606:  begin
			pha_count ++
			current_mjd = double(data_pha(pha_count).header.timecds.mjd) + double(data_pha(pha_count).header.timecds.time)/(86400.d0*1000.d0)
		end

	624: 	 begin
			beacon_count ++
			current_mjd = double(data_beacon(beacon_count).header.timecds.mjd) + double(data_beacon(beacon_count).header.timecds.time)/(86400.d0*1000.d0)
		end
	ENDCASE

;	compare with the current time interval (start_mjd and stop_mjd)
	if( current_mjd lt start_mjd ) then goto, newrec    ; if before start time, read next packet
	if( current_mjd gt stop_mjd) then break  ; leave packet processing loop if we've gone beyond end time

	proc_flag = 1   ; running value

	case branch of

	577:	if( call_process_hk)  then process_hk_sav, data_hk(hk_count), flag_hk, proc_flag, run_checks, hk_out
		
	605: if( call_process_rates )  then process_rates_sav, data_rate(rate_count), flag_rates, proc_flag
		
	606:	if( call_process_pha ) then PROCESS_PHA_sav, data_pha(pha_count), apid, run_checks, flag_pha_plots, pha_plot_out, histogram_num, proc_flag
		
	624: if(beacon_out) then process_beacon_sav, data_beacon(beacon_count), flag_beacon, proc_flag
		
	else:	if(apid ne 576) then printf, lun_print, ' illegal APID: ', apid    ; APID 576 is command response; not processed; other values not expected
	
	endcase
;	print, apid, current_mjd, hk_count, rate_count, pha_count, beacon_count
	if((apid ge 577) and (apid le 616) ) then count_reads=count_reads+1
;	if(count_reads gt 100) then break


	ENDWHILE   ; loop for reading packets from one day (file) ***********
	
	if( current_mjd gt stop_mjd) then break  ; leave file processing loop if we've gone beyond end time

;	now go on to next day
	mjd_open = mjd_open + 1

;	check the multi panel plots to see if we've finished a plot interval	
	if( multi_panel_out gt 0 ) then multi_panel_outputs, current_mjd    ; open files for multi panel plots


	ENDWHILE   ; loop for file finishing an interval / file opening  *********************************


;	write out any partial sums to disk or pha plot when we cross day boundaries, unless control_flag = 1
	if( control_flag ge 2 ) then begin
		proc_flag = 4
		if( call_process_hk)  then process_hk, packet, flag_hk, proc_flag, run_checks, hk_out
		if(rates_out or spectra_out)  then process_rates, packet, flag_rates, proc_flag
		if( pha_out or (pha_plot_out gt 0) or (histogram_out gt 0) or (pha_spectra_out gt 0)) then process_pha, packet, $
				apid, run_checks, flag_pha_plots, pha_plot_out, histogram_num, proc_flag
				
;	bump histogram number
			histogram_num ++
		if(beacon_out) then process_beacon, packet, flag_beacon, proc_flag

	ENDIF
;	if control_flag = 3, then quit now even if there are more intervals in the file
	if( control_flag eq 3) then goto, finish
	
	ENDWHILE   ; loop for input lines ************************************

;	finish up	
		
;	write out any partial sums to disk or pha plot at end of interval
	proc_flag = 4
	if( call_process_hk)  then process_hk, packet, flag_hk, proc_flag, run_checks, hk_out
	if(rates_out or spectra_out)  then process_rates, packet, flag_rates, proc_flag
	if( pha_out or (pha_plot_out gt 0) or (histogram_out gt 0) or (pha_spectra_out gt 0)) then process_pha, packet, $
				apid, run_checks, flag_pha_plots, pha_plot_out, histogram_num, proc_flag
	if(beacon_out) then process_beacon, packet, flag_beacon, proc_flag
	


	
finish:		if( (rates_out+pha_out+beacon_out+hk_out+spectra_out+pha_spectra_out+histogram_out+multi_panel_out) gt 0) then begin
			printf, lun_print, " sit_lister is finished;  output files = ",    strmid(out_file,21,22,/reverse_offset) 
			close, /all     ; close all the files			
		endif else begin	
			printf, lun_print, " sit_lister is finished"
		endelse

		if( exit_status_flag ne 0 ) then begin
					print, ' sit_lister exit with error status = ', exit_status_flag
					exit, status = exit_status_flag
		endif



end 
