;	 SIT_COMMON_sav include file
;+
; Project     :	STEREO - IMPACT, SIT
;
; Name        : SIT_COMMON
;
; Purpose     :	setup SIT common block
;               global constants and variables for SIT data processing)

; History     :	Version 1 (example), 28-Jun-2006, Andrew Davis, Caltech.
;					25-Aug-2006	add starttime and stoptime (MJD)
;			modify to read in 082307 tables /gm
;			modify paths and batch_out variable handling /gm
;			30-Sept-2008	changed utc time structure definitions to { MJD: 0.d0, TIME: 0.d0 } to prevent overflows /gm
;			11-Mar-2010	multi_panel_rates array redefined to use next lower energy box /gm
;			22-Mar-2010	add common webfiles

; ****************************************************************

common sit_data, packet_index, data_hk, data_rate, data_pha, data_pha_float_array, data_beacon  ; sav file data

; ****************************************************************
common sitcom, VERSION_sit, PKTDATASIZE
; common sitcom, VERSION, FILL_D, FILL_L, PKTDATASIZE
VERSION_sit = 1B  ; software version
;FILL_L = -2147483647L ; long (32-bit) integer fill-data
;FILL_D = -1.0E31 ; double fill-data
PKTDATASIZE = 261   ; includes checksum byte in each packet
startMJD = 0L   ; start time in MJD
stopMJD = 0L    ; stop time in MJD

; ****************************************************************
common lun_numbers, lun_print, lun_input, lun_ratelist, lun_phalist, lun_hklist, lun_beaconlist, lun_spectralist, lun_histogramlist,  lun_pha_spectralist, $
              lun_multi_rate, lun_multi_mass, lun_multi_smoosh, out_file
; clear lun numbers
lun_print = -1   ; default print queue -- will be replaced later by an output file if a batch job
lun_input = 0
lun_ratelist = 0
lun_phalist = 0
lun_hklist = 0
lun_beaconlist = 0
lun_spectralist = 0
lun_histogramlist = 0 
lun_pha_spectralist = 0
lun_multi_rate = 0
lun_multi_mass = 0
lun_multi_smoosh = 0
lun_batch = 0
out_file = ''


; ****************************************************************
common paths, 	control_file_path, output_file_path, flight_data_path, calibration_data_path, $
	efficiency_data_path, hex_table_path, ephemeris_path, sep_beacon_tables_path, $
	sit_background_corrections_path, sit_rate_box_ranges_path
	

; ****************************************************************
common calibration, tof_array, energy_array, einc_tof_array, einc_ssd_array, amass_array
; cal tables written using: $USER:[MASON.STEREO.CAL_TABLES]   SIT_CAL_TABLE_GENERATOR.FOR;33   11  22-AUG-2006
;amass_array=fltarr(2048,2,512,2)				; index is e ch, gain, tof ch, sc
;energy_array=fltarr(2048,2,2)					; index is ech, gain, sc
;einc_ssd_array=fltarr(2048,2,512,2)				; index is e ch, gain, tof ch, sc
;einc_tof_array=fltarr(2048,2,512,2)				; index is e ch, gain, tof ch, sc
;tof_array=fltarr(512,2)						; index is tch, sc


;****************************************************************
common hex_tables, issdhi_array, issdlo_array, ibox_array, itof_array, hex_table_mjd


; ****************************************************************
common spacecraft, spacecraft_name,ahead, behind,spacecraft_id

spacecraft_name=strarr(2)
spacecraft_name(0) = "Ahead"
spacecraft_name(1) = "Behind"
ahead=234
behind=235



; ****************************************************************
common time_bounds, time_data,start_mjd, stop_mjd, control_flag,interval_number,number_times, $
	t_start_hi, t_stop_hi, t_start_lo, t_stop_lo, swoosh_flag, $   ; swoosh times; flag is 0 if interval is not a swoosh interval; 1 if it is
	swoosh_emax, swoosh_emin  ; high and low energy limits for the current time in the current time interval
number_times = 1L
interval_number=0L


; ****************************************************************
common exit_status, exit_status_flag
exit_status_flag = 0L


;*****************************************************************   times used to identify data gaps
common last_write_times, rate_write_time, hk_write_time, beacon_write_time
rate_write_time = 0.d0
hk_write_time = 0.d0
beacon_write_time = 0.d0


; ****************************************************************
common rate_information, disc_names,matrix_rates,beacon_rates, delta_e
delta_e = fltarr(2,116)



; ****************************************************************
common mbox_factors, effic,  geom_factor
effic = fltarr(2,116)
geom_factor = 0.29    ; cm2-sr 


; ****************************************************************
common rate_averages, mrate_average, mrate_counts, mrate_sigma, discrate_average, avg_int_rates, num_avg_ints_rates, bin_last_rates, $
           bin_now_rates, utc_average_rates, utc_average_time, sitratedata_last
mrate_average=fltarr(116)
mrate_counts=fltarr(116)
mrate_sigma=fltarr(116)
discrate_average=fltarr(16)
avg_int_rates=0L				; averaging interval length (min)
num_avg_ints_rates=0L			; number of averaging intervals in current sum
bin_last_rates=-1L				; bin # of day into which last rates were averaged
bin_now_rates=0L				; bin # of day of current packet
utc_average_rates = { MJD: 0.d0, TIME: 0.d0 }		; average utc time structure
utc_average_time = 0.d0                   ; bin for summing mjd as a day and fraction

; ****************************************************************
common hk_averages, hk_average, avg_int_hk, num_avg_ints_hk, bin_last_hk, bin_now_hk, utc_average_hk,mf_num_av,tof_gain_av, $
           tof_cal_av,tof_cal_err_av,sw_version_avg,lookup_checksum_avg, sithkdata_last
hk_average=fltarr(8)
avg_int_hk=0L				; averaging interval length (min)
num_avg_ints_hk=0L			; number of averaging intervals in current sum
bin_last_hk=-1L				; bin # of day into which last hks were averaged
bin_now_hk=0L				; bin # of day of current packet
mf_num_av = 0UL
tof_gain_av = 0US
tof_cal_av = 0US
tof_cal_err_av = 0US
sw_version_avg = 0US
lookup_checksum_avg = 0UL
utc_average_hk = { MJD: 0.d0, TIME: 0.d0 }		; average utc time structure

;*****************************************************************
common HK_coefficients, hk_a0, hk_a1, v_ref_ch, v_slope ; see SIT description Appendix 15, + notes 12/27/06
hk_a0 = fltarr(2,8)
hk_a1 = fltarr(2,8)
hk_a0(0,*) = [4133.5260, 37.4581, 37.4581, 45.7564, 5.1000, 5.1000,10.2000,10.1911]
hk_a0(1,*) = [4133.5260, 49.5024, 49.5024, 49.5024, 5.1000, 5.1000, 10.2000,10.1911]
hk_a1(0,*) = [-16.5870, -0.3146, -0.3146, -0.4188, -0.0200, -0.0200, -0.0400,-0.0412]
hk_a1(1,*) = [-16.5870, -0.4885, -0.4885, -0.4885, -0.0200, -0.0200, -0.0400, -0.0412]
v_ref_ch =  [101.5, 100]  ; reference 6V HK channel number for temp calibration
v_slope = [-2.68, -2.68]  ; ratio of delta-temp-ch/delta-6V-channel  12/15/06 SIT-A


; ****************************************************************
common box_check, calc_matrix_box, calc_pri, calc_bea_box, m_box_err, p_box_err, bad_box_count 
calc_matrix_box = intarr(64)
calc_pri = intarr(64)
calc_bea_box = intarr(64)
m_box_err = intarr(64)
p_box_err = intarr(64)
bad_box_count = 0L

; ****************************************************************
common beacon_averages, het_beacon_avg,sit_beacon_avg,let_beacon_avg,sept_beacon_avg, avg_int_beacon, num_avg_ints_beacon, $
     bin_last_beacon, bin_now_beacon, utc_average_beacon, sepbeacondata_last
het_beacon_avg=fltarr(10)		; 10 het beacon rates  (number carried in sep_beacon_common.pro; total of 60 beacon rates)
sit_beacon_avg=fltarr(12)			; 12 sit
let_beacon_avg=fltarr(18)			; 18 let
sept_beacon_avg=fltarr(20)		; 20 sept
avg_int_beacon=0L				; averaging interval length (min)
num_avg_ints_beacon=0L			; number of averaging intervals in current sum
bin_last_beacon=-1L				; bin # of day into which last beacon were averaged
bin_now_beacon=0L				; bin # of day of current packet
utc_average_beacon = { MJD: 0.d0, TIME: 0.d0 }		; average utc time structure

;******************************************************************
common misc_counters, pha_writes, start_time              ; common to keep track of various counters
pha_writes = 0.
start_time=systime(1)   ;  start time for run

;******************************************************************
common pha_limits, pha_mlo, pha_mhi, pha_elo,  pha_ehi, bin_width
; contains mass and energy limits for writing to pha file

; *****************************************************************
common intensity_ratios, ratio_indices
ratio_indices = [0, 0, 0, 0, 0, 0, 0, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, $
33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, $
73, 74, 75, 76, 77, 78, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, $
77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, $
72, 73, 74, 75, 76, 77, 0, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 0, 0, 0, 0, 0, 0, 0, 0]
; array generated with an Excel spread sheet then pasted into Word, etc.  ; specifies which of the 
; 0-115 matrix rates are divided by another rate, and gives the index;  if 0, no ratio is calculated
	   
; *****************************************************************
common histogram_sums, histogram_array, num_histograms, nbins
histogram_array = 0 
num_histograms = 0
nbins = 0

; ****************************************************************
common pha_rate_averages, mpha_rate_average, mpha_rate_counts, mpha_rate_sigma, avg_int_pha_rates, num_avg_ints_pha_rates, bin_last_pha_rates, $
           bin_now_pha_rates, utc_average_pha_rates, sitpha_ratedata_last, mpha_priority_counts, mpha_priority_rate_counts, mpha_rate_out, mpha_rate_sigma_out
mpha_rate_average=fltarr(116,2)              ; each pha average has 2 priority bins; this array contains pha cts or cts/s depending on flux type
mpha_rate_counts=ulonarr(116,2)             ; # cts by box and priority 
mpha_rate_sigma=fltarr(116,2)
mpha_priority_counts=ulonarr(2)		; number of pha events of each priority
mpha_priority_rate_counts=ulonarr(2)	; number of matrix rate counts of each priority
mpha_rate_out = fltarr(116)			; summed lo + high priority;  this is flux, fluence, or counts depending on config choice
mpha_rate_sigma_out = fltarr(116)		;     "
avg_int_pha_rates=0L				; averaging interval length (min)
num_avg_ints_pha_rates=0L			; number of averaging intervals in current sum
bin_last_pha_rates=-1L				; bin # of day into which last pha_rates were averaged
bin_now_pha_rates=0L				; bin # of day of current packet
utc_average_pha_rates = { MJD: 0.d0, TIME: 0.d0 }		; average utc time structure

; ******************* output items ****************
common output_items, batch_out, type_out, rates_out, pha_out,  beacon_out,  hk_out, spectra_out, pha_spectra_out, histogram_out, multi_panel_out, error_limit           
; for type_out:  0 = flux;  1 = fluence; 2 = counts


;******************************************************************
common pha_plots, image, pha_total, pha_plot_sum, xscale,yscale,xbounds,ybounds,title_string


; **************************  ephemeris data *****************************
common stereo_ephem, au_km, synodic_rotation, gse, angles, rotated_time, position_structure, max_sc_recs, last_index, last_ephem_time, ephem_string_pha
	au_km = 1.4958D8    ; astronomical unit in km
	synodic_rotation = 360./27.2753    ; degrees per day
	gse=fltarr(3,2)     ; units:  km
	angles=fltarr(3)    ; 0 = B to SEarth line; 1 = Sun-Earth line to A;  2 = B to A (degrees)
	rotated_time = { MJD: 0.d0, TIME: 0.d0 }	   ; rotated time to Sun-Earth line assuming solar corotation delay   (mjd)
	rotated_time = replicate(rotated_time, 2)
;	max_sc_recs = fltarr(2)	; number of entries in position_structure for each spacecraft  (initialized in subroutine read_position), 
;															not here so as to carry over from one run to another
	last_index = ulonarr(2)		; index number of the last search
	last_ephem_time = dblarr(2)   ; time of last ephemeris data returned
	ephem_string_pha =''     ; string for writing out ephemeris for pha file
	
; *************************** background correction ***************************
common background_correction, bkgd_flux, spillover_fraction, spillover_box, box_width_adjust, bkgd_correction_on


; *************************** multi_panel plots ***************************
common multi_panel_plot_items,  flag_multi_panel, multi_panel_rates, multi_panel_start_mjd, multi_panel_stop_mjd
;		multi_panel_rates = [20, 34, 67, 100] ; SIT matrix rates for output to multi_panel_plots
		multi_panel_rates = [19, 33, 66, 99] ; SIT matrix rates for output to multi_panel_plots  ;  190 kev/n   11-Mar-2010/gm
		flag_multi_panel = 0

; *************************** spectra event counter ***************************
common event_counter, event_number, event_number_pha_spectra
	event_number = 1L
	event_number_pha_spectra = 1L	

; *************************** time of current packet ***************************
common current_packet_time, current_mjd
current_mjd = 0.d0

; **************************** webfiles items **********************************   3/23/2010
common webfiles, rate_lo, rate_hi, num_rates, lun_output, utc_interval_start, webfiles_out
	utc_interval_start = { MJD: 0.d0, TIME: 0.d0 }		; average utc time structure
