PRO WRITE_SPECTRA, sitratedata, proc_flag

;
;	writes out SIT spectra		16-Mar-2007 /gm;   22 Mar-2007 add ratios 
;							8-Jun-2011	add requirements that both numerator & denominator effic > 0 to print ratios /gm
;		23-Jun-2011	add correction for rom box areas /gm
;					note:  mrate_average array is not touched since it is also used for pha counts calculation -- multiplier
;						for box areas is used only just before printout
;
 common rate_averages
 common last_write_times
 common spacecraft
 common rate_information
 common mbox_factors
 common current_packet_time
 common intensity_ratios
 common output_items
 common background_correction
 common lun_numbers
 common event_counter

	if(num_avg_ints_rates eq 0 ) then return
;	if we already divided by time interval in putting out rates, don't divide a 2nd time
	if( (rates_out eq 0) and (multi_panel_out eq 0) ) then begin   ; test 2/5/08 for call to process rates /gm
		utc_average_time = 	utc_average_time/double(num_avg_ints_rates)
		utc_average_rates.mjd = floor(utc_average_time)
		utc_average_rates.time = (utc_average_time - floor(utc_average_time))*86400000.d0    ; avg date calculation fixed 2/4/08 /gm
		if(type_out eq 0) then mrate_average = mrate_average/(num_avg_ints_rates*60.)   ; don't divide by time interval unless intensity units
	endif
	
;	calculate sigmas
	for i = 7,115 do begin
		if(mrate_counts[i] gt 0) then mrate_sigma[i]=mrate_average[i]/sqrt(mrate_counts[i])
	endfor

;	put the header stuff into a string
	header_string = string( event_number, utc2str(utc_average_rates,/ecs,/truncate), $
		mjd2decyr(utc_average_rates), mjd2decdoy(utc_average_rates),  format ='(1x, i6, ",", a23,"," 2(f16.6,","))'   )
;
;	correct for background
;
	if( (bkgd_correction_on) and (type_out le 1) ) then correct_mrate_background    ; correct background for flux or fluence output 

;		for i = 7,115  do print,i, mrate_counts[i]
	for i=7,115 do begin

		;		zero out rates whose sigma exceeds the error limit (will note be printed)   8-Feb-08  /gm		
			if( mrate_sigma(i) gt 0. ) then $
			if( (mrate_sigma(i)/mrate_average(i)) gt error_limit ) then begin
				mrate_average(i) = 0.
				mrate_sigma(i) = 0.
			endif
		
		if(  (mrate_counts[i] ge 2) and (mrate_average[i] gt 0.) and $
			(effic(spacecraft_id,i) gt 0) and (delta_e(spacecraft_id,i) gt 0) ) then begin   ; don't write rates with zero flux or < 2 counts
;		check that there are counts for the ratios calculation, or else set a flag
		ratio_out = 0   ; don't do ratios line
		if( (mrate_counts[i] ge 2) and (mrate_counts(ratio_indices(i)) ge 2) and (mrate_average[i] gt 0.) $
			and (mrate_average[ratio_indices(i)] gt 0.) and (ratio_indices(i) gt 0) )then ratio_out = 1  ; (true)

;	if(i eq 70) then print, ' from write spectra: ', mrate_counts(i)
		
		print_string=''
		print_string = print_string + string( matrix_rates[i].emin_nominal[spacecraft_id],matrix_rates[i].emax_nominal[spacecraft_id],(matrix_rates[i].emin_nominal[spacecraft_id]+matrix_rates[i].emax_nominal[spacecraft_id])/2., $
				(matrix_rates[i].emax_nominal[spacecraft_id]-matrix_rates[i].emin_nominal[spacecraft_id])/2., format ='(4(e11.4,","))' )  ; emin, emax_nominal used 4/11/2011 /gm

			if( (type_out lt 2) and (current_mjd ge rom_corr_mjd(spacecraft_id)) ) then begin
				if((i ge 7) and (i le 18)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(2(e11.4,","))' )
				if((i ge 19) and (i le 28)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='((",,"),2(e11.4,","))' )
				if((i ge 29) and (i le 44)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(2(",,"),2(e11.4,","))' )
				if((i ge 45) and (i le 61)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(3(",,"),2(e11.4,","))' )
				if((i ge 62) and (i le 77)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(4(",,"),2(e11.4,","))' )
				if((i ge 78) and (i le 93)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(5(",,"),2(e11.4,","))' )
				if((i ge 94) and (i le 107)) then print_string = print_string + string(mrate_average(i)*rom_corr(spacecraft_id,i), mrate_sigma(i)*rom_corr(spacecraft_id,i), format ='(6(",,"),2(e11.4,","))' )
			endif else begin
				if((i ge 7) and (i le 18)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(2(e11.4,","))' )
				if((i ge 19) and (i le 28)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='((",,"),2(e11.4,","))' )
				if((i ge 29) and (i le 44)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(2(",,"),2(e11.4,","))' )
				if((i ge 45) and (i le 61)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(3(",,"),2(e11.4,","))' )
				if((i ge 62) and (i le 77)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(4(",,"),2(e11.4,","))' )
				if((i ge 78) and (i le 93)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(5(",,"),2(e11.4,","))' )
				if((i ge 94) and (i le 107)) then print_string = print_string + string(mrate_average[i], mrate_sigma[i], format ='(6(",,"),2(e11.4,","))' )
			endelse

;		now calculate the ratios (H/He, 3He/4He, He/O,C/O, NeS/O, and Fe/O and add them to the print strings
;		print out the ratios if the efficiencies for both numerator and denominator are gt 0.
		if( (effic(spacecraft_id,i) gt 0.) and  (effic(spacecraft_id, ratio_indices(i)) gt 0.) ) then begin		
			if((i ge 7) and (i le 18) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(7(",,"),2(e11.4,","))' )
			if((i ge 19) and (i le 28) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(7(",,"),2(e11.4,","))' )
			if((i ge 29) and (i le 44) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(7(",,"),2(e11.4,","))' )
			if((i ge 46) and (i le 61) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(7(",,"),2(e11.4,","))' )
			if((i ge 78) and (i le 93) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(6(",,"),2(e11.4,","))' )
			if((i ge 95) and (i le 107) and ratio_out ) then print_string = print_string + string(mrate_ratio(i), mrate_ratio_sigma(i), format ='(6(",,")2(e11.4,","))' )
		endif  ; check on efficiencies		
		
		
		printf, lun_spectralist, header_string + print_string	
		ENDIF

	ENDFOR
	
;	bump event counter
	event_number ++
end
