PRO write_rates, sitratedata, proc_flag
;
;	writes out SIT rates
;
;	Modification history:
;		22-Mar-2010	add provision for processing webfies /gm
;		22-Jun-2011	add correction for rom box areas /gm
;					note:  mrate_average array is not touched since it is also used for pha counts calculation -- multiplier
;						for box areas is used only just before printout
;		9-Jul-2011	fix partial sum to have units of counts/s
;		13-Dec-2013	adjust dead time counter to show fraction of 32768 at for all values of num_avg_ints_rates /gm
;					this gives an output that does not change from one time resolution to another;  however, the
;					real meaning and/or calibration of this item is not really clear.
;		13-Nov-2018	switch over to pha rates after mjd 58385 (9/23/2018 onset of matrix box problem, SIT-A) /gm

 common rate_averages
 common last_write_times
 common output_items
 common spacecraft
 common stereo_ephem          ; contains ephemeris data returned & misc counters
common mbox_factors
common current_packet_time
common lun_numbers
common multi_panel_plot_items
common webfiles
	
	if(num_avg_ints_rates eq 0) then return	

	partial_sum = total( mrate_counts(6:115))
	cmd_flags = intarr(4)
;	extract commands if sitratedata_last is defined (structure, type =8)
	extract_cmds, sitratedata_last.FLAGS, tof, hv, eonly, junk

; ***** divide by total time only in case of intensity calculation
	if( type_out eq 0) then begin 
		mrate_average = mrate_average/(num_avg_ints_rates*60.)
		discrate_average = discrate_average/(num_avg_ints_rates*60.)
		partial_sum = partial_sum/(num_avg_ints_rates*60.)
	ENDIF

;	************ if processing webfiles, just jump to that section ************* 3/22/2010
	if( n_elements(webfiles_out) ne 0 ) then goto, web_files_out
	
	
	utc_average_time = 	utc_average_time/double(num_avg_ints_rates)
	utc_average_rates.mjd = floor(utc_average_time)
	utc_average_rates.time = (utc_average_time - floor(utc_average_time))*86400000.d0    ; avg date calculation fixed 2/4/08 /gm
;	print, 'time at start in write_rates: ', utc_average_time, num_avg_ints_rates
	
;	take care of special cases of Discr rates #1, 7 (prescaled by factor of 8); and #6 (fraction of time/32768)
	discrate_average(0)=discrate_average(0)*8
	discrate_average(6)=discrate_average(6)*8
	discrate_average(5)=discrate_average(5)*(60.)/32768

;	put the header stuff into a string
	header_string = string( utc2str(utc_average_rates,/ecs,/truncate), $
		mjd2decyr(utc_average_rates), mjd2decdoy(utc_average_rates), num_avg_ints_rates*60./2., format ='(a23,"," 2(f16.6,","),f8.1,",")'   )

;	now put the rest of the items in an array for printing in kaleidagraph format
	array = [discrate_average]

;	branch on whether or not we are beyond the start date for rom box corrections
	for i=0,115 do begin
		if( effic(spacecraft_id,i) lt 0.) then goto, nextone
			if( (type_out lt 2) and (current_mjd ge rom_corr_mjd(spacecraft_id)) ) then begin
				array = [array, mrate_average(i)*rom_corr(spacecraft_id,i)]
			endif else begin
				array = [array, mrate_average(i)]
			endelse
nextone:
	endfor
	
	array = [array, mrate_average(0)+mrate_average(1)]
	array = [array, mrate_average(2)+mrate_average(3)]
	array = [array, partial_sum]
	array = [array, sitratedata_last.HVSTEP]
	array = [array, tof+2 ]
	array = [array, hv+4 ]
	array = [array, eonly+6 ]
	array = [array, junk+8 ]
	array = [array, sitratedata_last.LIMHI ]

;	put the array into a line formatted for kaleidagraph 
	WRITE_KAL_STRING, array, print_string
;	stop	

; before writing out, check to see if the current time is one averaging interval past the prior write;  if not (to 10%) insert a blank line 
;	calculate the current mjd for comparison with last write time
	current_mjd = double(utc_average_rates.mjd) + double(utc_average_rates.time)/double(86400.*1000)
	if((rates_out) and (rate_write_time gt 0)) then begin
		if( (abs(current_mjd - rate_write_time) gt 1.1*avg_int_rates/1440.d0) ) then printf, lun_ratelist, string( utc2str(utc_average_rates,/ecs,/truncate)) + ',,,,,,,,,,' 
	ENDIF

;	now calculate the ephemeris data for this line and tack onto the end of the print string
	current_mjd = double(utc_average_rates.mjd) + double(utc_average_rates.time)/double(86400.*1000)
;			calculate ephemeris data
;	print, ' calling ephemeris from write_rates, current_mjd: ', current_mjd
	stereo_ephemeris, current_mjd
;			build up ephemeris string, which will be added to each pha output line
	ephem_string_rates = string( utc2str(rotated_time(spacecraft_id),/ecs,/truncate), $
		mjd2decyr(rotated_time(spacecraft_id)), mjd2decdoy(rotated_time(spacecraft_id)), gse(0,spacecraft_id)/au_km, gse(1,spacecraft_id)/au_km, gse(2,spacecraft_id)/au_km,  $
		angles, format ='(a23,"," 2(f16.6,","),3(e15.6,","), 3(f8.3,","))'   )	
	
	
	
;	now write out the line (if we are putting out rates): 	(test for missing ephemeris and don't add string if gse coordinate is zero)	/gm 8/23/07
	if((rates_out) and (gse(0,spacecraft_id) ne 0.) ) then printf, lun_ratelist, header_string + print_string	+ ephem_string_rates $
		else if(rates_out) then printf, lun_ratelist, header_string + print_string
	
;	clear the print string
	print_string=''

; update the write time
	rate_write_time = current_mjd

;	now write the multi panel plot rates  -- don't use after 9/23/2018 onset of matrix box problem *********
	if( multi_panel_out gt 0 and (current_mjd ge rom_corr_mjd(spacecraft_id)) and (current_mjd le 58385.d0) ) then begin
		array=[mrate_average(multi_panel_rates(0))]
		for i=1, 3 do array=[array, mrate_average(multi_panel_rates(i))]
;	******* if past start dates for rom box corrections, fold in factors if intensity or fluence calculation *************    6/20/2011
		if( type_out lt 2 ) then for i = 0,3 do array(i) = array(i)*rom_corr(spacecraft_id, multi_panel_rates(i))
;	don't print out rates here if we're doing the special multipanel with beacon data
	if( multi_panel_out_sit_a_conjunction eq 0 ) then printf, lun_multi_rate, header_string, array,  format='(a0,4(e12.4,","))'
;			print, header_string, array,  format='(a0,4(e12.4,","))'
;	print, 'now writing rom rates at mjd: ', current_mjd
	endif
	return
	
 web_files_out:  mjd2date, utc_interval_start.mjd, year, month, day
 		sec = utc_interval_start.time/1000.d0
		doy = date2mjd(year,month,day) - date2mjd(year,1,1) + 1.d0  + sec/86400.d0
		hour = floor( sec/3600.d0 )
		min = (sec - hour*3600.d0)/60.d0
		sec = sec mod 60.
;2009  10.000382  0  0 33 0 59.1373  
		for i = 0, (n_elements(rate_lo)-1) do begin
			printf, lun_output(i), year, doy, hour, min, sec, num_avg_ints_rates, format="($,i4, f11.6,  3i3, i5 )"

;	******* if intensity or fluence calculation and if past start dates for rom box corrections, fold in correction factors  *************    6/20/2011			
			for j= rate_lo(i), rate_hi(i) do begin
				if( (type_out lt 2) and (current_mjd ge rom_corr_mjd(spacecraft_id)) ) then begin
					printf, lun_output(i), mrate_average(j)*rom_corr(spacecraft_id,j), format=string( num_rates(i), format="( '($,',i0,'e13.4)' )" )

				endif else begin
					printf, lun_output(i), mrate_average(j), format=string( num_rates(i), format="( '($,',i0,'e13.4)' )" )
				endelse
			endfor			
						
			for j= rate_lo(i), rate_hi(i) do printf, lun_output(i), mrate_counts(j), format=string( num_rates(i), format="( '($,',i0,'i8)' )" )
;			write out a character to force a line feed
			printf, lun_output(i),' ',format='(a1)'
		endfor

end
