PRO write_pha_rates, sitratedata, proc_flag
;
;	writes out SIT rates
;
;	Modification history:
;		22-Mar-2010	add provision for processing webfies /gm
;		9-Jul-2011	fix partial sum to have units of counts/s
;		13-Nov-2018	switch over to pha rates after mjd 58385 (9/23/2018 onset of matrix box problem, SIT-A) /gm
 common rate_averages
 common last_write_times
 common output_items
 common spacecraft
 common stereo_ephem          ; contains ephemeris data returned & misc counters
common mbox_factors
common lun_numbers
common multi_panel_plot_items
common webfiles
	
	common pha_rate_averages
 	common calibration
	common rate_information
	
	if(num_avg_ints_pha_rates eq 0) then return	
	partial_sum = total( mrate_counts_pha_ctr(6:115))
	cmd_flags = intarr(4)
;	extract commands if sitratedata_last is defined (structure, type =8)
	extract_cmds, sitratedata_last.FLAGS, tof, hv, eonly, junk

; ***** divide by total time only in case of intensity calculation
	if( type_out eq 0) then begin 
		mrate_average_pha_ctr = mrate_average_pha_ctr/(num_avg_ints_pha_rates*60.)
		discrate_average_pha_ctr = discrate_average_pha_ctr/(num_avg_ints_pha_rates*60.)
		partial_sum = partial_sum/(num_avg_ints_pha_rates*60.)
	ENDIF

	utc_average_pha_time = 	utc_average_pha_time/double(num_avg_ints_pha_rates)
	current_mjd = utc_average_pha_time
	utc_average_pha_rates.mjd = floor(utc_average_pha_time)
	utc_average_pha_rates.time = (utc_average_pha_time - floor(utc_average_pha_time))*86400000.d0    ; avg date calculation fixed 2/4/08 /gm


	
;	take care of special cases of Discr rates #1, 7 (prescaled by factor of 8); and #6 (fraction of time/32768)
	discrate_average_pha_ctr(0)=discrate_average_pha_ctr(0)*8
	discrate_average_pha_ctr(6)=discrate_average_pha_ctr(6)*8
	discrate_average_pha_ctr(5)=discrate_average_pha_ctr(5)*(num_avg_ints_pha_rates*60.)/32768

;	put the header stuff into a string
;	print, ' num_avg_ints_rates, num_avg_ints_pha_rates: ', num_avg_ints_rates, num_avg_ints_pha_rates
	header_string = string( utc2str(utc_average_pha_rates,/ecs,/truncate), $
		mjd2decyr(utc_average_pha_rates), mjd2decdoy(utc_average_pha_rates), num_avg_ints_pha_rates*60./2., format ='(a23,"," 2(f16.6,","),f8.1,",")'   )

;	now put the rest of the items in an array for printing in kaleidagraph format
	array = [discrate_average_pha_ctr]
	for i=0,6  do if(effic(spacecraft_id,i) gt 0.) then array = [array, mrate_average_pha_ctr(i)]   ; first put in the bookkeeping rates
	
;	************************************* inserted pha rate calculation for bins 7 to 115 ************************************

		mpha_rate_average = double(mpha_rate_counts)
		if(type_out eq 0) then begin
			mpha_rate_average(*,0) = mpha_rate_average(*,0)/(num_avg_ints_pha_rates*60.)
			mpha_rate_average(*,1) = mpha_rate_average(*,1)/(num_avg_ints_pha_rates*60.)
		endif

	; **** now add together the 2 priority states, weighted by total # of that priority and the matrix_rate counts ****
		mpha_rate_out = fltarr(116)
		mpha_rate_sigma_out = fltarr(116)
		mparts = fltarr(2)
		for i = 7, 115 do begin



;										*** use double precision to prevent intermediate products overflowing ****		
			if( mpha_priority_counts(0) gt 0) then mparts(0) = double(mpha_rate_average(i,0))*mpha_priority_rate_counts(0)/mpha_priority_counts(0) else mparts(0) = 0.
			if( mpha_priority_counts(1) gt 0) then mparts(1) = double(mpha_rate_average(i,1))*mpha_priority_rate_counts(1)/mpha_priority_counts(1) else mparts(1) = 0.




;	mparts(0) = 0  ; ***************** test

;		if output is intensity or fluence fold in efficiency, etc.; otherwise just pass along counts
;		calculate sigmas  -- attribute all the statistical error to the counting statistics in the boxes
			if(type_out le 1) then begin
				low_pri_part = mparts(0)/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
				high_pri_part = mparts(1)/(effic(spacecraft_id,i)*delta_e(spacecraft_id,i)*geom_factor)
				if( mpha_rate_counts(i,0) gt 0 ) then low_pri_sigma = low_pri_part/sqrt(mpha_rate_counts(i,0)) else low_pri_sigma = 0.
				if( mpha_rate_counts(i,1) gt 0 ) then high_pri_sigma = high_pri_part/sqrt(mpha_rate_counts(i,1)) else high_pri_sigma = 0.				
				mpha_rate_out(i) = low_pri_part + high_pri_part				
				mpha_rate_sigma_out(i) = sqrt(low_pri_sigma^2 + high_pri_sigma^2)

			endif else begin
				mpha_rate_out(i)=double(mpha_rate_counts(i,0))+double(mpha_rate_counts(i,1))   
				mpha_rate_sigma_out(i) = sqrt(mpha_rate_out(i))
			endelse				

		endfor
;	stop	
;	********************************************************************************************************************
;	now insert the pha rates in place of where the rom box rates (mrate_average_pha_ctr(i)) would have gone:     4/29/2011

	for i=7,115 do if(effic(spacecraft_id,i) gt 0.) then array = [array, mpha_rate_out(i)]

;	********************************************************************************************************************
	array = [array, mrate_average_pha_ctr(0)+mrate_average_pha_ctr(1)]
	array = [array, mrate_average_pha_ctr(2)+mrate_average_pha_ctr(3)]
	array = [array, partial_sum]
	array = [array, sitratedata_last.HVSTEP]
	array = [array, tof+2 ]
	array = [array, hv+4 ]
	array = [array, eonly+6 ]
	array = [array, junk+8 ]
	array = [array, sitratedata_last.LIMHI ]

;	put the array into a line formatted for kaleidagraph 
	WRITE_KAL_STRING, array, print_string

;	************ if processing webfiles, just jump to that section ************* 3/22/2010
	if( n_elements(webfiles_out) ne 0 ) then goto, web_files_out
	

; before writing out, check to see if the current time is one averaging interval past the prior write;  if not (to 10%) insert a blank line 
;	compare current mjd with last write time
	if((pha_rates_out) and (pha_rate_write_time gt 0)) then begin
		if( (abs(current_mjd - pha_rate_write_time) gt 1.1*avg_int_pha_rates/1440.d0)  ) then printf, lun_pha_ratelist, string( utc2str(utc_average_pha_rates,/ecs,/truncate)) + ',,,,,,,,,,' 
	ENDIF

;	now calculate the ephemeris data for this line and tack onto the end of the print string
;			calculate ephemeris data
;	print, ' calling ephemeris, current_mjd: ', current_mjd
	stereo_ephemeris, current_mjd
;			build up ephemeris string, which will be added to each pha output line
	ephem_string_rates = string( utc2str(rotated_time(spacecraft_id),/ecs,/truncate), $
		mjd2decyr(rotated_time(spacecraft_id)), mjd2decdoy(rotated_time(spacecraft_id)), gse(0,spacecraft_id)/au_km, gse(1,spacecraft_id)/au_km, gse(2,spacecraft_id)/au_km,  $
		angles, format ='(a23,"," 2(f16.6,","),3(e15.6,","), 3(f8.3,","))'   )	
	
	
	
;	now write out the line (if we are putting out rates): 	(test for missing ephemeris and don't add string if gse coordinate is zero)	/gm 8/23/07
	if((pha_rates_out) and (gse(0,spacecraft_id) ne 0.) ) then printf, lun_pha_ratelist, header_string + print_string	+ ephem_string_rates $
		else if(pha_rates_out) then printf, lun_pha_ratelist, header_string + print_string
;	clear the print string
	print_string=''

; update the write time
	pha_rate_write_time = current_mjd

 
;	now write the multi panel plot rates -- use pha_data is time is before dates in rom_corr_mjd array -- 6/27/2011 /gm
;	-- also use after 9/23/2018 onset of matrix box problem *********
	if( multi_panel_out gt 0 and ((current_mjd lt rom_corr_mjd(spacecraft_id)) or (current_mjd ge 58385.d0)) ) then begin
		array=[mpha_rate_out(multi_panel_rates(0))]
		for i=1, 3 do array=[array, mpha_rate_out(multi_panel_rates(i))]
		printf, lun_multi_rate, header_string, array,  format='(a0,4(e12.4,","))'
;			print, header_string, array,  format='(a0,4(e12.4,","))'
;	print, 'now writing pha rates at mjd: ', current_mjd

	endif
	
	
	return
	
 web_files_out:  mjd2date, utc_interval_start_pha_rates.mjd, year, month, day
 		sec = utc_interval_start_pha_rates.time/1000.d0
		doy = date2mjd(year,month,day) - date2mjd(year,1,1) + 1.d0  + sec/86400.d0
		hour = floor( sec/3600.d0 )
		min = (sec - hour*3600.d0)/60.d0
		sec = sec mod 60.
;		print, ' writing pha ratres with utc_interval_start_pha_rates: ', utc_interval_start_pha_rates 
;2009  10.000382  0  0 33 0 59.1373  
;		make an approximation of the number of counts for each rate using the sigmas
		mpha_sigma_counts = fltarr(116)
		for i = 0, 115 do begin
			if( mpha_rate_sigma_out(i) gt 0. ) then begin
				mpha_sigma_counts(i) = (mpha_rate_out(i)/mpha_rate_sigma_out(i))^2
				mpha_sigma_counts(i) = floor(mpha_sigma_counts(i) + 0.49)
			endif
		endfor

		for i = 0, (n_elements(rate_lo)-1) do begin
			printf, lun_output(i), year, doy, hour, min, sec, num_avg_ints_pha_rates, format="($,i4, f11.6,  3i3, i5 )"
			for j= rate_lo(i), rate_hi(i) do printf, lun_output(i), mpha_rate_out(j), format=string( num_rates(i), format="( '($,',i0,'e13.4)' )" )
			for j= rate_lo(i), rate_hi(i) do printf, lun_output(i), mpha_sigma_counts(j), format=string( num_rates(i), format="( '($,',i0,'i8)' )" )
;			write out a character to force a line feed
			printf, lun_output(i),' ',format='(a1)'
		endfor

end
