PRO WRITE_PHA,  sitphadata, apid, proc_flag
;
;	writes out PHA data
;
;	Modification history:  
;		11-Mar-2010	change mass panel energy and mass ranges to improve appearance
;						of plots /gm
;		22-Mar-2011	add pha_writes counter to just before line write /gm
;
common calibration
common spacecraft
common box_check
common pha_limits
common stereo_ephem          ; contains ephemeris data returned & misc counters
common lun_numbers
common output_items
common multi_panel_plot_items
common misc_counters

	if(proc_flag eq 4) then goto, writeout

;	print, ' call to write_pha with sitphadata.num_pha = ', sitphadata.num_pha
	ntop = sitphadata.num_pha-1
	if( ntop eq 0 ) then return			; *************** 5/17/2011	
	if(ntop gt 63) then ntop = 63

	   for i = 0, ntop do begin 

;		calculate and format the ephemeris only once per minute of data (apid = 606, event 0):

		if((apid eq 606) and (i eq 0) ) then begin
			current_mjd = double(sitphadata.header.timeCDS.mjd) + double(sitphadata.header.timeCDS.time)/double(86400.*1000)
;			calculate ephemeris data
			stereo_ephemeris, current_mjd
;			build up ephemeris string, which will be added to each pha output line
			ephem_string_pha = string( utc2str(rotated_time(spacecraft_id),/ecs,/truncate), $
				mjd2decyr(rotated_time(spacecraft_id)), mjd2decdoy(rotated_time(spacecraft_id)), gse(0,spacecraft_id)/au_km, gse(1,spacecraft_id)/au_km, gse(2,spacecraft_id)/au_km,  $
				angles, format ='(a23,"," 2(f16.6,","),3(e15.6,","), 3(f8.3,","))'   )			
		ENDIF
	   
	   		amass = amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)
	   		einc = einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id)

; ***** determine which output files will have this event listed *******
			phalist_out = 0
			multi_panel_phalist_out = 0
			multi_panel_smoosh_out = 0
			
			if(pha_out) then $
		   		if(amass ge pha_mlo) then $ 
		   			if(amass le pha_mhi) then $
	   					if(einc ge pha_elo) then $
	   						if(einc le  pha_ehi) then $
	   							if(swoosh_test(einc))then phalist_out = 1
	   							
	   		if(multi_panel_out gt 0) then $
		   		if(amass ge 2.0) then $ 
		   			if(amass le 8.0 ) then $
	   					if(einc ge 0.25) then $
	   						if(einc le  0.9) then $
	   							if(swoosh_test(einc))then multi_panel_phalist_out = 1

	   		if(multi_panel_out gt 0) then $
		   		if(amass gt 8.0) then $ 
		   			if(amass le 70.0 ) then $
	   					if(einc ge 0.08) then $
	   						if(einc le  0.15) then $
	   							if(swoosh_test(einc))then multi_panel_phalist_out = 1

	   							
	   		if(multi_panel_out gt 0) then $
		   		if(amass ge 10.0) then $ 
		   			if(amass le 70.0 ) then $
	   					if(einc ge 0.03) then $
	   						if(einc le  10. ) then $
	   							if(swoosh_test(einc))then multi_panel_smoosh_out = 1

	   		header_string=''
	   		header_string = header_string + string(utc2str(sitphadata.header.timeCDS,/ecs,/truncate),  $
			 mjd2decyr(sitphadata.header.timeCDS), mjd2decdoy(sitphadata.header.timeCDS), $
			 	 format ='(a23,"," 2(f16.6,","))'  )
			 
			if(phalist_out) then begin
				 array = [ amass_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
				 einc_ssd_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
				 einc_tof_array(sitphadata.energy_ch(i),sitphadata.gain(i),sitphadata.tof_ch(i),spacecraft_id), $
				 tof_array(sitphadata.tof_ch(i),spacecraft_id), $
				 energy_array(sitphadata.energy_ch(i),sitphadata.gain(i),spacecraft_id), $
				 sitphadata.tof_ch(i), $
				 sitphadata.energy_ch(i), $
				 sitphadata.gain(i), $
				 sitphadata.priority(i), $
				 sitphadata.tof_flg_1(i), $
				 sitphadata.tof_flg_2(i), $
				 sitphadata.tof_err_proc(i), $
				 sitphadata.matrix_box(i), $
				 apid, calc_matrix_box(i), calc_pri(i), calc_bea_box(i), m_box_err(i), p_box_err(i) ]	

				 write_kal_string, array, print_string
			 
			 	if(n_elements(ephem_string) gt 0) then printf, lun_phalist, header_string + print_string + ephem_string_pha else printf, lun_phalist, header_string + print_string

				pha_writes ++


			ENDIF
			
			if( multi_panel_phalist_out) then printf, lun_multi_mass, header_string, amass,  format='(a0," 0.,", e12.4,",")'
			
			if(multi_panel_smoosh_out) then printf, lun_multi_smoosh,  header_string, amass, einc, format='(a0," 0.,",2(e12.4,","))'
				
			
	ENDFOR
	return

;	write out string to disk (not implemented)
writeout:	return
end
