PRO WRITE_hk,  sithkdata, proc_flag
;
;	computes averages and writes out SIT hk
;
common hk_averages
common calibration
common spacecraft
common last_write_times
common lun_numbers
	
;	calculate the averages and/or put in corrections

	if(num_avg_ints_hk eq 0) then return

	mf_num_av = mf_num_av/num_avg_ints_hk
	tof_gain_av = tof_gain_av/(num_avg_ints_hk*2048.)
	tof_cal_av = tof_cal_av/(num_avg_ints_hk*(-64.))
	tof_cal_err_av = tof_cal_err_av/num_avg_ints_hk
	hk_average = hk_average/num_avg_ints_hk
	sw_version_avg = sw_version_avg/num_avg_ints_hk
	lookup_checksum_avg = lookup_checksum_avg/num_avg_ints_hk

	print_hk_array = fltarr(8)
	CALC_HK, hk_average, print_hk_array
	
	utc_average_hk.mjd = utc_average_hk.mjd/num_avg_ints_hk
	utc_average_hk.time = utc_average_hk.time/num_avg_ints_hk

; before writing output line check to see if the current time is one averaging interval past the prior write;  if not (to 10%) insert a blank line	
;	calculate the current mjd for comparison with last write time

	current_mjd = double(sithkdata_last.header.timeCDS.mjd) + double(sithkdata_last.header.timeCDS.time)/double(86400.*1000)
	if(hk_write_time gt 0) then begin
		if( (abs(current_mjd - hk_write_time) gt 1.1*avg_int_hk/1440.d0) )  then printf, lun_hklist, string( utc2str(utc_average_hk,/ecs,/truncate)) + ',,,,,,,,,,' 
	ENDIF

; now write the output line


	printf, lun_hklist, utc2str(utc_average_hk,/ecs,/truncate),  $
			 mjd2decyr(utc_average_hk), mjd2decdoy(utc_average_hk), num_avg_ints_hk*60./2., $
			 mf_num_av, tof_gain_av, -tof_cal_av, tof_cal_err_av, $
			 print_hk_array, $
			sw_version_avg, lookup_checksum_avg, $
	   		format ='(a23,"," 2(f16.6,","),f8.1,",",12(e12.4,","), 2(z10,","))' 






; update the write time
	hk_write_time = current_mjd
 		
	   		
end
