PRO WRITE_BEACON,  sitbeacondata, proc_flag
;
;	writes out SIT beacon fluxes
;
common beacon_averages
common last_write_times
 common spacecraft
 common stereo_ephem          ; contains ephemeris data returned & misc counters
common lun_numbers
	common output_items

	if(num_avg_ints_beacon eq 0) then return

	het_beacon_avg = het_beacon_avg/(num_avg_ints_beacon)	; no need to divide by 60s since Andrew does that in routine sep_beacon
	sit_beacon_avg = sit_beacon_avg/(num_avg_ints_beacon)
	let_beacon_avg = let_beacon_avg/(num_avg_ints_beacon)
	sept_beacon_avg = sept_beacon_avg/(num_avg_ints_beacon)

	utc_average_beacon.mjd = utc_average_beacon.mjd/num_avg_ints_beacon
	utc_average_beacon.time = utc_average_beacon.time/num_avg_ints_beacon
	
   		header_string=''
   		header_string = header_string + string( utc2str(utc_average_beacon,/ecs,/truncate), $
		mjd2decyr(utc_average_beacon), mjd2decdoy(utc_average_beacon), num_avg_ints_beacon*60./2., format ='(a23,"," 2(f16.6,","),f8.1,",")'   )
		 	 
		 array = [het_beacon_avg, sit_beacon_avg, let_beacon_avg, sept_beacon_avg ]

		 write_kal_string, array, print_string

		
; before writing output line check to see if the current time is one averaging interval past the prior write;  if not (to 10%) insert a blank line	
;	calculate the current mjd for comparison with last write time
	current_mjd = double(utc_average_beacon.mjd) + double(utc_average_beacon.time)/double(86400.*1000)
	if(beacon_write_time gt 0) then begin
		if( (abs(current_mjd - beacon_write_time) gt 1.1*avg_int_beacon/1440.d0) )  then printf, lun_beaconlist, string( utc2str(utc_average_beacon,/ecs,/truncate)) + ',,,,,,,,,,' 
	ENDIF
		
			 
	if( multi_panel_out_sit_a_conjunction eq 0 ) then begin

;		calculate the ephemeris data for this line and tack onto the end of the print string
		current_mjd = double(utc_average_beacon.mjd) + double(utc_average_beacon.time)/double(86400.*1000)
;		calculate ephemeris data
		stereo_ephemeris, current_mjd
;			build up ephemeris string, which will be added to each pha output line
		ephem_string_beacon = string( utc2str(rotated_time(spacecraft_id),/ecs,/truncate), $
			mjd2decyr(rotated_time(spacecraft_id)), mjd2decdoy(rotated_time(spacecraft_id)), gse(0,spacecraft_id)/au_km, gse(1,spacecraft_id)/au_km, gse(2,spacecraft_id)/au_km,  $
			angles, format ='(a23,"," 2(f16.6,","),3(e15.6,","), 3(f8.3,","))'   )
		printf, lun_beaconlist, header_string + print_string + ephem_string_beacon 

	endif else begin

		printf, lun_multi_rate, header_string, 0., sit_beacon_avg(1)*1.8, sit_beacon_avg(5)*1.2, sit_beacon_avg(9)*1.75, $
				format="(a, 4(e12.4,','))"
	endelse


; update the write time
	beacon_write_time = current_mjd



;	   printf, lun_beaconlist, utc2str(utc_average_beacon,/ecs,/truncate),  $
;			 mjd2decyr(utc_average_beacon), mjd2decdoy(utc_average_beacon), num_avg_ints_beacon/2., $
;	   		 het_beacon_avg,sit_beacon_avg,let_beacon_avg,sept_beacon_avg, $
;	   		format ='(a23,"," 2(f16.6,","),f8.1,",",60(e12.4,","))'
	   		
end
