	PRO SWOOSH_ENERGIES, current_mjd
;
;	procedure to calculate maximum and minimum energies for current time & current swoosh interval
;
;		3-Apr-2007	/gm
;
;	note:  calculation is done assuming low energy times correspond to 0.02242 MeV/n (20 hours/AU)
;		high energy times correspond to zero travel time from Sun
;
	common time_bounds
	
;			
;*************************************
;	print, " times: ", t_start_hi(0), t_start_lo(0), t_stop_hi(0), t_stop_lo(0), interval_number, current_mjd

;	for current_mjd = 54100, 54200 do begin

;
;	default case:  (also case if not a swoosh interval)
	swoosh_emax = 1000.
	swoosh_emin = 0.02242
;	print, " swoosh_flag: ", swoosh_flag(interval_number-1)
	if(swoosh_flag(interval_number-1) eq 0) then return
;
;	a swoosh interval
;
;	handle the start times first
	one_ov_v = 20.*(current_mjd - t_start_hi(interval_number-1))/(t_start_lo(interval_number-1) - t_start_hi(interval_number-1))
;	print, " 1/v: ", one_ov_v, current_mjd ,t_start_hi(interval_number-1),t_start_lo(interval_number-1)
	if( (current_mjd ge t_start_hi(interval_number-1)) and (current_mjd lt t_start_lo(interval_number-1))  ) then swoosh_emin = one_ov_v_to_energy(one_ov_v)
;	case of low energy start time before high energy start time
	if( (current_mjd ge t_start_lo(interval_number-1)) and (current_mjd lt t_start_hi(interval_number-1)) ) then swoosh_emax = one_ov_v_to_energy(one_ov_v)
	
;	now the stop times
	one_ov_v = 20.*(current_mjd - t_stop_hi(interval_number-1))/(t_stop_lo(interval_number-1) - t_stop_hi(interval_number-1))
	if( (current_mjd ge t_stop_hi(interval_number-1)) and (current_mjd lt t_stop_lo(interval_number-1))  ) then swoosh_emax = one_ov_v_to_energy(one_ov_v)
;	case of low energy stop time before high energy stop time
	if( (current_mjd ge t_stop_lo(interval_number-1)) and (current_mjd lt t_stop_hi(interval_number-1)) ) then swoosh_emin = one_ov_v_to_energy(one_ov_v)


;	print,  current_mjd,",",swoosh_emin, ",",swoosh_emax,","
;			printf, lun_ratelist,current_mjd,",",swoosh_emin, ",",swoosh_emax,","
;	ENDFOR
;	close,/all

	end