	pro sit_lister_emails, spacecraft_id, inpathname, mjd_start, exit_status_flag
;
;	routine to send output messages if exit status abnormal;  also sends output if daily batch job
;
;	Modification history:
;		23-Feb-2012	initial version /gm
;		10-Jan-2013	add message for status=5
;		7-Mar-2013	add message for status 6,7
;


;	determine if this is a daily batch run by examining the inpathname
	loc = strpos(inpathname, 'update/daily_')
	if(loc ne -1) then begin
		original_year = '2012'
;		if ( spacecraft_id eq 0 ) then command = ' mail -s "SIT A status update" joey@swri.edu < /data/joey/masongm1/Data/Basicrates/STEREO/SIT_A_2012_001_batch.txt' $
;		else command = ' mail -s "SIT B status update" joey@swri.edu < /data/joey/masongm1/Data/Basicrates/STEREO/SIT_B_2012_001_batch.txt'
;		replace the year with the current year value
		mjd2date, mjd_start, year, month, day
		year = strtrim( string(floor(year)), 2)
;		command = replace_text( command, original_year, year)
;		spawn,command
	endif
	
;	now send a message describing exit_status_flag

	if( (exit_status_flag gt 0) and (exit_status_flag lt 7) ) then begin
		case exit_status_flag of 
		1:	command = 'echo "stereo-a unexpected software version" | mail -s "sit lister error status termination" joey@swri.edu'
		2:	command = 'echo "stereo-a lookup table checksum" | mail -s "sit lister error status termination" joey@swri.edu'
		3:	command = 'echo "stereo-b unexpected software version" | mail -s "sit lister error status termination" joey@swri.edu'
		4:	command = 'echo "stereo-b lookup table checksum" | mail -s "sit lister error status termination" joey@swri.edu'
		5:	command = 'echo "stereo ephemeris read in problem" | mail -s "sit lister error status termination" joey@swri.edu'
		6:	command = 'echo "stereo matrix lookup box error" | mail -s "sit lister error status termination" joey@swri.edu'
		7:	command = 'echo "stereo empty pha packet found" | mail -s "sit lister error status termination" joey@swri.edu'
		endcase	
		spawn, command
	endif
;	
	end
	
