PRO	SIT_EFFICIENCIES
;
;	opens file and reads in SIT efficiencies and delta-E values for rom box rates
;		-- later will be done on a time dependent basis
;
;		Oct 19, 2006	/gm
;			2-Mar-2007	delta_e calc moved over to read_sit_box_ranges section
;			21-Mar-2007	change input file to new efficiency values 3/21/07  /gm
;			6-Apr-2007	read in date of efficiency file from the path file /gm
;			25-Aug-2008	read in name of efficiency file (incl date) directly /gm
;
	common mbox_factors
	common spacecraft
	common paths
	

	infile = efficiency_data_path + efficiency_file_name
;	print, ' opening: ', infile
	openr, lun_eff, infile, /get_lun
	
	readf, lun_eff, format='(/)'    ;  skip header line
	for i = 0, 115 do begin
		readf, lun_eff, effic1, effic2
;		readf, lun_eff, effic1, effic2, format='(f6.4, 2f10.4)'
		effic(0,i) = effic1
		effic(1,i) = effic2
	ENDFOR
	
;	adjust the efficiencies of the first 7 rates so that the overall factor is =1 when we divide by geom_factor for other rates 
	for i = 0,6 do effic[*,i] = effic[*,i]/geom_factor
;	close the file
	free_lun, lun_eff
		
	end
