;		SEP_BEACON_COMMON
;+
; Project     :	STEREO - IMPACT, SEP
;
; Name        : SEP_BEACON_COMMON
;
; Purpose     :	setup SEP beacon common block
;               (global constants and variables for SEP beacon processing)
;
; Category    :	STEREO, IMPACT, SEP
;
; Explanation :	
;
; Syntax      :	SEP_BEACON_COMMON
;
; Examples    :	
;
; Inputs      :	
;
; Opt. Inputs :	None.
;
; Outputs     :	
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       : 
;
; Common      : sep_beacon
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 26-Sep-2005, Andrew Davis, Caltech.
;               Version 2 09-Nov-2005
;               Version 3 15-Feb-2005, Andrew Davis, Caltech.
;			Add FILL_L and FILL_D, add HETLIVETIMESCALEFACTOR
;               Version 4 22-Feb-2006, Andrew Davis, Caltech
;                       Set fill-values to ISTP standard, implement byte-swap
;                       if running on little-endian architecture
;               Version 5 26-Mar-2006, Andrew Davis, Caltech
;                       Improve platform-independence byte-swapping code
;               Version 6 26-Apr-2006, Andrew Davis, Caltech
;                       New factors files.
;                       Implemented load_struct per Bill Thompson to do away with temporary files
;
; Contact     :	ad@srl.caltech.edu
;-
;

common sep_b, SEPBDATAFSET, SEPBDATASIZE, LETLIVETIMESCALEFACTOR, $
        HETLIVETIMESCALEFACTOR, DCFSET, $,
	CALFILEPATH, SITACCTIME, SEPTACCTIME, $
	VERSION, NHET, NSIT, NLET, NSEPT, $
	Factors, FILL_D, FILL_L

VERSION = 6B  ; SEP Beacon software version

DCFSET = 60.0D         ; offset to subtract from packet time to get data-collection time

SEPBDATAFSET = 115   ; Byte Offset of SEP Beacon data area in app.data field of IMPACT Beacon Packet
SEPBDATASIZE = 144   ; Size of SEP Beacon data area in IMPACT Beacon Packet

LETLIVETIMESCALEFACTOR = 8192.0D / 3.84E8 ; converts LET raw livetime counter to fractional livetime
HETLIVETIMESCALEFACTOR = 32.0D / 3.84E8 ; converts HET raw livetime counter to fractional livetime
SITACCTIME = 60.0D    ; seconds
SEPTACCTIME = 60.0D   ; seconds

FILL_L = -2147483647L ; long fill-data
FILL_D = -1.0E31 ; double fill-data

; structure to hold conversion factors for each species/energy combination (HET, SIT, SEPT)
factor = { $
	Elo: 0.0D, $
	Ehi: 0.0D, $
	geom: 0.0D, $
	effic: 0.0D $
}

; structure to hold conversion factors for each species/energy combination (LET)
letfactor = { $
	Elo: 0.0D, $
	Ehi: 0.0D, $
	geom: DINDGEN(4), $
	effic: DINDGEN(4) $
}

; the number of beacon rates for each instrument
NHET = 10
NSIT = 12
NLET = 18
NSEPT = 20

HET_fctrs = replicate(factor,NHET)
SIT_fctrs = replicate(factor,NSIT)
LET_fctrs = replicate(letfactor,NLET)
SEPT_fctrs = replicate(factor,NSEPT)

; this structure holds the conversion factors from raw counts to
; physical units for all the species/energy combinations
Factors = { HET_fctrs:HET_fctrs, SIT_fctrs:SIT_fctrs, $
	LET_fctrs:LET_fctrs, SEPT_fctrs:SEPT_fctrs $
}

